/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkMultiple;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PngChunkSPLT
extends PngChunkMultiple {
    public static final String ID = "sPLT";
    private String palName;
    private int sampledepth;
    private int[] palette;

    public PngChunkSPLT(ImageInfo info) {
        super(ID, info);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    public ChunkRaw createRawChunk() {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ba.write(ChunkHelper.toBytes(this.palName));
            ba.write(0);
            ba.write((byte)this.sampledepth);
            int nentries = this.getNentries();
            for (int n = 0; n < nentries; ++n) {
                for (int i = 0; i < 4; ++i) {
                    if (this.sampledepth == 8) {
                        PngHelperInternal.writeByte((OutputStream)ba, (byte)this.palette[n * 5 + i]);
                        continue;
                    }
                    PngHelperInternal.writeInt2(ba, this.palette[n * 5 + i]);
                }
                PngHelperInternal.writeInt2(ba, this.palette[n * 5 + 4]);
            }
            byte[] b = ba.toByteArray();
            ChunkRaw chunk = this.createEmptyChunk(b.length, false);
            chunk.data = b;
            return chunk;
        }
        catch (IOException e) {
            throw new PngjException(e);
        }
    }

    public void parseFromRaw(ChunkRaw c) {
        int t = -1;
        for (int i = 0; i < c.data.length; ++i) {
            if (c.data[i] != 0) continue;
            t = i;
            break;
        }
        if (t <= 0 || t > c.data.length - 2) {
            throw new PngjException("bad sPLT chunk: no separator found");
        }
        this.palName = ChunkHelper.toString(c.data, 0, t);
        this.sampledepth = PngHelperInternal.readInt1fromByte(c.data, t + 1);
        int nentries = (c.data.length - (t += 2)) / (this.sampledepth == 8 ? 6 : 10);
        this.palette = new int[nentries * 5];
        int ne = 0;
        for (int i = 0; i < nentries; ++i) {
            int a;
            int b;
            int g;
            int r;
            if (this.sampledepth == 8) {
                r = PngHelperInternal.readInt1fromByte(c.data, t++);
                g = PngHelperInternal.readInt1fromByte(c.data, t++);
                b = PngHelperInternal.readInt1fromByte(c.data, t++);
                a = PngHelperInternal.readInt1fromByte(c.data, t++);
            } else {
                r = PngHelperInternal.readInt2fromBytes(c.data, t);
                g = PngHelperInternal.readInt2fromBytes(c.data, t += 2);
                b = PngHelperInternal.readInt2fromBytes(c.data, t += 2);
                a = PngHelperInternal.readInt2fromBytes(c.data, t += 2);
                t += 2;
            }
            int f = PngHelperInternal.readInt2fromBytes(c.data, t);
            t += 2;
            this.palette[ne++] = r;
            this.palette[ne++] = g;
            this.palette[ne++] = b;
            this.palette[ne++] = a;
            this.palette[ne++] = f;
        }
    }

    public int getNentries() {
        return this.palette.length / 5;
    }

    public String getPalName() {
        return this.palName;
    }

    public void setPalName(String palName) {
        this.palName = palName;
    }

    public int getSampledepth() {
        return this.sampledepth;
    }

    public void setSampledepth(int sampledepth) {
        this.sampledepth = sampledepth;
    }

    public int[] getPalette() {
        return this.palette;
    }

    public void setPalette(int[] palette) {
        this.palette = palette;
    }
}

