/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.core.IAugmentable;
import cofh.api.core.ISecurable;
import cofh.api.item.IAugmentItem;
import cofh.api.item.IUpgradeItem;
import cofh.api.tileentity.ITransferControl;
import cofh.api.tileentity.IUpgradeable;
import cofh.core.block.TileRSControl;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCore;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileAugmentableSecure
extends TileRSControl
implements IAugmentable,
ISecurable,
ITransferControl,
IUpgradeable,
IWorldNameable {
    public static final int BASE_AUGMENTS = 0;
    protected boolean[] augmentStatus = new boolean[this.getNumAugmentSlots(0)];
    protected ItemStack[] augments = new ItemStack[this.getNumAugmentSlots(0)];
    protected GameProfile owner = CoreProps.DEFAULT_OWNER;
    protected ISecurable.AccessMode access = ISecurable.AccessMode.PUBLIC;
    protected boolean canAccess = true;
    protected byte level = 0;
    protected boolean hasAutoInput = false;
    protected boolean hasAutoOutput = false;
    protected boolean hasRedstoneControl = false;
    public boolean isCreative = false;
    protected boolean enableAutoInput = false;
    protected boolean enableAutoOutput = false;
    protected static final int[] FLUID_TRANSFER = new int[]{1000, 1000, 3000, 6000, 10000};
    protected static final int[] ITEM_TRANSFER = new int[]{16, 16, 28, 44, 64};

    public boolean isAugmentable() {
        return this.augments.length > 0;
    }

    public boolean isSecured() {
        return !SecurityHelper.isDefaultUUID(this.owner.getId());
    }

    public boolean enableSecurity() {
        return true;
    }

    public final boolean hasRedstoneControl() {
        return this.hasRedstoneControl;
    }

    protected boolean setLevel(int level) {
        if (level >= 0) {
            if (level > 4) {
                level = 4;
            }
            this.level = (byte)level;
        }
        if (this.augments.length > 0) {
            int i;
            ItemStack[] tempAugments = new ItemStack[this.augments.length];
            for (i = 0; i < this.augments.length; ++i) {
                tempAugments[i] = this.augments[i].func_190926_b() ? ItemStack.field_190927_a : this.augments[i].func_77946_l();
            }
            this.augments = new ItemStack[this.getNumAugmentSlots(level)];
            Arrays.fill(this.augments, ItemStack.field_190927_a);
            for (i = 0; i < tempAugments.length; ++i) {
                this.augments[i] = tempAugments[i].func_190926_b() ? ItemStack.field_190927_a : tempAugments[i].func_77946_l();
            }
            this.augmentStatus = new boolean[this.getNumAugmentSlots(level)];
        } else {
            this.augments = new ItemStack[this.getNumAugmentSlots(level)];
            Arrays.fill(this.augments, ItemStack.field_190927_a);
            this.augmentStatus = new boolean[this.getNumAugmentSlots(level)];
        }
        this.setLevelFlags();
        return true;
    }

    protected int getFluidTransfer(int level) {
        return FLUID_TRANSFER[MathHelper.clamp(level, 0, 4)];
    }

    protected int getNumAugmentSlots(int level) {
        return 0 + level;
    }

    protected void setLevelFlags() {
        this.hasAutoInput = false;
        this.hasAutoOutput = false;
        this.hasRedstoneControl = false;
        if (this.level >= this.getLevelAutoInput()) {
            this.hasAutoInput = true;
        }
        if (this.level >= this.getLevelAutoOutput()) {
            this.hasAutoOutput = true;
        }
        if (this.level >= this.getLevelRSControl()) {
            this.hasRedstoneControl = true;
        }
    }

    protected int getLevelAutoInput() {
        return 0;
    }

    protected int getLevelAutoOutput() {
        return 0;
    }

    protected int getLevelRSControl() {
        return 0;
    }

    @Override
    public void receiveGuiNetworkData(int id, int data) {
        this.canAccess = data != 0;
    }

    @Override
    public void sendGuiNetworkData(Container container, IContainerListener listener) {
        super.sendGuiNetworkData(container, listener);
        if (listener instanceof EntityPlayer) {
            listener.func_71112_a(container, 0, this.canPlayerAccess((EntityPlayer)listener) ? 1 : 0);
        }
    }

    public boolean canAccess() {
        return this.canAccess;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (this.canPlayerAccess(player)) {
            if (this.hasGui()) {
                player.openGui(this.getMod(), 0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            }
            return this.hasGui();
        }
        if (ServerHelper.isServerWorld(this.field_145850_b)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.secure.warning", new Object[]{this.getOwnerName()}));
        }
        return this.hasGui();
    }

    @Override
    public boolean openConfigGui(EntityPlayer player) {
        if (this.canPlayerAccess(player)) {
            if (this.hasConfigGui()) {
                player.openGui(this.getMod(), 1, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            }
            return this.hasConfigGui();
        }
        if (ServerHelper.isServerWorld(this.field_145850_b)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.secure.warning", new Object[]{this.getOwnerName()}));
        }
        return this.hasConfigGui();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.owner = CoreProps.DEFAULT_OWNER;
        this.access = ISecurable.AccessMode.values()[nbt.func_74771_c("Access")];
        String uuid = nbt.func_74779_i("OwnerUUID");
        String name = nbt.func_74779_i("Owner");
        GameProfile profile = new GameProfile(UUID.fromString(uuid), name);
        if (!CoreProps.DEFAULT_OWNER.equals((Object)profile)) {
            if (!Strings.isNullOrEmpty((String)uuid)) {
                this.setOwner(profile);
            } else if (!Strings.isNullOrEmpty((String)name)) {
                this.setOwnerName(name);
            }
        }
        if (!this.enableSecurity()) {
            this.access = ISecurable.AccessMode.PUBLIC;
        }
        this.level = nbt.func_74771_c("Level");
        this.isCreative = nbt.func_74767_n("Creative");
        this.enableAutoInput = nbt.func_74767_n("EnableIn");
        this.enableAutoOutput = nbt.func_74767_n("EnableOut");
        this.setLevel(this.level);
        this.readAugmentsFromNBT(nbt);
        this.updateAugmentStatus();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Access", (byte)this.access.ordinal());
        nbt.func_74778_a("OwnerUUID", this.owner.getId().toString());
        nbt.func_74778_a("Owner", this.owner.getName());
        nbt.func_74774_a("Level", this.level);
        nbt.func_74757_a("Creative", this.isCreative);
        nbt.func_74757_a("EnableIn", this.enableAutoInput);
        nbt.func_74757_a("EnableOut", this.enableAutoOutput);
        this.writeAugmentsToNBT(nbt);
        return nbt;
    }

    public void readAugmentsFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Augments", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            if (slot < 0 || slot >= this.augments.length) continue;
            this.augments[slot] = new ItemStack(tag);
        }
    }

    public void writeAugmentsToNBT(NBTTagCompound nbt) {
        if (this.augments.length <= 0) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.augments.length; ++i) {
            if (this.augments[i].func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            this.augments[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Augments", (NBTBase)list);
    }

    @Override
    public PacketBase getAccessPacket() {
        PacketBase payload = super.getAccessPacket();
        payload.addByte((byte)this.access.ordinal());
        return payload;
    }

    @Override
    protected void handleAccessPacket(PacketBase payload) {
        super.handleAccessPacket(payload);
        this.access = ISecurable.AccessMode.values()[payload.getByte()];
        this.callBlockUpdate();
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addByte((byte)this.access.ordinal());
        payload.addUUID(this.owner.getId());
        payload.addString(this.owner.getName());
        payload.addByte(this.level);
        payload.addBool(this.isCreative);
        payload.addBool(this.hasAutoInput);
        payload.addBool(this.hasAutoOutput);
        payload.addBool(this.hasRedstoneControl);
        payload.addBool(this.enableAutoInput);
        payload.addBool(this.enableAutoOutput);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.access = ISecurable.AccessMode.values()[payload.getByte()];
        this.owner = CoreProps.DEFAULT_OWNER;
        this.setOwner(new GameProfile(payload.getUUID(), payload.getString()));
        byte tmpLevel = payload.getByte();
        this.isCreative = payload.getBool();
        this.hasAutoInput = payload.getBool();
        this.hasAutoOutput = payload.getBool();
        this.hasRedstoneControl = payload.getBool();
        this.enableAutoInput = payload.getBool();
        this.enableAutoOutput = payload.getBool();
        if (tmpLevel != this.level) {
            this.setLevel(tmpLevel);
        }
    }

    protected void preAugmentInstall() {
    }

    protected void postAugmentInstall() {
    }

    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        return false;
    }

    protected boolean installAugmentToSlot(int slot) {
        return false;
    }

    @Override
    public boolean installAugment(ItemStack augment) {
        if (!this.isValidAugment(augment)) {
            return false;
        }
        for (int i = 0; i < this.augments.length; ++i) {
            if (!this.augments[i].func_190926_b()) continue;
            this.augments[i] = ItemHelper.cloneStack(augment, 1);
            this.updateAugmentStatus();
            this.markChunkDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidAugment(ItemStack augment) {
        if (!AugmentHelper.isAugmentItem(augment)) {
            return false;
        }
        return this.isValidAugment(AugmentHelper.getAugmentType(augment), AugmentHelper.getAugmentIdentifier(augment));
    }

    @Override
    public ItemStack[] getAugmentSlots() {
        return this.augments;
    }

    @Override
    public void updateAugmentStatus() {
        this.preAugmentInstall();
        for (int i = 0; i < this.augments.length; ++i) {
            this.augmentStatus[i] = false;
            if (!AugmentHelper.isAugmentItem(this.augments[i])) continue;
            this.augmentStatus[i] = this.installAugmentToSlot(i);
        }
        this.postAugmentInstall();
    }

    @Override
    public boolean setAccess(ISecurable.AccessMode access) {
        this.access = access;
        if (ServerHelper.isClientWorld(this.field_145850_b)) {
            this.sendAccessPacket();
        }
        return true;
    }

    @Override
    public boolean setOwnerName(String name) {
        if (this.owner != CoreProps.DEFAULT_OWNER) {
            return false;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)name) || CoreProps.DEFAULT_OWNER.getName().equalsIgnoreCase(name)) {
            return false;
        }
        String uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)server, (String)name);
        if (Strings.isNullOrEmpty((String)uuid)) {
            return false;
        }
        return this.setOwner(new GameProfile(UUID.fromString(uuid), name));
    }

    @Override
    public boolean setOwner(GameProfile profile) {
        if (this.owner != CoreProps.DEFAULT_OWNER) {
            return false;
        }
        if (SecurityHelper.isDefaultUUID(this.owner.getId())) {
            this.owner = profile;
            if (!SecurityHelper.isDefaultUUID(this.owner.getId())) {
                if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                    new Thread("CoFH User Loader"){

                        @Override
                        public void run() {
                            TileAugmentableSecure.this.owner = SecurityHelper.getProfile(TileAugmentableSecure.this.owner.getId(), TileAugmentableSecure.this.owner.getName());
                        }
                    }.start();
                }
                if (this.field_145850_b != null) {
                    this.markChunkDirty();
                    this.sendTilePacket(Side.CLIENT);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    @Override
    public String getOwnerName() {
        String name = this.owner.getName();
        if (name == null) {
            return StringHelper.localize("info.cofh.anotherplayer");
        }
        return name;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public boolean hasTransferIn() {
        return this.hasAutoInput;
    }

    @Override
    public boolean hasTransferOut() {
        return this.hasAutoOutput;
    }

    @Override
    public boolean getTransferIn() {
        return this.hasTransferIn() && this.enableAutoInput;
    }

    @Override
    public boolean getTransferOut() {
        return this.hasTransferOut() && this.enableAutoOutput;
    }

    @Override
    public boolean setTransferIn(boolean input) {
        if (!this.hasAutoInput) {
            return false;
        }
        this.enableAutoInput = input;
        if (ServerHelper.isClientWorld(this.field_145850_b)) {
            PacketCore.sendTransferUpdatePacketToServer(this, this.field_174879_c);
        } else {
            this.sendTilePacket(Side.CLIENT);
        }
        return true;
    }

    @Override
    public boolean setTransferOut(boolean output) {
        if (!this.hasAutoOutput) {
            return false;
        }
        this.enableAutoOutput = output;
        if (ServerHelper.isClientWorld(this.field_145850_b)) {
            PacketCore.sendTransferUpdatePacketToServer(this, this.field_174879_c);
        } else {
            this.sendTilePacket(Side.CLIENT);
        }
        return true;
    }

    @Override
    public boolean canUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem(upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        byte uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel != this.level + 1) break;
                return true;
            }
            case FULL: {
                if (uLevel <= this.level) break;
                return true;
            }
            case CREATIVE: {
                return !this.isCreative;
            }
        }
        return false;
    }

    @Override
    public boolean installUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem(upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        byte uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel == this.level + 1) {
                    this.setLevel(uLevel);
                    break;
                }
                return false;
            }
            case FULL: {
                if (uLevel > this.level) {
                    this.setLevel(uLevel);
                    break;
                }
                return false;
            }
            case ENDER: {
                return false;
            }
            case CREATIVE: {
                if (this.isCreative) {
                    return false;
                }
                if (this.level >= 0) {
                    this.isCreative = true;
                    this.setLevel(4);
                    break;
                }
                return false;
            }
        }
        this.updateAugmentStatus();
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public String func_70005_c_() {
        return this.customName.isEmpty() ? this.getTileName() : this.customName;
    }

    public boolean func_145818_k_() {
        return !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }
}

