/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.client.gui.GuiCombiner;
import mekanism.client.gui.GuiCrusher;
import mekanism.client.gui.GuiElectrolyticSeparator;
import mekanism.client.gui.GuiEnergizedSmelter;
import mekanism.client.gui.GuiEnrichmentChamber;
import mekanism.client.gui.GuiMetallurgicInfuser;
import mekanism.client.gui.GuiOsmiumCompressor;
import mekanism.client.gui.GuiPRC;
import mekanism.client.gui.GuiPrecisionSawmill;
import mekanism.client.gui.GuiPurificationChamber;
import mekanism.client.gui.GuiRotaryCondensentrator;
import mekanism.client.gui.GuiSolarNeutronActivator;
import mekanism.client.gui.GuiThermalEvaporationController;
import mekanism.client.gui.chemical.GuiChemicalCrystallizer;
import mekanism.client.gui.chemical.GuiChemicalDissolutionChamber;
import mekanism.client.gui.chemical.GuiChemicalInfuser;
import mekanism.client.gui.chemical.GuiChemicalInjectionChamber;
import mekanism.client.gui.chemical.GuiChemicalOxidizer;
import mekanism.client.gui.chemical.GuiChemicalWasher;
import mekanism.client.jei.machine.AdvancedMachineRecipeWrapper;
import mekanism.client.jei.machine.ChanceMachineRecipeWrapper;
import mekanism.client.jei.machine.DoubleMachineRecipeWrapper;
import mekanism.client.jei.machine.MachineRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalCrystallizerRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalDissolutionChamberRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalInfuserRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeWrapper;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeWrapper;
import mekanism.client.jei.machine.other.ElectrolyticSeparatorRecipeWrapper;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeWrapper;
import mekanism.client.jei.machine.other.PRCRecipeWrapper;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeWrapper;
import mekanism.client.jei.machine.other.SolarNeutronRecipeWrapper;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeWrapper;
import mekanism.common.Mekanism;
import mekanism.common.base.IFactory;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.integration.crafttweaker.handlers.EnergizedSmelter;
import mekanism.common.inventory.container.ContainerFormulaicAssemblicator;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.item.crafting.FurnaceRecipes;

public class RecipeRegistryHelper {
    public static void registerEnrichmentChamber(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.ENRICHMENT_CHAMBER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.ENRICHMENT_CHAMBER, MachineRecipeWrapper::new);
        registry.addRecipeClickArea(GuiEnrichmentChamber.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.ENRICHMENT_CHAMBER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.ENRICHMENT_CHAMBER, RecipeHandler.Recipe.ENRICHMENT_CHAMBER);
    }

    public static void registerCrusher(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.CRUSHER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.CRUSHER, MachineRecipeWrapper::new);
        registry.addRecipeClickArea(GuiCrusher.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.CRUSHER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.CRUSHER, RecipeHandler.Recipe.CRUSHER);
    }

    public static void registerCombiner(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.COMBINER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.COMBINER, DoubleMachineRecipeWrapper::new);
        registry.addRecipeClickArea(GuiCombiner.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.COMBINER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.COMBINER, RecipeHandler.Recipe.COMBINER);
    }

    public static void registerPurification(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.PURIFICATION_CHAMBER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.PURIFICATION_CHAMBER, AdvancedMachineRecipeWrapper::new);
        registry.addRecipeClickArea(GuiPurificationChamber.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.PURIFICATION_CHAMBER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.PURIFICATION_CHAMBER, RecipeHandler.Recipe.PURIFICATION_CHAMBER);
    }

    public static void registerCompressor(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.OSMIUM_COMPRESSOR.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.OSMIUM_COMPRESSOR, AdvancedMachineRecipeWrapper::new);
        registry.addRecipeClickArea(GuiOsmiumCompressor.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.OSMIUM_COMPRESSOR.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.OSMIUM_COMPRESSOR, RecipeHandler.Recipe.OSMIUM_COMPRESSOR);
    }

    public static void registerInjection(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER, AdvancedMachineRecipeWrapper::new);
        registry.addRecipeClickArea(GuiChemicalInjectionChamber.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER);
    }

    public static void registerSawmill(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.PRECISION_SAWMILL.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.PRECISION_SAWMILL, ChanceMachineRecipeWrapper::new);
        registry.addRecipeClickArea(GuiPrecisionSawmill.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.PRECISION_SAWMILL.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.PRECISION_SAWMILL, RecipeHandler.Recipe.PRECISION_SAWMILL);
    }

    public static void registerMetallurgicInfuser(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.METALLURGIC_INFUSER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.METALLURGIC_INFUSER, MetallurgicInfuserRecipeWrapper::new);
        registry.addRecipeClickArea(GuiMetallurgicInfuser.class, 72, 47, 32, 8, new String[]{RecipeHandler.Recipe.METALLURGIC_INFUSER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.METALLURGIC_INFUSER, RecipeHandler.Recipe.METALLURGIC_INFUSER);
    }

    public static void registerCrystallizer(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER, ChemicalCrystallizerRecipeWrapper::new);
        registry.addRecipeClickArea(GuiChemicalCrystallizer.class, 53, 62, 48, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER, RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER);
    }

    public static void registerDissolution(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER, ChemicalDissolutionChamberRecipeWrapper::new);
        registry.addRecipeClickArea(GuiChemicalDissolutionChamber.class, 64, 40, 48, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER);
    }

    public static void registerChemicalInfuser(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.CHEMICAL_INFUSER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_INFUSER, ChemicalInfuserRecipeWrapper::new);
        registry.addRecipeClickArea(GuiChemicalInfuser.class, 47, 39, 28, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_INFUSER.getJEICategory()});
        registry.addRecipeClickArea(GuiChemicalInfuser.class, 101, 39, 28, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_INFUSER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_INFUSER, RecipeHandler.Recipe.CHEMICAL_INFUSER);
    }

    public static void registerOxidizer(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.CHEMICAL_OXIDIZER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_OXIDIZER, ChemicalOxidizerRecipeWrapper::new);
        registry.addRecipeClickArea(GuiChemicalOxidizer.class, 64, 40, 48, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_OXIDIZER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_OXIDIZER, RecipeHandler.Recipe.CHEMICAL_OXIDIZER);
    }

    public static void registerWasher(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.CHEMICAL_WASHER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.CHEMICAL_WASHER, ChemicalWasherRecipeWrapper::new);
        registry.addRecipeClickArea(GuiChemicalWasher.class, 61, 39, 55, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_WASHER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.CHEMICAL_WASHER, RecipeHandler.Recipe.CHEMICAL_WASHER);
    }

    public static void registerNeutronActivator(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR, SolarNeutronRecipeWrapper::new);
        registry.addRecipeClickArea(GuiSolarNeutronActivator.class, 64, 39, 48, 8, new String[]{RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR, RecipeHandler.Recipe.SOLAR_NEUTRON_ACTIVATOR);
    }

    public static void registerSeparator(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR, ElectrolyticSeparatorRecipeWrapper::new);
        registry.addRecipeClickArea(GuiElectrolyticSeparator.class, 80, 30, 16, 6, new String[]{RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR);
    }

    public static void registerEvaporationPlant(IModRegistry registry) {
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT, ThermalEvaporationRecipeWrapper::new);
        registry.addRecipeClickArea(GuiThermalEvaporationController.class, 49, 20, 78, 38, new String[]{RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.getJEICategory()});
        registry.addRecipeCatalyst((Object)BlockStateBasic.BasicBlockType.THERMAL_EVAPORATION_CONTROLLER.getStack(1), new String[]{RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.getJEICategory()});
    }

    public static void registerReactionChamber(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER.isEnabled()) {
            return;
        }
        RecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER, PRCRecipeWrapper::new);
        registry.addRecipeClickArea(GuiPRC.class, 75, 37, 36, 10, new String[]{RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER.getJEICategory()});
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER, RecipeHandler.Recipe.PRESSURIZED_REACTION_CHAMBER);
    }

    public static void registerCondensentrator(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR.isEnabled()) {
            return;
        }
        ArrayList<RotaryCondensentratorRecipeWrapper> condensentratorRecipes = new ArrayList<RotaryCondensentratorRecipeWrapper>();
        ArrayList<RotaryCondensentratorRecipeWrapper> decondensentratorRecipes = new ArrayList<RotaryCondensentratorRecipeWrapper>();
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            if (!gas.hasFluid()) continue;
            condensentratorRecipes.add(new RotaryCondensentratorRecipeWrapper(gas.getFluid(), gas, true));
            decondensentratorRecipes.add(new RotaryCondensentratorRecipeWrapper(gas.getFluid(), gas, false));
        }
        String condensentrating = "mekanism.rotary_condensentrator_condensentrating";
        String decondensentrating = "mekanism.rotary_condensentrator_decondensentrating";
        registry.addRecipes(condensentratorRecipes, condensentrating);
        registry.addRecipes(decondensentratorRecipes, decondensentrating);
        registry.addRecipeClickArea(GuiRotaryCondensentrator.class, 64, 39, 48, 8, new String[]{condensentrating, decondensentrating});
        registry.addRecipeCatalyst((Object)BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR.getStack(), new String[]{condensentrating, decondensentrating});
    }

    public static void registerSmelter(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.ENERGIZED_SMELTER.isEnabled()) {
            return;
        }
        registry.handleRecipes(SmeltingRecipe.class, MachineRecipeWrapper::new, RecipeHandler.Recipe.ENERGIZED_SMELTER.getJEICategory());
        if (Mekanism.hooks.CraftTweakerLoaded && EnergizedSmelter.hasRemovedRecipe()) {
            Collection<SmeltingRecipe> recipeList = RecipeHandler.Recipe.ENERGIZED_SMELTER.get().values();
            registry.addRecipes((Collection)recipeList.stream().map(MachineRecipeWrapper::new).collect(Collectors.toList()), RecipeHandler.Recipe.ENERGIZED_SMELTER.getJEICategory());
            registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{RecipeHandler.Recipe.ENERGIZED_SMELTER.getJEICategory()});
        } else if (Mekanism.hooks.CraftTweakerLoaded && EnergizedSmelter.hasAddedRecipe()) {
            HashMap<ItemStackInput, SmeltingRecipe> smeltingRecipes = RecipeHandler.Recipe.ENERGIZED_SMELTER.get();
            List smeltingWrapper = smeltingRecipes.entrySet().stream().filter(entry -> !FurnaceRecipes.func_77602_a().func_77599_b().keySet().contains(((ItemStackInput)entry.getKey()).ingredient)).map(entry -> new MachineRecipeWrapper<BasicMachineRecipe>((BasicMachineRecipe)entry.getValue())).collect(Collectors.toList());
            registry.addRecipes(smeltingWrapper, RecipeHandler.Recipe.ENERGIZED_SMELTER.getJEICategory());
            registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{"minecraft.smelting", RecipeHandler.Recipe.ENERGIZED_SMELTER.getJEICategory()});
            RecipeRegistryHelper.registerVanillaSmeltingRecipeCatalyst(registry);
        } else {
            registry.addRecipeClickArea(GuiEnergizedSmelter.class, 79, 40, 24, 7, new String[]{"minecraft.smelting"});
            RecipeRegistryHelper.registerVanillaSmeltingRecipeCatalyst(registry);
        }
        RecipeRegistryHelper.registerRecipeItem(registry, BlockStateMachine.MachineType.ENERGIZED_SMELTER, RecipeHandler.Recipe.ENERGIZED_SMELTER);
    }

    public static void registerFormulaicAssemblicator(IModRegistry registry) {
        if (!BlockStateMachine.MachineType.FORMULAIC_ASSEMBLICATOR.isEnabled()) {
            return;
        }
        registry.addRecipeCatalyst((Object)BlockStateMachine.MachineType.FORMULAIC_ASSEMBLICATOR.getStack(), new String[]{"minecraft.crafting"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerFormulaicAssemblicator.class, "minecraft.crafting", 20, 9, 35, 36);
    }

    private static void registerVanillaSmeltingRecipeCatalyst(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)BlockStateMachine.MachineType.ENERGIZED_SMELTER.getStack(), new String[]{"minecraft.smelting"});
        FactoryTier.forEnabled(tier -> registry.addRecipeCatalyst((Object)MekanismUtils.getFactory(tier, IFactory.RecipeType.SMELTING), new String[]{"minecraft.smelting"}));
    }

    private static <INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>> void addRecipes(IModRegistry registry, RecipeHandler.Recipe<INPUT, OUTPUT, RECIPE> type, IRecipeWrapperFactory<RECIPE> factory) {
        String recipeCategoryUid = type.getJEICategory();
        registry.handleRecipes(type.getRecipeClass(), factory, recipeCategoryUid);
        registry.addRecipes((Collection)type.get().values().stream().map(arg_0 -> factory.getRecipeWrapper(arg_0)).collect(Collectors.toList()), recipeCategoryUid);
    }

    private static void registerRecipeItem(IModRegistry registry, BlockStateMachine.MachineType type, RecipeHandler.Recipe recipe) {
        registry.addRecipeCatalyst((Object)type.getStack(), new String[]{recipe.getJEICategory()});
        IFactory.RecipeType factoryType = null;
        for (IFactory.RecipeType t : IFactory.RecipeType.values()) {
            if (t.getType() != type) continue;
            factoryType = t;
            break;
        }
        if (factoryType != null) {
            IFactory.RecipeType finalFactoryType = factoryType;
            FactoryTier.forEnabled(tier -> registry.addRecipeCatalyst((Object)MekanismUtils.getFactory(tier, finalFactoryType), new String[]{recipe.getJEICategory()}));
        }
    }
}

