/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class InventoryNetwork
extends DynamicNetwork<TileEntity, InventoryNetwork, Void> {
    public InventoryNetwork() {
    }

    public InventoryNetwork(Collection<InventoryNetwork> networks) {
        for (InventoryNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    public List<AcceptorData> calculateAcceptors(TransitRequest request, TransporterStack stack) {
        ArrayList<AcceptorData> toReturn = new ArrayList<AcceptorData>();
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity acceptor;
            EnumSet sides;
            if (coord == null || coord.equals(stack.homeLocation) || (sides = (EnumSet)this.acceptorDirections.get(coord)) == null || sides.isEmpty() || (acceptor = coord.getTileEntity((IBlockAccess)this.getWorld())) == null) continue;
            AcceptorData data = null;
            for (EnumFacing side : sides) {
                EnumFacing opposite = side.func_176734_d();
                TransitRequest.TransitResponse response = TransporterManager.getPredictedInsert(acceptor, stack.color, request, opposite);
                if (response.isEmpty()) continue;
                if (data == null) {
                    data = new AcceptorData(coord, response, opposite);
                    toReturn.add(data);
                    continue;
                }
                data.sides.add(opposite);
            }
        }
        return toReturn;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            // empty if block
        }
    }

    @Override
    public void absorbBuffer(IGridTransmitter<TileEntity, InventoryNetwork, Void> transmitter) {
    }

    @Override
    public void clampBuffer() {
    }

    public String toString() {
        return "[InventoryNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public String getNeededInfo() {
        return null;
    }

    @Override
    public String getStoredInfo() {
        return null;
    }

    @Override
    public String getFlowInfo() {
        return null;
    }

    public static class AcceptorData {
        private Coord4D location;
        private TransitRequest.TransitResponse response;
        private Set<EnumFacing> sides;

        public AcceptorData(Coord4D coord, TransitRequest.TransitResponse ret, EnumFacing side) {
            this.location = coord;
            this.response = ret;
            this.sides = EnumSet.of(side);
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public Coord4D getLocation() {
            return this.location;
        }

        public Set<EnumFacing> getSides() {
            return this.sides;
        }
    }
}

