/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import mekanism.common.base.target.FluidHandlerTarget;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public final class PipeUtils {
    public static final FluidTankInfo[] EMPTY = new FluidTankInfo[0];

    public static boolean isValidAcceptorOnSide(TileEntity tile, EnumFacing side) {
        if (tile == null || CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()) || !CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            return false;
        }
        IFluidHandler container = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (container == null) {
            return false;
        }
        IFluidTankProperties[] infoArray = container.getTankProperties();
        if (infoArray != null && infoArray.length > 0) {
            for (IFluidTankProperties info : infoArray) {
                if (info == null) continue;
                return true;
            }
        }
        return false;
    }

    public static IFluidHandler[] getConnectedAcceptors(BlockPos pos, World world) {
        IFluidHandler[] acceptors = new IFluidHandler[]{null, null, null, null, null, null};
        EmitUtils.forEachSide(world, pos, EnumSet.allOf(EnumFacing.class), (tile, side) -> {
            acceptors[side.ordinal()] = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        });
        return acceptors;
    }

    public static int emit(Set<EnumFacing> sides, FluidStack stack, TileEntity from) {
        if (stack == null || stack.amount == 0) {
            return 0;
        }
        FluidHandlerTarget target = new FluidHandlerTarget(stack);
        EmitUtils.forEachSide(from.func_145831_w(), from.func_174877_v(), sides, (acceptor, side) -> {
            EnumFacing accessSide = side.func_176734_d();
            CapabilityUtils.runIfCap((ICapabilityProvider)acceptor, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, accessSide, handler -> {
                if (PipeUtils.canFill(handler, stack)) {
                    target.addHandler(accessSide, handler);
                }
            });
        });
        int curHandlers = target.getHandlers().size();
        if (curHandlers > 0) {
            HashSet<FluidHandlerTarget> targets = new HashSet<FluidHandlerTarget>();
            targets.add(target);
            return EmitUtils.sendToAcceptors(targets, curHandlers, stack.amount, stack);
        }
        return 0;
    }

    public static FluidStack copy(FluidStack fluid, int amount) {
        FluidStack ret = fluid.copy();
        ret.amount = amount;
        return ret;
    }

    public static boolean canFill(IFluidHandler handler, FluidStack stack) {
        for (IFluidTankProperties props : handler.getTankProperties()) {
            if (!props.canFillFluidType(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean canDrain(IFluidHandler handler, FluidStack stack) {
        for (IFluidTankProperties props : handler.getTankProperties()) {
            if (!props.canDrainFluidType(stack)) continue;
            return true;
        }
        return false;
    }
}

