/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ToolboxHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IERecipes;
import blusunrize.immersiveengineering.common.blocks.BlockIEFluid;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TConstructHelper
extends IECompatModule {
    public static final slimeknights.tconstruct.library.materials.Material treatedWood = new slimeknights.tconstruct.library.materials.Material("treatedwood", 6632738);
    public static final slimeknights.tconstruct.library.materials.Material constantan = new slimeknights.tconstruct.library.materials.Material("constantan", 15761770);
    public static final slimeknights.tconstruct.library.materials.Material hemp = new slimeknights.tconstruct.library.materials.Material("hemp", 10914680);
    public static final AbstractTrait thermalInversion = new TraitThermalInversion();
    public static Fluid fluidUranium = IEContent.setupFluid(new FluidColouredMetal("uranium", 5858642, 600));
    public static Block blockMoltenUranium;
    public static Fluid fluidConstantan;
    public static Block blockMoltenConstantan;

    @Override
    public void preInit() {
        TConstructHelper.sendAlloyForMelting(new FluidStack(fluidConstantan, 2), "copper", 1, "nickel", 1);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"blacklistMelting", (ItemStack)new ItemStack((Item)IEContent.itemBullet, 1, Short.MAX_VALUE));
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"blacklistMelting", (ItemStack)new ItemStack((Item)IEContent.itemDrillhead, 1, Short.MAX_VALUE));
        TinkerRegistry.addMaterialStats((slimeknights.tconstruct.library.materials.Material)treatedWood, (IMaterialStats)new HeadMaterialStats(25, 2.0f, 2.0f, 0), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, 35), new ExtraMaterialStats(20)});
        TinkerRegistry.addMaterialStats((slimeknights.tconstruct.library.materials.Material)treatedWood, (IMaterialStats)new BowMaterialStats(1.0f, 1.125f, 0.0f), (IMaterialStats[])new IMaterialStats[]{new ArrowShaftMaterialStats(1.2f, 0)});
        try {
            TinkerRegistry.integrate((slimeknights.tconstruct.library.materials.Material)treatedWood, (String)"plankTreatedWood").preInit();
        }
        catch (Exception e) {
            IELogger.logger.error("[TCon] Material 'treatedWood' has already been registered");
        }
        TinkerRegistry.addMaterialStats((slimeknights.tconstruct.library.materials.Material)hemp, (IMaterialStats)new BowStringMaterialStats(1.0f));
        TinkerRegistry.integrate((slimeknights.tconstruct.library.materials.Material)hemp).preInit();
        TinkerRegistry.addMaterialStats((slimeknights.tconstruct.library.materials.Material)constantan, (IMaterialStats)new HeadMaterialStats(25, 4.7f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.8f, 60), new ExtraMaterialStats(60)});
        TinkerRegistry.addMaterialStats((slimeknights.tconstruct.library.materials.Material)constantan, (IMaterialStats)new BowMaterialStats(0.55f, 1.5f, 5.0f));
        try {
            TinkerRegistry.integrate((slimeknights.tconstruct.library.materials.Material)constantan, (Fluid)fluidConstantan, (String)"Constantan").toolforge().preInit();
        }
        catch (Exception e) {
            IELogger.logger.error("[TCon] Material 'constantan' has already been registered");
        }
        ToolboxHandler.addToolType(s -> s.func_77973_b() instanceof TinkersItem);
    }

    @Override
    public void registerRecipes() {
        if (ApiUtils.isExistingOreName("ingotAlubrass")) {
            IERecipes.addOreDictArcAlloyingRecipe("ingotAlubrass", 4, "Copper", 100, 512, "dustAluminum", "dustAluminum", "dustAluminum");
        }
        IERecipes.addOreDictArcAlloyingRecipe("ingotManyullyn", 1, "Cobalt", 200, 512, "ingotArdite");
        IERecipes.addOreDictArcAlloyingRecipe("ingotManyullyn", 1, "Ardite", 200, 512, "ingotCobalt");
        Fluid fluidClay = FluidRegistry.getFluid((String)"clay");
        if (fluidClay != null) {
            MixerRecipe.addRecipe(new FluidStack(IEContent.fluidConcrete, 500), new FluidStack(fluidClay, 500), new Object[]{"sand", "sand", "gravel"}, 3200);
        }
    }

    @Override
    public void init() {
        treatedWood.setCraftable(true);
        treatedWood.addItem("stickTreatedWood", 1, 72);
        treatedWood.addItem("plankTreatedWood", 1, 144);
        treatedWood.addTrait((ITrait)TinkerTraits.ecological, "head");
        treatedWood.addTrait((ITrait)TinkerTraits.ecological);
        hemp.addItemIngot("fiberHemp");
        hemp.setRepresentativeItem(new ItemStack((Item)IEContent.itemMaterial, 1, 4));
        constantan.setCastable(true);
        constantan.addItem("nuggetConstantan", 1, 16);
        constantan.addItem("ingotConstantan", 1, 144);
        constantan.addTrait((ITrait)thermalInversion);
        ChemthrowerHandler.registerEffect("blueslime", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.sticky, 100, 1));
        ChemthrowerHandler.registerEffect("purpleslime", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.sticky, 100, 2));
    }

    @Override
    public void postInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPostInit() {
        treatedWood.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.BlockTexture(new ResourceLocation("immersiveengineering", "blocks/treatedWood_horizontal")));
        constantan.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.Metal(11427148, 0.1f, 0.2f, 0.0f));
        hemp.setRenderInfo(10914680);
    }

    public static Fluid sendFluidForMelting(String ore, Fluid fluid) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluid", fluid.getName());
        tag.func_74778_a("ore", ore);
        tag.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
        return fluid;
    }

    public static void sendAlloyForMelting(FluidStack output, Object ... input) {
        assert (input.length % 2 == 0);
        Fluid inputStacks = new FluidStack[input.length / 2];
        for (int i = 0; i < ((FluidStack[])inputStacks).length; ++i) {
            Fluid f;
            if (!(input[i * 2] instanceof String) || !(input[i * 2 + 1] instanceof Integer) || (f = FluidRegistry.getFluid((String)((String)input[i * 2]))) == null) continue;
            inputStacks[i] = new FluidStack(f, ((Integer)input[i * 2 + 1]).intValue());
        }
        NBTTagList tagList = new NBTTagList();
        tagList.func_74742_a((NBTBase)output.writeToNBT(new NBTTagCompound()));
        for (Fluid stack : inputStacks) {
            if (stack == null) continue;
            tagList.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        NBTTagCompound message = new NBTTagCompound();
        message.func_74782_a("alloy", (NBTBase)tagList);
        TinkerRegistry.registerAlloy((FluidStack)output, (FluidStack[])inputStacks);
    }

    static {
        TConstructHelper.sendFluidForMelting("Uranium", fluidUranium);
        blockMoltenUranium = new BlockIEFluid("molten_uranium", fluidUranium, Material.field_151587_i);
        fluidConstantan = IEContent.setupFluid(new FluidColouredMetal("constantan", 16221804, 518));
        TConstructHelper.sendFluidForMelting("Constantan", fluidConstantan);
        blockMoltenConstantan = new BlockIEFluid("molten_constantan", fluidConstantan, Material.field_151587_i);
    }

    public static class TraitThermalInversion
    extends AbstractTrait {
        public TraitThermalInversion() {
            super("thermalinversion", 15958634);
        }

        public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
            BlockPos pos;
            Biome biome;
            float tempDif;
            if (target.func_70089_S() && wasHit && (tempDif = (biome = player.field_70170_p.getBiomeForCoordsBody(pos = player.func_180425_c())).func_180626_a(pos) - 0.5f) != 0.0f) {
                if (tempDif < 0.0f && !target.func_70045_F()) {
                    target.func_70015_d((int)Math.floor(tempDif * 3.0f));
                } else if (tempDif > 0.0f) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 4, (int)Math.floor(tempDif * 2.0f)));
                }
            }
        }
    }

    public static class FluidColouredMetal
    extends Fluid {
        public static ResourceLocation ICON_MetalStill = new ResourceLocation("tconstruct:blocks/fluids/molten_metal");
        public static ResourceLocation ICON_MetalFlowing = new ResourceLocation("tconstruct:blocks/fluids/molten_metal_flow");
        int colour;

        public FluidColouredMetal(String name, int colour, int temp) {
            super(name, ICON_MetalStill, ICON_MetalFlowing);
            this.colour = colour;
            this.setTemperature(temp);
            this.setDensity(2000);
            this.setViscosity(10000);
        }

        public int getColor() {
            return this.colour | 0xFF000000;
        }
    }
}

