/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.EnumFacing;
import vswe.superfactory.blocks.ConnectionBlockType;
import vswe.superfactory.components.CommandExecutor;
import vswe.superfactory.components.ComponentMenuContainer;
import vswe.superfactory.components.ComponentMenuRedstoneStrength;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.TriggerHelper;
import vswe.superfactory.components.internal.ConnectionOption;
import vswe.superfactory.components.internal.SlotInventoryHolder;
import vswe.superfactory.tiles.TileEntityInput;

public class TriggerHelperRedstone
extends TriggerHelper {
    private int strengthId;

    public TriggerHelperRedstone(int sidesId, int strengthId) {
        super(true, 0, sidesId, ConnectionBlockType.RECEIVER);
        this.strengthId = strengthId;
    }

    @Override
    public void onTrigger(FlowComponent item, EnumSet<ConnectionOption> valid) {
        if (this.isTriggerPowered(item, true)) {
            valid.add(ConnectionOption.REDSTONE_HIGH);
        }
        if (this.isTriggerPowered(item, false)) {
            valid.add(ConnectionOption.REDSTONE_LOW);
        }
    }

    @Override
    protected boolean isBlockPowered(FlowComponent component, int power) {
        ComponentMenuRedstoneStrength menuStrength = (ComponentMenuRedstoneStrength)component.getMenus().get(this.strengthId);
        boolean inRange = menuStrength.getLow() <= power && power <= menuStrength.getHigh();
        return inRange != menuStrength.isInverted();
    }

    public void onRedstoneTrigger(FlowComponent item, TileEntityInput inputTrigger) {
        List<SlotInventoryHolder> receivers = CommandExecutor.getContainers(item.getManager(), item.getMenus().get(this.containerId), this.blockType);
        if (receivers != null) {
            ComponentMenuContainer componentMenuContainer = (ComponentMenuContainer)item.getMenus().get(this.containerId);
            int[] newPower = new int[EnumFacing.values().length];
            int[] oldPower = new int[EnumFacing.values().length];
            if (this.canUseMergedDetection && componentMenuContainer.getOption() == 0) {
                for (SlotInventoryHolder receiver : receivers) {
                    TileEntityInput input = receiver.getReceiver();
                    for (int i = 0; i < newPower.length; ++i) {
                        newPower[i] = Math.min(15, newPower[i] + input.getData()[i]);
                        oldPower[i] = Math.min(15, oldPower[i] + input.getOldData()[i]);
                    }
                }
                if (this.isPulseReceived(item, newPower, oldPower, true)) {
                    this.activateTrigger(item, EnumSet.of(ConnectionOption.REDSTONE_PULSE_HIGH));
                }
                if (this.isPulseReceived(item, newPower, oldPower, false)) {
                    this.activateTrigger(item, EnumSet.of(ConnectionOption.REDSTONE_PULSE_LOW));
                }
            } else {
                TileEntityInput trigger;
                TileEntityInput tileEntityInput = trigger = componentMenuContainer.getOption() == 0 || componentMenuContainer.getOption() == 1 && this.canUseMergedDetection ? inputTrigger : null;
                if (this.isPulseReceived(item, receivers, trigger, true)) {
                    this.activateTrigger(item, EnumSet.of(ConnectionOption.REDSTONE_PULSE_HIGH));
                }
                if (this.isPulseReceived(item, receivers, trigger, false)) {
                    this.activateTrigger(item, EnumSet.of(ConnectionOption.REDSTONE_PULSE_LOW));
                }
            }
        }
    }
}

