/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components.internal;

import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class StackTankHolder {
    private FluidStack fluidStack;
    private EnumFacing side;
    private int sizeLeft;
    private IFluidHandler tank;

    public StackTankHolder(FluidStack fluidStack, IFluidHandler tank, EnumFacing side) {
        this.fluidStack = fluidStack;
        this.tank = tank;
        this.side = side;
        if (fluidStack != null) {
            this.sizeLeft = fluidStack.amount;
        }
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public IFluidHandler getTank() {
        return this.tank;
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public void reduceAmount(int val) {
        this.sizeLeft -= val;
        this.fluidStack.amount -= val;
    }

    public StackTankHolder getSplitElement(int elementAmount, int id, boolean fair) {
        int amountLeft;
        StackTankHolder element = new StackTankHolder(this.fluidStack, this.tank, this.side);
        int oldAmount = this.getSizeLeft();
        int amount = oldAmount / elementAmount;
        if (!fair && id < (amountLeft = oldAmount % elementAmount)) {
            ++amount;
        }
        element.sizeLeft = amount;
        return element;
    }

    public int getSizeLeft() {
        return Math.min(this.fluidStack.amount, this.sizeLeft);
    }
}

