/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.tiles;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import vswe.superfactory.blocks.ClusterMethodRegistration;
import vswe.superfactory.blocks.ISystemListener;
import vswe.superfactory.blocks.ITriggerNode;
import vswe.superfactory.tiles.TileEntityClusterElement;
import vswe.superfactory.tiles.TileEntityManager;

public class TileEntityBUD
extends TileEntityClusterElement
implements ISystemListener,
ITriggerNode {
    private static final String NBT_DATA = "Data";
    private static final String NBT_SIDES = "Sides";
    private int[] data = new int[EnumFacing.values().length];
    private List<TileEntityManager> managerList = new ArrayList<TileEntityManager>();
    private int[] oldData = new int[EnumFacing.values().length];

    @Override
    public void added(TileEntityManager owner) {
        if (!this.managerList.contains(owner)) {
            this.managerList.add(owner);
        }
    }

    @Override
    public void removed(TileEntityManager owner) {
        this.managerList.remove(owner);
    }

    public void onTrigger() {
        this.updateData();
        for (int i = this.managerList.size() - 1; i >= 0; --i) {
            this.managerList.get(i).triggerBUD(this);
        }
        this.makeOld();
    }

    public void updateData() {
        if (this.field_145850_b != null) {
            this.data = new int[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                EnumFacing direction = EnumFacing.func_82600_a((int)i);
                int x = direction.func_82601_c() + this.func_174877_v().func_177958_n();
                int y = direction.func_96559_d() + this.func_174877_v().func_177956_o();
                int z = direction.func_82599_e() + this.func_174877_v().func_177952_p();
                IBlockState state = this.field_145850_b.func_180495_p(new BlockPos(x, y, z));
                this.data[i] = Block.func_149682_b((Block)state.func_177230_c()) << 4 | state.func_177230_c().func_176201_c(state) & 0xF;
            }
        }
    }

    public void makeOld() {
        this.oldData = this.data;
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    @Override
    public int[] getOldData() {
        return this.oldData;
    }

    @Override
    public void readContentFromNBT(NBTTagCompound nbtTagCompound) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        NBTTagList sidesTag = nbtTagCompound.func_150295_c(NBT_SIDES, 10);
        for (int i = 0; i < sidesTag.func_74745_c(); ++i) {
            NBTTagCompound sideTag = sidesTag.func_150305_b(i);
            short s = sideTag.func_74765_d(NBT_DATA);
            this.data[i] = s;
            this.oldData[i] = s;
        }
    }

    @Override
    public void writeContentToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)13);
        NBTTagList sidesTag = new NBTTagList();
        for (int i = 0; i < this.data.length; ++i) {
            NBTTagCompound sideTag = new NBTTagCompound();
            sideTag.func_74777_a(NBT_DATA, (short)this.data[i]);
            sidesTag.func_74742_a((NBTBase)sideTag);
        }
        nbtTagCompound.func_74782_a(NBT_SIDES, (NBTBase)sidesTag);
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.ON_NEIGHBOR_BLOCK_CHANGED);
    }
}

