/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.logic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import reborncore.RebornCore;
import reborncore.RebornRegistry;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.logic.LogicBlock;
import reborncore.common.logic.LogicGui;
import reborncore.common.network.VanillaPacketDispatcher;

public abstract class LogicController
extends TileEntity {
    String name;
    public ItemStackHandler inv = new ItemStackHandler(this.getInvSize());
    public GuiBuilder builder = new GuiBuilder(GuiBuilder.defaultTextureSheet);
    public static final AxisAlignedBB FULL_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract int getInvSize();

    public boolean hasInv() {
        return this.getInvSize() != 0;
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiBuilder getBuilder() {
        return this.builder;
    }

    public int getXSize() {
        return 176;
    }

    public int getYsize() {
        return 176;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY, int guiLeft, int guiTop, int xSize, int ySize, LogicGui gui) {
        this.getBuilder().drawDefaultBackground((GuiScreen)gui, guiLeft, guiTop, xSize, ySize);
        this.getBuilder().drawPlayerSlots((GuiScreen)gui, guiLeft + xSize / 2, guiTop + 84, true);
        if (this.getSlots() != null) {
            for (Slot s2 : this.getSlots()) {
                this.getBuilder().drawSlot((GuiScreen)gui, guiLeft + s2.field_75223_e - 1, guiTop + s2.field_75221_f - 1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY, GuiContainer gui, int guiLeft, int guiTop) {
    }

    @SideOnly(value=Side.CLIENT)
    public List<GuiButton> getButtons() {
        return null;
    }

    public abstract List<Slot> getSlots();

    public int inventoryOffsetX() {
        return 8;
    }

    public int inventoryOffsetY() {
        return 85;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        try {
            return (TileEntity)((Object)((Object)this)).getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        LogicController.openGui(playerIn, (LogicController)worldIn.func_175625_s(pos));
        return true;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FULL_BLOCK_AABB;
    }

    public void onBlockClicked(World worldIn, BlockPos pos, EntityPlayer playerIn) {
    }

    public void addInformation(ItemStack stack, World world, List<String> tooltip, boolean advanced) {
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public void actionPerformed(int buttonID) {
    }

    public boolean dropInv() {
        return false;
    }

    public float getHardness() {
        return 2.0f;
    }

    public boolean hasRotation() {
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.hasInv()) {
            compound.func_179237_a(this.getInv().serializeNBT());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.hasInv()) {
            this.inv.deserializeNBT(compound);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.hasInv() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasInv() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getInv());
        }
        return (T)super.getCapability(capability, facing);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    public void initBlock(LogicBlock block) {
    }

    public static void openGui(EntityPlayer player, LogicController machine) {
        if (!player.func_70093_af()) {
            player.openGui((Object)RebornCore.INSTANCE, 0, machine.field_145850_b, machine.field_174879_c.func_177958_n(), machine.field_174879_c.func_177956_o(), machine.field_174879_c.func_177952_p());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Block block) {
        RebornRegistry.registerItemModel(block, 0);
    }
}

