/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.recipes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import reborncore.RebornCore;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.recipes.ICrafterSoundHanlder;
import reborncore.common.recipes.IUpgradeHandler;
import reborncore.common.recipes.OreRecipeInput;
import reborncore.common.recipes.RecipeTranslator;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class RecipeCrafter
implements IUpgradeHandler {
    public String recipeName;
    public TileEntity parentTile;
    public IEnergyInterfaceTile energy;
    public Optional<IUpgradeHandler> parentUpgradeHandler = Optional.empty();
    public int inputs;
    public int outputs;
    public IInventory inventory;
    public int[] inputSlots;
    public int[] outputSlots;
    public IBaseRecipeType currentRecipe;
    public int currentTickTime = 0;
    public int currentNeededTicks = 1;
    double lastEnergy;
    int ticksSinceLastChange;
    @Nullable
    public static ICrafterSoundHanlder soundHanlder = null;

    public RecipeCrafter(String recipeName, TileEntity parentTile, int inputs, int outputs, Inventory inventory, int[] inputSlots, int[] outputSlots) {
        this.recipeName = recipeName;
        this.parentTile = parentTile;
        if (parentTile instanceof IEnergyInterfaceTile) {
            this.energy = (IEnergyInterfaceTile)parentTile;
        }
        if (parentTile instanceof IUpgradeHandler) {
            this.parentUpgradeHandler = Optional.of((IUpgradeHandler)parentTile);
        }
        this.inputs = inputs;
        this.outputs = outputs;
        this.inventory = inventory;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        if (!(parentTile instanceof IRecipeCrafterProvider)) {
            RebornCore.logHelper.error(parentTile.getClass().getName() + " does not use IRecipeCrafterProvider report this to the issue tracker!");
        }
    }

    public void updateEntity() {
        if (this.parentTile.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange == 20) {
            this.setInvDirty(true);
            this.ticksSinceLastChange = 0;
        }
        if (this.currentRecipe == null && this.isInvDirty()) {
            this.updateCurrentRecipe();
        }
        if (this.currentRecipe != null) {
            if (this.isInvDirty() && !this.hasAllInputs()) {
                this.currentRecipe = null;
                this.currentTickTime = 0;
                this.setIsActive();
            }
            if (this.currentRecipe != null && this.currentTickTime >= this.currentNeededTicks && this.hasAllInputs()) {
                boolean canGiveInvAll = true;
                for (int i = 0; i < this.currentRecipe.getOutputsSize(); ++i) {
                    if (this.canFitStack(this.currentRecipe.getOutput(i), this.outputSlots[i], this.currentRecipe.useOreDic())) continue;
                    canGiveInvAll = false;
                }
                ArrayList<Integer> filledSlots = new ArrayList<Integer>();
                if (canGiveInvAll && this.currentRecipe.onCraft(this.parentTile)) {
                    for (int i = 0; i < this.currentRecipe.getOutputsSize(); ++i) {
                        if (filledSlots.contains(this.outputSlots[i])) continue;
                        this.fitStack(this.currentRecipe.getOutput(i).func_77946_l(), this.outputSlots[i]);
                        filledSlots.add(this.outputSlots[i]);
                    }
                    this.useAllInputs();
                    this.currentRecipe = null;
                    this.currentTickTime = 0;
                    this.updateCurrentRecipe();
                    if (this.currentRecipe == null) {
                        this.setIsActive();
                    }
                }
            } else if (this.currentRecipe != null && this.currentTickTime < this.currentNeededTicks && this.energy.canUseEnergy(this.getEuPerTick(this.currentRecipe.euPerTick()))) {
                this.energy.useEnergy(this.getEuPerTick(this.currentRecipe.euPerTick()));
                ++this.currentTickTime;
                if (this.currentTickTime == 1 || this.currentTickTime % 20 == 0 && soundHanlder != null) {
                    soundHanlder.playSound(false, this.parentTile);
                }
            }
        }
        this.setInvDirty(false);
    }

    public void updateCurrentRecipe() {
        this.currentTickTime = 0;
        for (IBaseRecipeType recipe : RecipeHandler.getRecipeClassFromName(this.recipeName)) {
            if (!recipe.canCraft(this.parentTile) || !this.hasAllInputs(recipe)) continue;
            for (int i = 0; i < recipe.getOutputsSize(); ++i) {
                if (this.canFitStack(recipe.getOutput(i), this.outputSlots[i], recipe.useOreDic())) continue;
                this.currentRecipe = null;
                this.currentTickTime = 0;
                this.setIsActive();
                return;
            }
            this.setCurrentRecipe(recipe);
            this.currentNeededTicks = Math.max((int)((double)this.currentRecipe.tickTime() * (1.0 - this.getSpeedMultiplier())), 1);
            this.currentTickTime = 0;
            this.setIsActive();
            return;
        }
    }

    public boolean hasAllInputs() {
        if (this.currentRecipe == null) {
            return false;
        }
        for (Object input : this.currentRecipe.getInputs()) {
            boolean hasItem = false;
            boolean useOreDict = input instanceof String || input instanceof OreRecipeInput || this.currentRecipe.useOreDic();
            boolean checkSize = input instanceof ItemStack || input instanceof OreRecipeInput;
            for (int inputslot : this.inputSlots) {
                if (!ItemUtils.isInputEqual(input, this.inventory.func_70301_a(inputslot), true, true, useOreDict)) continue;
                ItemStack stack = RecipeTranslator.getStackFromObject(input);
                if (checkSize && this.inventory.func_70301_a(inputslot).func_190916_E() < stack.func_190916_E()) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllInputs(IBaseRecipeType recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (Object input : recipeType.getInputs()) {
            boolean hasItem = false;
            boolean useOreDict = input instanceof String || input instanceof OreRecipeInput || recipeType.useOreDic();
            boolean checkSize = input instanceof ItemStack || input instanceof OreRecipeInput;
            for (int inputslot : this.inputSlots) {
                if (!ItemUtils.isInputEqual(input, this.inventory.func_70301_a(inputslot), true, true, useOreDict)) continue;
                ItemStack stack = RecipeTranslator.getStackFromObject(input);
                if (checkSize && this.inventory.func_70301_a(inputslot).func_190916_E() < stack.func_190916_E()) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    public void useAllInputs() {
        if (this.currentRecipe == null) {
            return;
        }
        block0: for (Object input : this.currentRecipe.getInputs()) {
            for (int inputSlot : this.inputSlots) {
                if (!ItemUtils.isInputEqual(input, this.inventory.func_70301_a(inputSlot), true, true, this.currentRecipe.useOreDic())) continue;
                int count = 1;
                if (input instanceof ItemStack || input instanceof OreRecipeInput) {
                    count = RecipeTranslator.getStackFromObject(input).func_190916_E();
                }
                if (this.inventory.func_70301_a(inputSlot).func_190916_E() < count) continue;
                this.inventory.func_70298_a(inputSlot, count);
                continue block0;
            }
        }
    }

    public boolean canFitStack(ItemStack stack, int slot, boolean oreDic) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (this.inventory.func_70301_a(slot).func_190926_b()) {
            return true;
        }
        return ItemUtils.isItemEqual(this.inventory.func_70301_a(slot), stack, true, true, oreDic) && stack.func_190916_E() + this.inventory.func_70301_a(slot).func_190916_E() <= stack.func_77976_d();
    }

    public void fitStack(ItemStack stack, int slot) {
        if (stack.func_190926_b()) {
            return;
        }
        if (this.inventory.func_70301_a(slot).func_190926_b()) {
            this.inventory.func_70299_a(slot, stack);
            return;
        }
        if (ItemUtils.isItemEqual(this.inventory.func_70301_a(slot), stack, true, true, this.currentRecipe.useOreDic()) && stack.func_190916_E() + this.inventory.func_70301_a(slot).func_190916_E() <= stack.func_77976_d()) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(this.inventory.func_70301_a(slot).func_190916_E() + stack.func_190916_E());
            this.inventory.func_70299_a(slot, newStack);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("Crater");
        if (data.func_74764_b("currentTickTime")) {
            this.currentTickTime = data.func_74762_e("currentTickTime");
        }
        if (this.parentTile != null && this.parentTile.func_145831_w() != null && this.parentTile.func_145831_w().field_72995_K) {
            this.parentTile.func_145831_w().func_184138_a(this.parentTile.func_174877_v(), this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()), this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()), 3);
            this.parentTile.func_145831_w().func_147458_c(this.parentTile.func_174877_v().func_177958_n(), this.parentTile.func_174877_v().func_177956_o(), this.parentTile.func_174877_v().func_177952_p(), this.parentTile.func_174877_v().func_177958_n(), this.parentTile.func_174877_v().func_177956_o(), this.parentTile.func_174877_v().func_177952_p());
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("currentTickTime", (double)this.currentTickTime);
        tag.func_74782_a("Crater", (NBTBase)data);
    }

    private boolean isActive() {
        return this.currentRecipe != null && this.energy.getEnergy() >= (double)this.currentRecipe.euPerTick();
    }

    public boolean canCraftAgain() {
        for (IBaseRecipeType recipe : RecipeHandler.getRecipeClassFromName(this.recipeName)) {
            if (!recipe.canCraft(this.parentTile) || !this.hasAllInputs(recipe)) continue;
            boolean canGiveInvAll = true;
            for (int i = 0; i < recipe.getOutputsSize(); ++i) {
                if (this.canFitStack(recipe.getOutput(i), this.outputSlots[i], recipe.useOreDic())) continue;
                canGiveInvAll = false;
                return false;
            }
            if (this.energy.getEnergy() < (double)recipe.euPerTick()) {
                return false;
            }
            return canGiveInvAll;
        }
        return false;
    }

    public void setIsActive() {
        if (this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()).func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()).func_177230_c();
            boolean isActive = this.isActive() || this.canCraftAgain();
            blockMachineBase.setActive(isActive, this.parentTile.func_145831_w(), this.parentTile.func_174877_v());
        }
        this.parentTile.func_145831_w().func_184138_a(this.parentTile.func_174877_v(), this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()), this.parentTile.func_145831_w().func_180495_p(this.parentTile.func_174877_v()), 3);
    }

    public void setCurrentRecipe(IBaseRecipeType recipe) {
        try {
            this.currentRecipe = (IBaseRecipeType)recipe.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public boolean isInvDirty() {
        if (this.inventory instanceof Inventory) {
            return ((Inventory)this.inventory).isDirty;
        }
        if (this.inventory instanceof Inventory) {
            return ((Inventory)this.inventory).hasChanged;
        }
        return true;
    }

    public void setInvDirty(boolean isDiry) {
        if (this.inventory instanceof Inventory) {
            ((Inventory)this.inventory).isDirty = isDiry;
        } else if (this.inventory instanceof Inventory) {
            ((Inventory)this.inventory).hasChanged = isDiry;
        }
    }

    public boolean isStackValidInput(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (IBaseRecipeType recipe : RecipeHandler.getRecipeClassFromName(this.recipeName)) {
            Iterator<Object> iterator = recipe.getInputs().iterator();
            while (iterator.hasNext()) {
                Object input;
                boolean useOreDict = (input = iterator.next()) instanceof String || input instanceof OreRecipeInput || recipe.useOreDic();
                if (!ItemUtils.isInputEqual(input, stack, true, true, useOreDict)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void resetSpeedMulti() {
        this.parentUpgradeHandler.ifPresent(IUpgradeHandler::resetSpeedMulti);
    }

    @Override
    public double getSpeedMultiplier() {
        return Math.min(this.parentUpgradeHandler.map(IUpgradeHandler::getSpeedMultiplier).orElse(0.0), 0.975);
    }

    @Override
    public void addPowerMulti(double amount) {
        this.parentUpgradeHandler.ifPresent(iUpgradeHandler -> iUpgradeHandler.addPowerMulti(amount));
    }

    @Override
    public void resetPowerMulti() {
        this.parentUpgradeHandler.ifPresent(IUpgradeHandler::resetPowerMulti);
    }

    @Override
    public double getPowerMultiplier() {
        return this.parentUpgradeHandler.map(IUpgradeHandler::getPowerMultiplier).orElse(1.0);
    }

    @Override
    public double getEuPerTick(double baseEu) {
        double power = this.parentUpgradeHandler.map(iUpgradeHandler -> iUpgradeHandler.getEuPerTick(baseEu)).orElse(1.0);
        return Math.min(power, this.energy.getMaxPower());
    }

    @Override
    public void addSpeedMulti(double amount) {
        this.parentUpgradeHandler.ifPresent(iUpgradeHandler -> iUpgradeHandler.addSpeedMulti(amount));
    }
}

