/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.awt.Rectangle;
import java.util.ArrayList;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.config.Config;
import mezz.jei.config.Constants;
import mezz.jei.config.JEIModConfigGui;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Keyboard;

public class ConfigButton {
    private final IngredientListOverlay parent;
    private final GuiButton configButton;
    private final IDrawable configButtonIcon;
    private final IDrawable configButtonCheatIcon;
    private final HoverChecker configButtonHoverChecker;

    public ConfigButton(IngredientListOverlay parent) {
        this.parent = parent;
        this.configButton = new GuiButton(2, 0, 0, 0, 0, "");
        ResourceLocation configButtonIconLocation = Constants.RECIPE_BACKGROUND;
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        this.configButtonIcon = guiHelper.createDrawable(configButtonIconLocation, 0, 166, 16, 16);
        this.configButtonCheatIcon = guiHelper.createDrawable(configButtonIconLocation, 16, 166, 16, 16);
        this.configButtonHoverChecker = new HoverChecker(this.configButton, 0);
    }

    public void updateBounds(Rectangle area) {
        this.configButton.field_146120_f = area.width;
        this.configButton.field_146121_g = area.height;
        this.configButton.field_146128_h = area.x;
        this.configButton.field_146129_i = area.y;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.configButton.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
        IDrawable icon = Config.isCheatItemsEnabled() ? this.configButtonCheatIcon : this.configButtonIcon;
        icon.draw(minecraft, this.configButton.field_146128_h + 2, this.configButton.field_146129_i + 2);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.configButtonHoverChecker.checkHover(mouseX, mouseY);
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY, boolean hasRoom) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(Translator.translateToLocal("jei.tooltip.config"));
            if (!Config.isOverlayEnabled()) {
                tooltip.add(TextFormatting.GOLD + Translator.translateToLocal("jei.tooltip.ingredient.list.disabled"));
                tooltip.add(TextFormatting.GOLD + Translator.translateToLocalFormatted("jei.tooltip.ingredient.list.disabled.how.to.fix", KeyBindings.toggleOverlay.getDisplayName()));
            } else if (!hasRoom) {
                tooltip.add(TextFormatting.GOLD + Translator.translateToLocal("jei.tooltip.not.enough.space"));
            }
            if (Config.isCheatItemsEnabled()) {
                tooltip.add(TextFormatting.RED + Translator.translateToLocal("jei.tooltip.cheat.mode.button.enabled"));
                KeyBinding toggleCheatMode = KeyBindings.toggleCheatMode;
                if (toggleCheatMode.func_151463_i() != 0) {
                    tooltip.add(TextFormatting.RED + Translator.translateToLocalFormatted("jei.tooltip.cheat.mode.how.to.disable.hotkey", toggleCheatMode.getDisplayName()));
                } else {
                    String controlKeyLocalization = Translator.translateToLocal(Minecraft.field_142025_a ? "key.jei.ctrl.mac" : "key.jei.ctrl");
                    tooltip.add(TextFormatting.RED + Translator.translateToLocalFormatted("jei.tooltip.cheat.mode.how.to.disable.no.hotkey", controlKeyLocalization));
                }
            }
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, 150);
        }
    }

    public boolean handleMouseClick(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (Config.isOverlayEnabled() && this.configButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.configButton.func_146113_a(minecraft.func_147118_V());
            if (Keyboard.getEventKeyState() && (Keyboard.getEventKey() == 29 || Keyboard.getEventKey() == 157)) {
                Config.toggleCheatItemsEnabled();
            } else if (minecraft.field_71462_r != null) {
                JEIModConfigGui configScreen = new JEIModConfigGui(minecraft.field_71462_r);
                this.parent.updateScreen((GuiScreen)configScreen);
                minecraft.func_147108_a((GuiScreen)configScreen);
            }
            return true;
        }
        return false;
    }
}

