/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.EnumStaff;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemHelper;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeListener {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Pixelmon.instance.getCosmeticHandler().playerLogin(event.player);
        if (Pixelmon.staff.containsKey(event.player.func_110124_au())) {
            EnumStaff staff = Pixelmon.staff.get(event.player.func_110124_au());
            if (staff == null || event.player.func_184102_h() == null) {
                return;
            }
            for (EntityPlayer p : event.player.func_184102_h().func_184103_al().func_181057_v()) {
                if (staff != EnumStaff.Staff && staff != EnumStaff.SchoolGirl && staff != EnumStaff.Manager && staff != EnumStaff.LeadDeveloper && staff != EnumStaff.Owner && staff != EnumStaff.CoOwner) continue;
                p.func_145747_a((ITextComponent)new TextComponentString("[" + TextFormatting.DARK_PURPLE + "Pixelmon" + TextFormatting.WHITE + "] " + TextFormatting.GREEN + Pixelmon.staff.get((Object)event.player.func_110124_au()).name + ", " + event.player.getDisplayNameString() + " has joined the game!"));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedOutEvent event) {
        Pixelmon.instance.getCosmeticHandler().playerLogout(event.player);
    }

    @SubscribeEvent
    public void onPokemonSpawn(EntityJoinWorldEvent event) {
        EntityPixelmon pokemon;
        if (event.getEntity() instanceof EntityPixelmon && !Entity3HasStats.isAvailableGeneration((pokemon = (EntityPixelmon)event.getEntity()).getPokemonName())) {
            pokemon.func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        BattleControllerBase bc = BattleRegistry.getBattle(event.player);
        if (bc != null) {
            bc.endBattle(EnumBattleEndCause.FORCE);
            BattleRegistry.deRegisterBattle(bc);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        for (EntityPlayer player : event.getWorld().field_73010_i) {
            BattleControllerBase bc = BattleRegistry.getBattle(player);
            if (bc == null) continue;
            bc.endBattle(EnumBattleEndCause.FORCE);
            BattleRegistry.deRegisterBattle(bc);
        }
    }

    @SubscribeEvent
    public void applyAfterBattleEffect(BattleEndEvent event) {
        for (BattleParticipant participant : event.bc.participants) {
            for (PixelmonWrapper pixelmonWrapper : participant.controlledPokemon) {
                if (pixelmonWrapper.getHeldItem() == null) continue;
                pixelmonWrapper.getHeldItem().applyAfterBattleEffect(pixelmonWrapper);
            }
        }
    }

    @SubscribeEvent
    public void dropFadedOrb(BeatWildPixelmonEvent event) {
        EntityPixelmon pokemon = (EntityPixelmon)event.wpp.getEntity();
        if (pokemon.getSpecies() == EnumPokemon.Groudon) {
            if (RandomHelper.getRandomChance()) {
                DropItemHelper.giveItemStackToPlayer(event.player, new ItemStack(PixelmonItems.fadedRedOrb), true);
            }
        } else if (pokemon.getSpecies() == EnumPokemon.Kyogre && RandomHelper.getRandomChance()) {
            DropItemHelper.giveItemStackToPlayer(event.player, new ItemStack(PixelmonItems.fadedBlueOrb), true);
        }
    }

    @SubscribeEvent
    public void onNoFormSpawned(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityPixelmon)) {
            return;
        }
        EntityPixelmon pixelmon = (EntityPixelmon)event.getEntity();
        if (pixelmon.func_70902_q() == null || !pixelmon.hasForms() || pixelmon.getForm() != -1 || PixelmonModelRegistry.getModel(pixelmon.getSpecies(), pixelmon.getFormEnum()) != null) {
            return;
        }
        PlayerStorage storage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)pixelmon.func_70902_q()).get();
        pixelmon.setForm(Entity3HasStats.getRandomForm(pixelmon.getSpecies()));
        pixelmon.update(EnumUpdateType.Stats);
        storage.update(pixelmon, EnumUpdateType.Stats);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onSoundPlay(PlaySoundEvent event) {
        if (event.getSound().func_184365_d() != SoundCategory.MUSIC) {
            return;
        }
    }
}

