/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.TimeHandler;
import com.pixelmonmod.pixelmon.client.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.comm.packetHandlers.GuiOpenClose;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RequestUpdatedPokemonList;
import com.pixelmonmod.pixelmon.comm.packetHandlers.StarterListPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.listener.RepelHandler;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class TickHandler {
    private int ticksSinceSentLogin = 0;
    boolean checkedForUsername = false;
    boolean screenOpen = false;
    boolean initialised = false;
    public int worldCounter;
    private int ticksSinceEggStepCheck = 0;
    static final ArrayList<EntityPlayerMP> playerListForStartMenu = new ArrayList();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.side == Side.CLIENT) {
            if (ServerStorageDisplay.starterListPacket != null && Minecraft.func_71410_x().field_71462_r == null) {
                try {
                    Minecraft.func_71410_x().field_71439_g.openGui((Object)Pixelmon.instance, EnumGui.ChooseStarter.getIndex().intValue(), Minecraft.func_71410_x().field_71439_g.field_70170_p, 0, 0, 0);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (!(Minecraft.func_71410_x().field_71462_r == null || this.screenOpen && this.initialised || Minecraft.func_71410_x().field_71462_r instanceof GuiChat)) {
                Pixelmon.network.sendToServer((IMessage)new GuiOpenClose(true));
                this.screenOpen = true;
                this.initialised = true;
            } else if (this.screenOpen && Minecraft.func_71410_x().field_71462_r == null || !this.initialised) {
                Pixelmon.network.sendToServer((IMessage)new GuiOpenClose(false));
                this.screenOpen = false;
                this.initialised = true;
                if (Minecraft.func_71410_x().field_71474_y.field_74319_N || !GuiIngameForge.renderHotbar) {
                    Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
                    GuiIngameForge.renderHotbar = true;
                    GuiIngameForge.renderCrosshairs = true;
                    GuiIngameForge.renderExperiance = true;
                    GuiIngameForge.renderAir = true;
                    GuiIngameForge.renderHealth = true;
                    GuiIngameForge.renderFood = true;
                    GuiIngameForge.renderArmor = true;
                }
            }
        }
        if (event.side == Side.SERVER) {
            ++this.ticksSinceEggStepCheck;
            if (this.ticksSinceEggStepCheck < 20) {
                return;
            }
            this.ticksSinceEggStepCheck = 0;
            Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)player);
            if (optstorage.isPresent()) {
                PlayerStorage storage = optstorage.get();
                storage.checkEggStep();
            }
        }
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        this.checkedForUsername = true;
        if (ServerStorageDisplay.count() == 0) {
            ++this.ticksSinceSentLogin;
            if (this.ticksSinceSentLogin >= 100) {
                this.ticksSinceSentLogin = 0;
                Pixelmon.network.sendToServer((IMessage)new RequestUpdatedPokemonList());
                PlayerExtraDataStore.sendDisplayPacket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (this.worldCounter % (PixelmonConfig.timeUpdateInterval * 20) == 0) {
            TimeHandler.changeTime();
        }
        if (event.phase == TickEvent.Phase.START) {
            RepelHandler.onTick();
        }
        ArrayList<EntityPlayerMP> arrayList = playerListForStartMenu;
        synchronized (arrayList) {
            if (!playerListForStartMenu.isEmpty() && this.worldCounter % 100 == 0) {
                for (EntityPlayerMP player : playerListForStartMenu) {
                    Pixelmon.network.sendTo((IMessage)new StarterListPacket(), player);
                }
            }
        }
        ++this.worldCounter;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            EvolutionQueryList.tick(event.world);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStarterList(EntityPlayerMP player) {
        Pixelmon.network.sendTo((IMessage)new StarterListPacket(), player);
        EntityPlayerMP listEntry = null;
        ArrayList<EntityPlayerMP> arrayList = playerListForStartMenu;
        synchronized (arrayList) {
            for (EntityPlayerMP listPlayer : playerListForStartMenu) {
                if (!listPlayer.func_110124_au().equals(player.func_110124_au())) continue;
                listEntry = listPlayer;
                break;
            }
            if (listEntry == null) {
                playerListForStartMenu.add(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterStarterList(EntityPlayerMP player) {
        EntityPlayerMP listEntry = null;
        ArrayList<EntityPlayerMP> arrayList = playerListForStartMenu;
        synchronized (arrayList) {
            for (EntityPlayerMP listPlayer : playerListForStartMenu) {
                if (!listPlayer.func_110124_au().equals(player.func_110124_au())) continue;
                listEntry = listPlayer;
                break;
            }
            playerListForStartMenu.remove(listEntry);
        }
    }
}

