/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.blocks.ranch.RanchBounds;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityRanchBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.UUID;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BreedEvent
extends Event {
    public final UUID owner;
    public final TileEntityRanchBase ranch;

    private BreedEvent(UUID owner, TileEntityRanchBase ranch) {
        this.owner = owner;
        this.ranch = ranch;
    }

    public EntityPixelmon getPartner(EntityPixelmon pokemon) {
        return this.ranch.getFirstBreedingPartner(pokemon);
    }

    public static class CollectEgg
    extends BreedEvent {
        private EntityPixelmon egg;

        public CollectEgg(UUID owner, TileEntityRanchBase ranch, EntityPixelmon egg) {
            super(owner, ranch);
            this.egg = egg;
        }

        public void setEgg(EntityPixelmon egg) {
            if (egg != null) {
                this.egg = egg;
            }
        }

        public EntityPixelmon getEgg() {
            return this.egg;
        }
    }

    @Cancelable
    public static class MakeEgg
    extends BreedEvent {
        private EntityPixelmon egg;
        public final EntityPixelmon parent1;
        public final EntityPixelmon parent2;

        public MakeEgg(UUID owner, TileEntityRanchBase ranch, EntityPixelmon egg, EntityPixelmon parent1, EntityPixelmon parent2) {
            super(owner, ranch);
            this.egg = egg;
            this.parent1 = parent1;
            this.parent2 = parent2;
        }

        public EntityPixelmon getEgg() {
            return this.egg;
        }

        public void setEgg(EntityPixelmon egg) {
            if (egg != null) {
                this.egg = egg;
            }
        }
    }

    public static class BreedingLevelChanged
    extends BreedEvent {
        public final EntityPixelmon pokemon;
        public final int oldLevel;
        private int newLevel;

        public BreedingLevelChanged(UUID owner, TileEntityRanchBase ranch, EntityPixelmon pokemon, int oldLevel, int newLevel) {
            super(owner, ranch);
            this.pokemon = pokemon;
            this.oldLevel = oldLevel;
            this.newLevel = newLevel;
        }

        public short getNewLevel() {
            return (short)this.newLevel;
        }

        public void setNewLevel(int newLevel) {
            if (newLevel < 0) {
                newLevel = 0;
            } else if (newLevel > 5) {
                newLevel = 5;
            }
            this.newLevel = newLevel;
        }
    }

    public static class EnvironmentStrength
    extends BreedEvent {
        public final EntityPixelmon pokemon;
        public final RanchBounds ranchBounds;
        public float breedingStrength;

        public EnvironmentStrength(UUID owner, TileEntityRanchBase ranch, EntityPixelmon pokemon, RanchBounds ranchBounds, float breedingStrength) {
            super(owner, ranch);
            this.pokemon = pokemon;
            this.ranchBounds = ranchBounds;
            this.breedingStrength = breedingStrength;
        }
    }

    public static class BreedingTicks
    extends BreedEvent {
        public final EntityPixelmon pokemon;
        private int breedingTicks;

        public BreedingTicks(UUID owner, TileEntityRanchBase ranch, EntityPixelmon pokemon, int breedingTicks) {
            super(owner, ranch);
            this.pokemon = pokemon;
            this.breedingTicks = breedingTicks;
        }

        public void setBreedingTicks(int newBreedingTicks) {
            this.breedingTicks = newBreedingTicks < 20 ? 20 : newBreedingTicks;
        }

        public int getBreedingTicks() {
            return this.breedingTicks;
        }
    }
}

