/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class SpawnActionPokemon
extends SpawnAction<EntityPixelmon> {
    public PokemonSpec spec;

    public SpawnActionPokemon(SpawnInfoPokemon spawnInfo, SpawnLocation spawnLocation, PokemonSpec spec) {
        super(spawnInfo, spawnLocation);
        this.spec = spec;
    }

    @Override
    protected EntityPixelmon createEntity() {
        return this.spec.create(this.spawnLocation.location.world);
    }

    @Override
    public EntityPixelmon doSpawn(AbstractSpawner spawner) {
        EntityPixelmon pokemon = (EntityPixelmon)((Object)this.getOrCreateEntity());
        for (LocationType type : this.spawnLocation.types) {
            if (!this.spawnInfo.locationTypes.contains(type)) continue;
            type.mutator.accept(this.spawnLocation);
        }
        if (this.spawnInfo.locationTypes.contains(LocationType.AIR)) {
            pokemon.setSpawnLocation(com.pixelmonmod.pixelmon.database.SpawnLocation.AirPersistent);
        } else if (this.spawnLocation.types.contains(LocationType.WATER) || this.spawnLocation.types.contains(LocationType.UNDERGROUND_WATER) || this.spawnLocation.types.contains(LocationType.SURFACE_WATER) || this.spawnLocation.types.contains(LocationType.SEAFLOOR)) {
            pokemon.setSpawnLocation(com.pixelmonmod.pixelmon.database.SpawnLocation.Water);
        } else {
            pokemon.setSpawnLocation(com.pixelmonmod.pixelmon.database.SpawnLocation.Land);
        }
        pokemon.resetAI();
        super.doSpawn(spawner);
        if (this.entity != null && spawner.spawned.contains(((EntityPixelmon)this.entity).func_110124_au()) && PixelmonConfig.doLegendaryEvent && EnumPokemon.legendaries.contains(this.spec.name)) {
            this.spawnLocation.location.world.func_73046_m().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("chat.type.announcement", new Object[]{TextFormatting.LIGHT_PURPLE + "Pixelmon" + TextFormatting.RESET, TextFormatting.GREEN + I18n.func_74837_a((String)"spawn.legendarymessage", (Object[])new Object[]{this.spec.name, this.spawnLocation.biome.field_76791_y})}));
            BlockPos.MutableBlockPos pos = this.spawnLocation.location.pos;
            this.spawnLocation.location.world.func_73046_m().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + "Spawned " + this.spec.name + " at: " + this.spawnLocation.location.world.func_72912_H().func_76065_j() + " x:" + pos.func_177958_n() + ", y:" + pos.func_177956_o() + ", z:" + pos.func_177952_p()));
            ((EntityPixelmon)this.entity).legendaryTicks = 6000;
        }
        return (EntityPixelmon)this.entity;
    }
}

