/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.conditions;

import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.WorldTime;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class SpawnCondition {
    public static Class<? extends SpawnCondition> targetedSpawnCondition = SpawnCondition.class;
    public transient ArrayList<Biome> biomes = new ArrayList();
    public ArrayList<WorldTime> times = null;
    public ArrayList<WeatherType> weathers = null;
    public ArrayList<String> baseBlocks = null;
    public ArrayList<String> neededNearbyBlocks = null;
    private ArrayList<String> stringBiomes = null;
    public String tag = null;
    public Boolean seesSky = null;
    public Biome.TempCategory temperature = null;
    public ArrayList<Integer> dimensions = null;
    public ArrayList<String> worlds = null;
    public Integer minX = null;
    public Integer maxX = null;
    public Integer minY = null;
    public Integer maxY = null;
    public Integer minZ = null;
    public Integer maxZ = null;
    public Integer moonPhase = null;
    public Integer minLightLevel = null;
    public Integer maxLightLevel = null;

    public void onExport() {
        this.stringBiomes = new ArrayList();
        for (Biome biome : this.biomes) {
            if (biome == null || biome.getRegistryName() == null || biome.getRegistryName().func_110623_a() == null) {
                System.out.println(biome);
                System.out.println(biome.getRegistryName());
                System.out.println(biome.getRegistryName().func_110623_a());
            }
            this.stringBiomes.add(biome.getRegistryName().func_110623_a());
        }
    }

    public void onImport() {
        if (this.stringBiomes == null) {
            this.stringBiomes = new ArrayList();
        }
        for (String stringBiome : this.stringBiomes) {
            if (stringBiome == null) continue;
            if (BetterSpawnerConfig.INSTANCE.biomeCategories.containsKey(stringBiome)) {
                for (String categoryBiome : BetterSpawnerConfig.INSTANCE.biomeCategories.get(stringBiome)) {
                    Set list = GameRegistry.findRegistry(Biome.class).getEntries();
                    for (Map.Entry biomeEntry : list) {
                        if (categoryBiome.contains(":")) {
                            if (!((ResourceLocation)biomeEntry.getKey()).toString().equalsIgnoreCase(categoryBiome) || this.biomes.contains(biomeEntry.getValue())) continue;
                            this.biomes.add((Biome)biomeEntry.getValue());
                            continue;
                        }
                        if (!((ResourceLocation)biomeEntry.getKey()).func_110623_a().equalsIgnoreCase(categoryBiome) || this.biomes.contains(biomeEntry.getValue())) continue;
                        this.biomes.add((Biome)biomeEntry.getValue());
                    }
                }
                continue;
            }
            Set list = GameRegistry.findRegistry(Biome.class).getEntries();
            for (Map.Entry biomeEntry : list) {
                if (stringBiome.contains(":")) {
                    if (!((ResourceLocation)biomeEntry.getKey()).toString().equalsIgnoreCase(stringBiome) || this.biomes.contains(biomeEntry.getValue())) continue;
                    this.biomes.add((Biome)biomeEntry.getValue());
                    continue;
                }
                if (!((ResourceLocation)biomeEntry.getKey()).func_110623_a().equalsIgnoreCase(stringBiome) || this.biomes.contains(biomeEntry.getValue())) continue;
                this.biomes.add((Biome)biomeEntry.getValue());
            }
        }
    }

    public boolean fits(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        int ticks = (int)(spawnLocation.location.world.func_72820_D() % 24000L);
        boolean timeFits = false;
        ArrayList<WorldTime> times = WorldTime.getCurrent(ticks);
        if (this.times != null && !this.times.isEmpty()) {
            for (WorldTime time : times) {
                if (!this.times.contains((Object)time)) continue;
                timeFits = true;
            }
        } else {
            timeFits = true;
        }
        if (!timeFits) {
            return false;
        }
        if (!(this.tag == null || spawnInfo.tag != null && this.tag.equalsIgnoreCase(spawnInfo.tag))) {
            return false;
        }
        if (this.seesSky != null && this.seesSky != spawnLocation.seesSky) {
            return false;
        }
        if (this.temperature != null && this.temperature != spawnLocation.biome.func_150561_m()) {
            return false;
        }
        if (this.dimensions != null && !this.dimensions.isEmpty() && !this.dimensions.contains(spawnLocation.location.world.field_73011_w.getDimension())) {
            return false;
        }
        if (this.worlds != null && !this.worlds.isEmpty() && !this.worlds.contains(spawnLocation.location.world.func_72912_H().func_76065_j())) {
            return false;
        }
        if (this.minX != null && spawnLocation.location.pos.func_177958_n() < this.minX) {
            return false;
        }
        if (this.maxX != null && spawnLocation.location.pos.func_177958_n() > this.maxX) {
            return false;
        }
        if (this.minY != null && spawnLocation.location.pos.func_177956_o() < this.minY) {
            return false;
        }
        if (this.maxY != null && spawnLocation.location.pos.func_177956_o() > this.maxY) {
            return false;
        }
        if (this.minZ != null && spawnLocation.location.pos.func_177952_p() < this.minZ) {
            return false;
        }
        if (this.maxZ != null && spawnLocation.location.pos.func_177952_p() > this.maxZ) {
            return false;
        }
        if (this.weathers != null && !this.weathers.isEmpty() && !this.weathers.contains((Object)WeatherType.get(spawnLocation.location.world))) {
            return false;
        }
        if (spawnLocation.location.world.func_175624_G() != WorldType.field_77138_c && this.biomes != null && !this.biomes.isEmpty() && !this.biomes.contains(spawnLocation.biome)) {
            return false;
        }
        if (this.moonPhase != null && spawnLocation.location.world.field_73011_w.func_76559_b(spawnLocation.location.world.func_72820_D()) != this.moonPhase.intValue()) {
            return false;
        }
        if (this.minLightLevel != null && spawnLocation.location.world.func_175699_k((BlockPos)spawnLocation.location.pos) < this.minLightLevel) {
            return false;
        }
        if (this.maxLightLevel != null && spawnLocation.location.world.func_175699_k((BlockPos)spawnLocation.location.pos) > this.maxLightLevel) {
            return false;
        }
        if (this.baseBlocks != null && !this.baseBlocks.isEmpty()) {
            boolean confirmedBaseBlock = false;
            String blockID = spawnLocation.baseBlock.getRegistryName().toString();
            Iterator<String> var8 = this.baseBlocks.iterator();
            while (true) {
                if (!var8.hasNext()) {
                    if (confirmedBaseBlock) break;
                    return false;
                }
                String neededBaseBlock = var8.next();
                if (!neededBaseBlock.equalsIgnoreCase(blockID) && !BetterSpawnerConfig.getBlockCategory(neededBaseBlock).contains(blockID)) continue;
                confirmedBaseBlock = true;
            }
        }
        if (this.neededNearbyBlocks != null && !this.neededNearbyBlocks.isEmpty()) {
            for (String blockID : this.neededNearbyBlocks) {
                ArrayList<String> needed = new ArrayList<String>();
                needed.addAll(BetterSpawnerConfig.getBlockCategory(blockID));
                if (needed.isEmpty()) {
                    needed.add(blockID);
                }
                for (String neededBlock : needed) {
                    boolean has = false;
                    for (Block uniqueBlock : spawnLocation.uniqueSurroundingBlocks) {
                        if (!neededBlock.equalsIgnoreCase(uniqueBlock.getRegistryName().toString())) continue;
                        has = true;
                    }
                    if (has) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

