/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.BattleQueryPlayer;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelectionList;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.EnumRulesGuiState;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleQueryPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnumBattleQueryResponse;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.CheckRulesVersionChoose;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.DisplayBattleQueryRules;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.SetProposedRules;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UpdateBattleQueryRules;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BattleQuery {
    private static ArrayList<BattleQuery> queryList = new ArrayList();
    static int index = 0;
    private BattleQueryPlayer[] players;
    public int queryIndex;
    public BattleRules battleRules = new BattleRules();

    public BattleQuery(EntityPlayerMP player1, EntityPixelmon pokemon1, EntityPlayerMP player2, EntityPixelmon pokemon2) {
        this.players = new BattleQueryPlayer[]{new BattleQueryPlayer(player1, pokemon1), new BattleQueryPlayer(player2, pokemon2)};
        this.queryIndex = index++;
        this.sendQuery();
    }

    private void sendQuery() {
        int i;
        Optional[] optStorages = new Optional[this.players.length];
        for (i = 0; i < this.players.length; ++i) {
            optStorages[i] = PixelmonStorage.pokeBallManager.getPlayerStorage(this.players[i].player);
            if (optStorages[i].isPresent()) continue;
            return;
        }
        for (i = 0; i < this.players.length; ++i) {
            int other = i == 0 ? 1 : 0;
            BattleQueryPacket packet = new BattleQueryPacket(this.queryIndex, this.players[other].player.func_110124_au(), (PlayerStorage)optStorages[other].get());
            Pixelmon.network.sendTo((IMessage)packet, this.players[i].player);
        }
        queryList.add(this);
    }

    public void acceptQuery(EntityPlayerMP player, EnumBattleQueryResponse response) {
        BattleQueryPlayer currentPlayer = null;
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (player != queryPlayer.player) continue;
            queryPlayer.response = response;
            currentPlayer = queryPlayer;
            break;
        }
        if (currentPlayer == null) {
            return;
        }
        boolean allConfirm = true;
        boolean allAccept = true;
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (!queryPlayer.response.isAcceptResponse()) {
                allConfirm = false;
            }
            if (queryPlayer.response == EnumBattleQueryResponse.Accept) continue;
            allAccept = false;
        }
        if (allConfirm) {
            if (allAccept) {
                this.startBattle();
            } else {
                BattleQueryPlayer proposePlayer = this.players[currentPlayer == this.players[0] ? 1 : 0];
                if (proposePlayer.response != EnumBattleQueryResponse.Rules) {
                    proposePlayer = currentPlayer;
                }
                BattleQueryPlayer otherPlayer = proposePlayer;
                for (BattleQueryPlayer queryPlayer : this.players) {
                    EnumBattleQueryResponse enumBattleQueryResponse = queryPlayer.response = queryPlayer == proposePlayer ? EnumBattleQueryResponse.Accept : EnumBattleQueryResponse.Rules;
                    if (queryPlayer == proposePlayer) continue;
                    otherPlayer = queryPlayer;
                }
                int clauseVersion = BattleClauseRegistry.getClauseVersion();
                Pixelmon.network.sendTo((IMessage)new CheckRulesVersionChoose(clauseVersion, new DisplayBattleQueryRules(this.queryIndex, true)), proposePlayer.player);
                Pixelmon.network.sendTo((IMessage)new CheckRulesVersionChoose(clauseVersion, new DisplayBattleQueryRules(this.queryIndex, false)), otherPlayer.player);
            }
        }
    }

    private void startBattle() {
        int i;
        PlayerStorage[] storages = new PlayerStorage[this.players.length];
        for (i = 0; i < this.players.length; ++i) {
            Optional<PlayerStorage> optStorage = PixelmonStorage.pokeBallManager.getPlayerStorage(this.players[i].player);
            if (!optStorage.isPresent()) {
                return;
            }
            storages[i] = optStorage.get();
        }
        if (this.battleRules.isDefault()) {
            for (i = 0; i < storages.length; ++i) {
                BattleQueryPlayer queryPlayer = this.players[i];
                if (queryPlayer.pokemon != null) continue;
                queryPlayer.pokemon = storages[i].getFirstAblePokemon(queryPlayer.player.field_70170_p);
            }
            if (this.battleRules.battleType == EnumBattleType.Single) {
                this.players[0].pokemon.StartBattle((BattleParticipant)this.players[0].getParticipant(), (BattleParticipant)this.players[1].getParticipant(), this.battleRules);
            } else {
                EntityPixelmon[] secondPokemon = new EntityPixelmon[this.players.length];
                boolean valid = true;
                for (int j = 0; j < secondPokemon.length; ++j) {
                    PlayerStorage storage = storages[j];
                    BattleQueryPlayer player = this.players[j];
                    for (int i2 = 0; i2 < 6; ++i2) {
                        int[] pixId = null;
                        pixId = storage.getIDFromPosition(i2);
                        if (PixelmonMethods.isIDSame(player.pokemon.getPokemonId(), pixId) || storage.isFainted(pixId) || storage.isEgg(pixId)) continue;
                        secondPokemon[j] = storage.sendOut(pixId, player.player.field_70170_p);
                        break;
                    }
                    if (secondPokemon[j] != null) continue;
                    ChatHandler.sendChat((ICommandSender)this.players[0].player, (ICommandSender)this.players[1].player, "gui.acceptdeny.invaliddouble", player.player.func_145748_c_());
                    valid = false;
                    break;
                }
                if (valid) {
                    this.players[0].pokemon.StartBattle((BattleParticipant)this.players[0].getParticipant(secondPokemon[0]), (BattleParticipant)this.players[0].getParticipant(secondPokemon[1]), this.battleRules);
                }
            }
        } else {
            TeamSelectionList.addTeamSelection(this.battleRules, false, storages);
        }
        queryList.remove(this);
    }

    public void declineQuery(EntityPlayerMP player) {
        boolean valid = false;
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (player != queryPlayer.player) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return;
        }
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (player == queryPlayer.player) continue;
            queryPlayer.player.func_71053_j();
        }
        ChatHandler.sendChat((ICommandSender)this.players[0].player, (ICommandSender)this.players[1].player, "battlequery.declined", player.getDisplayNameString());
        queryList.remove(this);
    }

    public void proposeRules(EntityPlayerMP player, BattleRules rules) {
        boolean valid = false;
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (player != queryPlayer.player) continue;
            queryPlayer.response = EnumBattleQueryResponse.Accept;
            valid = true;
            break;
        }
        if (!valid) {
            return;
        }
        rules.validateRules();
        this.battleRules = rules;
        EntityPlayerMP otherPlayer = this.getOtherPlayer(player);
        Pixelmon.network.sendTo((IMessage)new SetProposedRules(this.battleRules), otherPlayer);
        Pixelmon.network.sendTo((IMessage)new UpdateBattleQueryRules(EnumRulesGuiState.WaitAccept), player);
        Pixelmon.network.sendTo((IMessage)new UpdateBattleQueryRules(EnumRulesGuiState.Accept), otherPlayer);
    }

    public void changeRules(EntityPlayerMP player) {
        Pixelmon.network.sendTo((IMessage)new UpdateBattleQueryRules(EnumRulesGuiState.Propose), player);
        Pixelmon.network.sendTo((IMessage)new UpdateBattleQueryRules(EnumRulesGuiState.WaitChange), this.getOtherPlayer(player));
    }

    private EntityPlayerMP getOtherPlayer(EntityPlayerMP player) {
        return player == this.players[0].player ? this.players[1].player : this.players[0].player;
    }

    public static BattleQuery getQuery(int index) {
        for (BattleQuery aQueryList : queryList) {
            if (aQueryList.queryIndex != index) continue;
            return aQueryList;
        }
        return null;
    }

    public static BattleQuery getQuery(EntityPlayerMP player) {
        for (BattleQuery aQueryList : queryList) {
            for (BattleQueryPlayer queryPlayer : aQueryList.players) {
                if (queryPlayer.player != player) continue;
                return aQueryList;
            }
        }
        return null;
    }
}

