/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.Value;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.attackModifiers.AttackModifierBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SkillLink;

public class MultipleHit
extends AttackModifierBase {
    private int count = 0;
    private int targetCount = 0;
    private boolean inProgress = false;
    private int limit = 0;

    public MultipleHit(Value ... values) {
        this.value = values[0].value;
        this.value2 = values[1].value;
    }

    public boolean repeatsAttack() {
        if (this.value2 == 0) {
            if (this.count >= this.value) {
                return false;
            }
            ++this.count;
            return true;
        }
        if (this.count >= this.targetCount) {
            return false;
        }
        ++this.count;
        return true;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.limit++ <= 5 && this.inProgress) {
            return AttackResult.proceed;
        }
        user.inMultipleHit = true;
        this.inProgress = true;
        this.limit = 0;
        if (this.value2 != 0) {
            if (this.value == 2 && this.value2 == 5) {
                int random = RandomHelper.getRandomNumberBetween(0, 9);
                this.targetCount = user.bc.simulateMode ? 1 : (random < 3 ? 2 : (random < 6 ? 3 : (random < 8 ? 4 : 5)));
            } else {
                this.targetCount = RandomHelper.getRandomNumberBetween(this.value, this.value2);
            }
        }
        if (user.getBattleAbility() instanceof SkillLink) {
            this.targetCount = this.value2;
        }
        this.count = 0;
        int initAccuracy = user.attack.baseAttack.accuracy;
        boolean hasSubstitute = false;
        while (target.isAlive() && user.isAlive() && this.repeatsAttack()) {
            MoveResults[] results;
            user.attack.baseAttack.accuracy = -1;
            hasSubstitute = target.hasStatus(StatusType.Substitute);
            for (MoveResults result : results = user.useAttackOnly()) {
                user.attack.moveResult.damage += result.damage;
                user.attack.moveResult.fullDamage += result.fullDamage;
            }
        }
        user.attack.baseAttack.accuracy = initAccuracy;
        if (user.bc.simulateMode && this.targetCount == 1) {
            user.attack.moveResult.damage = (int)Math.min((double)user.attack.moveResult.damage * 3.168, (double)target.getHealth());
            user.attack.moveResult.fullDamage = (int)((double)user.attack.moveResult.fullDamage * 3.168);
        }
        user.inMultipleHit = false;
        this.inProgress = false;
        user.attack.sendEffectiveChat(user, target);
        user.bc.sendToAll("multiplehit.times", user.getNickname(), this.count);
        Attack.postProcessAttackAllHits(user, target, user.attack, user.attack.moveResult.damage, DamageTypeEnum.ATTACK, hasSubstitute);
        if (!hasSubstitute) {
            Attack.applyContactLate(user, target);
        }
        return AttackResult.hit;
    }
}

