/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.BattleBond;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Comatose;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Disguise;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Multitype;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.RKSSystem;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.StanceChange;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Truant;
import java.util.ArrayList;
import net.minecraft.util.text.translation.I18n;

public class ChangeAbility
extends SpecialAttackBase {
    Class<? extends AbilityBase> ability;

    public ChangeAbility(Class<? extends AbilityBase> ability) {
        this.ability = ability;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        AbilityBase targetAbility = target.getBattleAbility(false);
        if (targetAbility.getClass().equals(this.ability) || targetAbility instanceof Multitype || targetAbility instanceof StanceChange || targetAbility instanceof Truant || targetAbility instanceof Comatose || targetAbility instanceof RKSSystem || targetAbility instanceof BattleBond || targetAbility instanceof Disguise) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        user.bc.sendToAll("pixelmon.effect.entrainment", target.getNickname(), targetAbility.getLocalizedName(), I18n.func_74838_a((String)("ability." + this.ability.getSimpleName() + ".name")));
        target.setTempAbility(AbilityBase.getNewInstance(this.ability));
        return AttackResult.succeeded;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        ArrayList<PixelmonWrapper> allies = pw.getTeamPokemon();
        for (PixelmonWrapper target : userChoice.targets) {
            AbilityBase targetAbility = target.getBattleAbility(false);
            boolean negativeAbility = targetAbility.isNegativeAbility();
            boolean allied = allies.contains(target);
            if (allied && negativeAbility) {
                userChoice.raiseWeight(40.0f);
                continue;
            }
            if (allied || negativeAbility) continue;
            userChoice.raiseWeight(25.0f);
        }
    }
}

