/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TerrainExamine;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Flinch;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;

public class SecretPower
extends SpecialAttackBase {
    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (!target.isFainted() && RandomHelper.getRandomChance(30)) {
            TerrainExamine.TerrainType terrainType = TerrainExamine.getTerrain(user);
            switch (terrainType) {
                case Sand: {
                    target.getBattleStats().modifyStat(-1, StatsType.Accuracy);
                    break;
                }
                case Cave: 
                case Burial: 
                case Space: {
                    Flinch.flinch(user, target);
                }
                case Water: {
                    target.getBattleStats().modifyStat(-1, StatsType.Attack);
                    break;
                }
                case Sky: 
                case Swamp: {
                    target.getBattleStats().modifyStat(-1, StatsType.Speed);
                    break;
                }
                case Snow: 
                case Ice: {
                    Freeze.freeze(user, target);
                    break;
                }
                case Volcano: {
                    Burn.burn(user, target, user.attack, false);
                    break;
                }
                case Grass: {
                    Sleep.sleep(user, target, user.attack, false);
                    break;
                }
                case Misty: {
                    target.getBattleStats().modifyStat(-1, StatsType.SpecialAttack);
                    break;
                }
                default: {
                    Paralysis.paralyze(user, target, user.attack, false);
                }
            }
        }
    }
}

