/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.IceBody;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Overcoat;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SnowCloak;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Hail
extends Weather {
    public Hail() {
        this(5);
    }

    public Hail(int turnsToGo) {
        super(StatusType.Hail, turnsToGo, EnumHeldItems.icyRock, "pixelmon.effect.starthail", "pixelmon.status.heavyhail", "pixelmon.status.hailstopped");
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new Hail(turns);
    }

    @Override
    public void applyRepeatedEffect(BattleControllerBase bc) {
        for (PixelmonWrapper p : bc.getDefaultTurnOrder()) {
            if (this.isImmune(p)) continue;
            p.bc.sendToAll("pixelmon.status.hurthail", p.getNickname());
            p.doBattleDamage(p, p.getPercentMaxHealth(6.25f), DamageTypeEnum.WEATHER);
        }
    }

    @Override
    public boolean isImmune(PixelmonWrapper p) {
        AbilityBase ability = p.getBattleAbility();
        return p.hasType(EnumType.Ice) || p.isFainted() || ability instanceof MagicGuard || ability instanceof Overcoat || ability instanceof SnowCloak || ability instanceof IceBody || p.getUsableHeldItem().getHeldItemType() == EnumHeldItems.safetyGoggles;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        List<Attack> moveset;
        AbilityBase ability;
        int benefits = 0;
        if (!this.isImmune(target)) {
            --benefits;
        }
        if ((ability = target.getBattleAbility()) instanceof IceBody || ability instanceof SnowCloak) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset = user.getBattleAI().getMoveset(target), "Blizzard", "Weather Ball")) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, "SolarBeam")) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, "Moonlight", "Morning Sun", "Synthesis")) {
            --benefits;
        }
        return benefits;
    }
}

