/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Protect;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import java.util.ArrayList;

public class KingsShield
extends Protect {
    public KingsShield() {
        super(StatusType.KingsShield);
    }

    @Override
    protected boolean addStatus(PixelmonWrapper user) {
        return user.addStatus(new KingsShield(), user);
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return user.attack.baseAttack.attackCategory != 2 && super.stopsIncomingAttack(pokemon, user);
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        super.stopsIncomingAttackMessage(pokemon, user);
        if (user.attack.baseAttack.getMakesContact()) {
            user.getBattleStats().modifyStat(-2, StatsType.Attack, user, false);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        super.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        if (userChoice.weight != -1.0f) {
            StatsEffect statsEffect = new StatsEffect(StatsType.Attack, -2, false);
            block0: for (ArrayList<MoveChoice> choices : MoveChoice.splitChoices(pw.getOpponentPokemon(), bestOpponentChoices)) {
                for (MoveChoice choice : choices) {
                    if (!choice.isAttack() || !choice.attack.baseAttack.getMakesContact()) continue;
                    ArrayList<PixelmonWrapper> saveTargets = userChoice.targets;
                    ArrayList<PixelmonWrapper> newTargets = new ArrayList<PixelmonWrapper>();
                    newTargets.add(choice.user);
                    userChoice.targets = newTargets;
                    statsEffect.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
                    userChoice.targets = saveTargets;
                    continue block0;
                }
            }
        }
    }
}

