/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;

public class Powder
extends StatusBase {
    public Powder() {
        super(StatusType.Powder);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (!target.isImmuneToPowder() && target.addStatus(new Powder(), user)) {
            user.bc.sendToAll("pixelmon.status.powder", target.getNickname());
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public boolean stopsIncomingAttackUser(PixelmonWrapper pokemon, PixelmonWrapper user) {
        if (user.attack.baseAttack.attackType == EnumType.Fire) {
            user.bc.sendToAll("pixelmon.status.powderexplode", user.getNickname());
            user.doBattleDamage(user, user.getPercentMaxHealth(25.0f), DamageTypeEnum.STATUS);
            return true;
        }
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.hasOffensiveAttackType(bestOpponentChoices, EnumType.Fire)) {
            userChoice.raiseWeight(25.0f);
        }
    }
}

