/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.ArrayList;
import net.minecraft.util.text.TextComponentTranslation;

public class Taunt
extends StatusBase {
    int turnsRemaining = 3;

    public Taunt() {
        super(StatusType.Taunt);
    }

    @Override
    protected void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasStatus(this.type)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        } else {
            TextComponentTranslation message = ChatHandler.getMessage("pixelmon.status.taunted", target.getNickname());
            target.addStatus(new Taunt(), user, message);
        }
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (a.baseAttack.attackCategory != 2) {
            return true;
        }
        user.bc.sendToAll("pixelmon.status.tauntcantuse", user.getNickname(), a.baseAttack.getLocalizedName());
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.turnsRemaining == 0) {
            pw.bc.sendToAll("pixelmon.status.tauntnolonger", pw.getNickname());
            pw.removeStatus(this);
            return;
        }
        for (Attack attack : pw.getMoveset()) {
            if (attack == null || attack.baseAttack.attackCategory != 2) continue;
            attack.setDisabled(true, pw);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly() || MoveChoice.canOutspeedAnd2HKO(bestOpponentChoices, pw, bestUserChoices)) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            for (Attack attack : pw.getBattleAI().getMoveset(target)) {
                if (attack.baseAttack.attackCategory != 2) continue;
                userChoice.raiseWeight(20.0f);
            }
        }
    }
}

