/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawningHandler;
import com.pixelmonmod.pixelmon.blocks.spawning.SpawningBlock;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleStartTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPixelmonDoubleGrass
extends SpawningBlock
implements IGrowable,
IShearable,
IPlantable {
    public static final PropertyEnum<EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumBlockHalf.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1, 0.0, (double)0.1f, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockPixelmonDoubleGrass() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(3.0f);
    }

    public String func_149739_a() {
        return super.func_149739_a().substring(5);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    protected boolean canPlaceBlockOn(Block ground) {
        return ground == Blocks.field_150349_c || ground == Blocks.field_150346_d || ground == Blocks.field_150458_ak || ground == Blocks.field_150354_m;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof EntityPlayerMP) {
            BlockSpawningHandler.getInstance().performBattleStartCheck(worldIn, pos, entityIn, null, this.areaName, EnumBattleStartTypes.PUGRASSDOUBLE);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityPlayerMP) {
            BlockSpawningHandler.getInstance().performBattleStartCheck(worldIn, pos, entityIn, null, this.areaName, EnumBattleStartTypes.PUGRASSDOUBLE);
        }
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149679_a(int fortune, Random random) {
        return 1 + random.nextInt(fortune * 2 + 1);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(PixelmonBlocks.pixelmonGrassBlock, 1, 0));
        return ret;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177229_b(HALF) == EnumBlockHalf.LOWER;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            BlockPixelmonDoubleGrass object1;
            boolean flag = state.func_177229_b(HALF) == EnumBlockHalf.UPPER;
            BlockPos blockpos1 = flag ? pos : pos.func_177984_a();
            BlockPos blockpos2 = flag ? pos.func_177977_b() : pos;
            BlockPixelmonDoubleGrass object = flag ? this : worldIn.func_180495_p(blockpos1).func_177230_c();
            BlockPixelmonDoubleGrass blockPixelmonDoubleGrass = object1 = flag ? worldIn.func_180495_p(blockpos2).func_177230_c() : this;
            if (!flag) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            if (object == this) {
                worldIn.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
            }
            if (object1 == this) {
                worldIn.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos down = pos.func_177977_b();
        Block soil = worldIn.func_180495_p(down).func_177230_c();
        if (state.func_177230_c() != this) {
            return this.canPlaceBlockOn(soil);
        }
        return soil.canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)this);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public void placeAt(World worldIn, BlockPos lowerPos, int flags) {
        worldIn.func_180501_a(lowerPos, this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER)), flags);
        worldIn.func_180501_a(lowerPos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)), flags);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)), 2);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (!worldIn.field_72995_K) {
                        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == Items.field_151097_aZ) {
                            worldIn.func_175698_g(pos.func_177977_b());
                        } else {
                            worldIn.func_175655_b(pos.func_177977_b(), true);
                        }
                    } else {
                        worldIn.func_175698_g(pos.func_177977_b());
                    }
                } else {
                    worldIn.func_175698_g(pos.func_177977_b());
                }
            }
        } else if (player.field_71075_bZ.field_75098_d && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (state.func_177230_c() == this && state.func_177229_b(HALF) == EnumBlockHalf.LOWER && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        }
        return world.func_175698_g(pos);
    }

    static enum EnumBlockHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

