/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class TileEntityHealer
extends TileEntity
implements ITickable {
    private static final int ticksToPlace = 5;
    private static final int ticksToHeal = 100;
    public boolean beingUsed = false;
    public EnumPokeballs[] pokeballType = new EnumPokeballs[6];
    private PlayerStorage storage;
    public EntityPlayer player;
    private int pokemonLastPlaced = -1;
    private float healingRate = 1.0f;
    private int tickCount = 0;
    public float rotation = 0.0f;
    public int flashTimer = 0;
    public boolean allPlaced = false;
    public boolean playSound = false;
    public boolean stayDark = false;

    public void use(NPCNurseJoy npc, EntityPlayer player) {
        this.startHealing(player, 1.5f);
    }

    public void use(EntityPlayer player) {
        this.startHealing(player, 1.0f);
    }

    private void startHealing(EntityPlayer player, float healingRate) {
        this.healingRate = healingRate;
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)player);
        if (optstorage.isPresent()) {
            this.storage = optstorage.get();
            this.storage.teleportPos.store(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            this.player = player;
            this.beingUsed = true;
            if (healingRate == 1.5f) {
                BlockPos pos = this.func_174877_v();
                player.openGui((Object)Pixelmon.instance, EnumGui.HealerNurseJoy.getIndex().intValue(), player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                player.openGui((Object)Pixelmon.instance, EnumGui.Healer.getIndex().intValue(), player.field_70170_p, 0, 0, 0);
            }
            this.tickCount = 0;
            this.allPlaced = false;
            this.pokemonLastPlaced = -1;
            for (int i = 0; i < this.pokeballType.length; ++i) {
                this.pokeballType[i] = null;
            }
            this.stayDark = false;
        }
        if (!this.field_145850_b.field_72995_K && this.beingUsed) {
            this.sendRedstoneSignal();
        }
    }

    private int getTicksToHeal() {
        return (int)(100.0f / this.healingRate);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.rotation += 19.0f;
            ++this.flashTimer;
            return;
        }
        if (this.beingUsed) {
            int ticksToHeal;
            if (this.allPlaced && !this.playSound) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, PixelSounds.healerActive, SoundCategory.BLOCKS, 0.7f, 1.0f);
                this.playSound = true;
            }
            ++this.tickCount;
            if (!this.allPlaced && this.tickCount == 5) {
                boolean hasNextPokemon = false;
                for (int i = this.pokemonLastPlaced + 1; i < this.storage.getList().length; ++i) {
                    Optional<EntityPixelmon> pixelmonOptional;
                    if (this.storage.getList()[i] == null) continue;
                    this.pokemonLastPlaced = i;
                    hasNextPokemon = true;
                    this.pokeballType[i] = EnumPokeballs.getFromIndex(this.storage.getList()[i].func_74762_e("CaughtBall"));
                    Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage((EntityPlayerMP)this.player);
                    if (!optstorage.isPresent() || !(pixelmonOptional = optstorage.get().getAlreadyExists(PixelmonMethods.getID(this.storage.getList()[i]), this.player.field_70170_p)).isPresent()) break;
                    EntityPixelmon pixelmon = pixelmonOptional.get();
                    pixelmon.catchInPokeball();
                    break;
                }
                if (!hasNextPokemon) {
                    this.allPlaced = true;
                }
                this.tickCount = 0;
                this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, 0, (Packet)this.func_189518_D_());
            }
            if (this.tickCount == (ticksToHeal = this.getTicksToHeal()) - 30) {
                this.stayDark = true;
                this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, 0, (Packet)this.func_189518_D_());
            }
            if (this.tickCount == ticksToHeal) {
                this.storage.healAllPokemon(this.field_145850_b);
                this.beingUsed = false;
                this.playSound = false;
                this.field_145850_b.func_73046_m().func_184103_al().func_148543_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, 0, (Packet)this.func_189518_D_());
                this.player.func_71053_j();
                if (!this.field_145850_b.field_72995_K) {
                    this.sendRedstoneSignal();
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < this.pokeballType.length; ++i) {
            if (this.pokeballType[i] == null) continue;
            nbt.func_74777_a("PokeballType" + i, (short)this.pokeballType[i].ordinal());
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < this.pokeballType.length; ++i) {
            this.pokeballType[i] = null;
            if (!nbt.func_74764_b("PokeballType" + i)) continue;
            this.pokeballType[i] = EnumPokeballs.getFromIndex(nbt.func_74765_d("PokeballType" + i));
        }
        if (nbt.func_74764_b("BeingUsed")) {
            this.beingUsed = nbt.func_74767_n("BeingUsed");
            this.allPlaced = nbt.func_74767_n("AllPlaced");
            this.stayDark = nbt.func_74767_n("StayDark");
        }
        if (nbt.func_74764_b("HealRate")) {
            this.healingRate = nbt.func_74760_g("HealRate");
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        nbt.func_74757_a("BeingUsed", this.beingUsed);
        nbt.func_74757_a("AllPlaced", this.allPlaced);
        nbt.func_74757_a("StayDark", this.stayDark);
        nbt.func_74776_a("HealRate", this.healingRate);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    private void sendRedstoneSignal() {
        Block block = this.func_145838_q();
        if (block != null) {
            this.field_145850_b.func_175685_c(this.field_174879_c, block, true);
        }
    }
}

