/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.custom.overlays;

import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.GraphicDisplayTypes;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.GraphicTypes;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.awt.Color;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.command.CommandBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CustomNoticeOverlay {
    private static boolean enabled = false;
    private static Collection<String> noticeLines;
    private static GraphicTypes graphicType;
    private static GraphicDisplayTypes graphicDisplayType;
    private static int nationalDexID;
    private static int squareSize;
    private static EntityPixelmon pokemonToRender;
    private static ItemStack itemStackToRender;
    private static ResourceLocation itemSpriteToRender;

    public static void resetNotice() {
        enabled = false;
        noticeLines = null;
        graphicType = null;
        graphicDisplayType = null;
        pokemonToRender = null;
        itemStackToRender = null;
        itemSpriteToRender = null;
    }

    public static void draw(ScaledResolution scaledResolution) {
        Optional<int[]> coordsOptional = GuiHelper.renderTooltip(scaledResolution.func_78326_a() / 2, 15, noticeLines, Color.RED.getRGB(), Color.BLACK.getRGB(), 100, true, true);
        if (coordsOptional.isPresent()) {
            int[] coords = coordsOptional.get();
            if (graphicType != null) {
                switch (graphicType) {
                    case PokemonSprite: {
                        CustomNoticeOverlay.drawPokemonSprites(coords);
                        break;
                    }
                    case Pokemon3D: {
                        CustomNoticeOverlay.drawPokemon3Ds(coords);
                        break;
                    }
                    case ItemSprite: {
                        CustomNoticeOverlay.drawItemSprites(coords);
                        break;
                    }
                    case Item3D: {
                        CustomNoticeOverlay.drawItem3Ds(coords);
                    }
                }
            }
        }
    }

    public static void setItem3D(String itemName, GraphicDisplayTypes displayType) {
        try {
            graphicType = GraphicTypes.Item3D;
            graphicDisplayType = displayType;
            itemStackToRender = new ItemStack(CommandBase.func_147179_f(null, (String)itemName));
        }
        catch (Exception e) {
            System.out.println("Someone prob borked up the item name " + itemName);
            e.printStackTrace();
        }
    }

    public static void setPokemon3D(EnumPokemon pokemon, GraphicDisplayTypes displayType) {
        graphicType = GraphicTypes.Pokemon3D;
        graphicDisplayType = displayType;
        pokemonToRender = (EntityPixelmon)PixelmonEntityList.createEntityByName(pokemon.name, (World)Minecraft.func_71410_x().field_71441_e);
        pokemonToRender.setGrowth(EnumGrowth.Ordinary);
    }

    public static void setPokemonSprite(EnumPokemon pokemon, GraphicDisplayTypes displayType) {
        nationalDexID = Entity3HasStats.getBaseStats((String)pokemon.name).get().nationalPokedexNumber;
        graphicType = GraphicTypes.PokemonSprite;
        graphicDisplayType = displayType;
    }

    public static void setItemSprite(String itemName, GraphicDisplayTypes displayType) {
        try {
            graphicType = GraphicTypes.ItemSprite;
            graphicDisplayType = displayType;
            itemStackToRender = new ItemStack(CommandBase.func_147179_f(null, (String)itemName));
            String[] split = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(itemStackToRender).func_177554_e().func_94215_i().split(":");
            itemSpriteToRender = new ResourceLocation(split[0], "textures/" + split[1] + ".png");
        }
        catch (Exception e) {
            System.out.println("Someone prob borked up the item name " + itemName);
            e.printStackTrace();
        }
    }

    public static void populate(Collection<String> noticeLines) {
        CustomNoticeOverlay.noticeLines = noticeLines;
    }

    public static void setEnabled(boolean enabled) {
        CustomNoticeOverlay.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private static void drawItem3Ds(int[] coords) {
        RenderHelper.func_74519_b();
        switch (graphicDisplayType) {
            case LeftOnly: {
                Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStackToRender, coords[0] - 20, 15);
                break;
            }
            case RightOnly: {
                Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStackToRender, coords[2] + 5, 15);
                break;
            }
            case LeftRight: {
                Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStackToRender, coords[0] - 20, 15);
                Minecraft.func_71410_x().func_175599_af().func_175042_a(itemStackToRender, coords[2] + 5, 15);
            }
        }
    }

    private static void drawItemSprites(int[] coords) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(itemSpriteToRender);
        switch (graphicDisplayType) {
            case LeftOnly: {
                GuiHelper.drawImageQuad(coords[0] - squareSize, 0.0, squareSize, squareSize, 1.0, 0.0, 0.0, 1.0, 300.0f);
                break;
            }
            case RightOnly: {
                GuiHelper.drawImageQuad(coords[2], 0.0, squareSize, squareSize, 1.0, 0.0, 0.0, 1.0, 300.0f);
                break;
            }
            case LeftRight: {
                GuiHelper.drawImageQuad(coords[0] - squareSize, 0.0, squareSize, squareSize, 1.0, 0.0, 0.0, 1.0, 300.0f);
                GuiHelper.drawImageQuad(coords[2], 0.0, squareSize, squareSize, 0.0, 0.0, 1.0, 1.0, 300.0f);
            }
        }
    }

    private static void drawPokemon3Ds(int[] coords) {
        float scale = CustomNoticeOverlay.pokemonToRender.baseStats.giScale * 10.0f;
        GuiHelper.drawEntity((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, 0, 0, scale, 0.0f, 0.0f);
        switch (graphicDisplayType) {
            case LeftOnly: {
                GuiHelper.drawEntity((EntityLivingBase)pokemonToRender, coords[0] - 15, squareSize - 5, scale, 0.0f, 0.0f);
                break;
            }
            case RightOnly: {
                GuiHelper.drawEntity((EntityLivingBase)pokemonToRender, coords[2] + 10, squareSize - 5, scale, 0.0f, 0.0f);
                break;
            }
            case LeftRight: {
                GuiHelper.drawEntity((EntityLivingBase)pokemonToRender, coords[0] - 15, squareSize - 5, scale, 0.0f, 0.0f);
                GuiHelper.drawEntity((EntityLivingBase)pokemonToRender, coords[2] + 10, squareSize - 5, scale, 0.0f, 0.0f);
            }
        }
    }

    private static void drawPokemonSprites(int[] coords) {
        GuiHelper.bindPokemonSprite(nationalDexID, false, Minecraft.func_71410_x());
        switch (graphicDisplayType) {
            case LeftOnly: {
                GuiHelper.drawImageQuad(coords[0] - squareSize, 0.0, squareSize, squareSize, 1.0, 0.0, 0.0, 1.0, 300.0f);
                break;
            }
            case RightOnly: {
                GuiHelper.drawImageQuad(coords[2], 0.0, squareSize, squareSize, 1.0, 0.0, 0.0, 1.0, 300.0f);
                break;
            }
            case LeftRight: {
                GuiHelper.drawImageQuad(coords[0] - squareSize, 0.0, squareSize, squareSize, 1.0, 0.0, 0.0, 1.0, 300.0f);
                GuiHelper.drawImageQuad(coords[2], 0.0, squareSize, squareSize, 0.0, 0.0, 1.0, 1.0, 300.0f);
            }
        }
    }

    static {
        squareSize = 40;
    }
}

