/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.GuiWarning;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerMoves;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.DeleteMove;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

class GuiScreenPokeCheckerWarningDeleteMove
extends GuiWarning {
    private PixelmonData targetPacket;
    private int moveToDelete;
    private Attack attack;

    GuiScreenPokeCheckerWarningDeleteMove(GuiContainer previousScreen, PixelmonData targetPacket, int moveToDelete) {
        super(previousScreen);
        this.targetPacket = targetPacket;
        this.moveToDelete = moveToDelete;
    }

    @Override
    protected void confirmAction() {
        Pixelmon.network.sendToServer((IMessage)new DeleteMove(this.targetPacket.pokemonID, this.moveToDelete));
        if (this.previousScreen instanceof GuiScreenPokeCheckerMoves) {
            GuiScreenPokeCheckerMoves moveScreen = (GuiScreenPokeCheckerMoves)this.previousScreen;
            moveScreen.reloadMoves();
        }
    }

    @Override
    protected void drawWarningText() {
        this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_74838_a((String)"gui.screenpokechecker.forget1"), 60, 68, 0xFFFFFF);
        this.func_73732_a(this.field_146297_k.field_71466_p, RegexPatterns.$_P_VAR.matcher(I18n.func_74838_a((String)"gui.screenpokechecker.forget2")).replaceAll(this.targetPacket.getEscapedNickname()), 60, 78, 0xFFFFFF);
        if (this.attack == null) {
            this.attack = DatabaseMoves.getAttack(this.targetPacket.moveset[this.moveToDelete].attackIndex);
        }
        this.func_73732_a(this.field_146297_k.field_71466_p, this.attack.baseAttack.getLocalizedName() + "?", 60, 88, 0xFFFFFF);
    }
}

