/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import com.pixelmonmod.pixelmon.util.MoveCostList;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class LearnMove
implements IMessage {
    int[] pokemonId;
    int attackId;
    boolean checkAble;
    int npcId;

    public LearnMove() {
    }

    public LearnMove(int[] pokemonId, int attackId, boolean checkAble, int npcId) {
        this.pokemonId = pokemonId;
        this.attackId = attackId;
        this.checkAble = checkAble;
        this.npcId = npcId;
    }

    public LearnMove(int[] pokemonId, int attackId, int npcId) {
        this(pokemonId, attackId, false, npcId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonId = new int[]{buffer.readInt(), buffer.readInt()};
        this.attackId = buffer.readInt();
        this.checkAble = buffer.readBoolean();
        this.npcId = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pokemonId[0]);
        buffer.writeInt(this.pokemonId[1]);
        buffer.writeInt(this.attackId);
        buffer.writeBoolean(this.checkAble);
        buffer.writeInt(this.npcId);
    }

    public static class Handler
    implements IMessageHandler<LearnMove, IMessage> {
        public IMessage onMessage(LearnMove message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_184102_h().func_152344_a(() -> {
                Optional<EntityPixelmon> entityPixelmonOptional;
                Attack a = DatabaseMoves.getAttack(message.attackId);
                Optional<EntityNPC> npc = EntityNPC.locateNPCServer(player.field_70170_p, message.npcId, EntityNPC.class);
                ArrayList<ItemStack> costs = new ArrayList<ItemStack>();
                if (!npc.isPresent()) return;
                if (npc.get() instanceof NPCRelearner) {
                    ItemStack cost = ((NPCRelearner)npc.get()).getCost();
                    if (!cost.func_190926_b()) {
                        costs.add(cost);
                    }
                } else {
                    if (!(npc.get() instanceof NPCTutor)) return;
                    NPCTutor tutor = (NPCTutor)npc.get();
                    for (int i = 0; i < tutor.attackList.size(); ++i) {
                        ArrayList<ItemStack> array;
                        if (!a.equals(tutor.attackList.get(i)) || (array = tutor.costs.get(i)).size() < 1) continue;
                        costs = array;
                    }
                }
                Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
                if (!optstorage.isPresent()) return;
                PlayerStorage storage = optstorage.get();
                if (!costs.isEmpty() && !player.field_71075_bZ.field_75098_d) {
                    MoveCostList.addToList(player, costs);
                }
                EntityPixelmon p = (entityPixelmonOptional = storage.getAlreadyExists(message.pokemonId, player.field_70170_p)).isPresent() ? entityPixelmonOptional.get() : storage.sendOut(message.pokemonId, player.field_70170_p);
                if (message.checkAble && !DatabaseMoves.CanLearnAttack(p.baseStats.baseFormID, a.baseAttack.getUnLocalizedName())) {
                    return;
                }
                if (p == null || p.getMoveset() == null) {
                    return;
                }
                if (p.getMoveset().size() >= 4) {
                    Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(p.getPokemonId(), a.baseAttack.attackIndex, 0, p.getLvl().getLevel()), (EntityPlayerMP)p.func_70902_q());
                    return;
                } else if (MoveCostList.checkEntry(player)) {
                    p.getMoveset().add(a);
                    p.update(EnumUpdateType.Moveset);
                    ChatHandler.sendChat((Entity)p.func_70902_q(), "pixelmon.stats.learnedmove", p.getNickname(), a.baseAttack.getLocalizedName());
                    return;
                } else {
                    if (!message.checkAble) return;
                    ChatHandler.sendChat((Entity)p.func_70902_q(), "pixelmon.npc.cantpay", new Object[0]);
                }
            });
            return null;
        }
    }
}

