/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.cosmetics.Cosmetic;
import com.pixelmonmod.pixelmon.cosmetics.CosmeticType;
import com.pixelmonmod.pixelmon.cosmetics.PlayerCosmetics;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlayerCosmeticPacket
implements IMessage {
    private String cosmeticType;
    private int index;

    public PlayerCosmeticPacket() {
        this.cosmeticType = "Back";
        this.index = -1;
    }

    public PlayerCosmeticPacket(CosmeticType type, int index) {
        this.cosmeticType = type.name();
        this.index = index;
    }

    public void fromBytes(ByteBuf buf) {
        this.cosmeticType = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.index = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.cosmeticType);
        buf.writeInt(this.index);
    }

    public static class Handler
    implements IMessageHandler<PlayerCosmeticPacket, IMessage> {
        public IMessage onMessage(PlayerCosmeticPacket message, MessageContext ctx) {
            Cosmetic[] allCosmetics;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            PlayerCosmetics playerCosmetics = Pixelmon.instance.getCosmeticHandler().getPlayerCosmetics(player.func_110124_au());
            CosmeticType type = CosmeticType.getType(message.cosmeticType);
            int index = message.index;
            if (index >= (allCosmetics = playerCosmetics.getAllCosmetics()).length || index == -1) {
                if (index == -1) {
                    playerCosmetics.reset(type);
                }
                return null;
            }
            Cosmetic cosmeticToActivate = allCosmetics[index];
            playerCosmetics.setActiveCosmetic(cosmeticToActivate);
            System.out.println("Set Active Cosmetic - " + cosmeticToActivate.toString());
            return null;
        }
    }
}

