/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.events.BreedEvent;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity10CanBreed;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Breed
extends PixelmonCommand {
    public Breed() {
        super(new PixelmonCommand[0]);
    }

    public String func_71517_b() {
        return "breed";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/breed <username> <party slot #1> <party slot #2>";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1 && args.length != 3) {
            CommandChatHandler.sendChat(sender, "pixelmon.command.general.invalid", new Object[0]);
            CommandChatHandler.sendChat(sender, this.func_71518_a(sender), new Object[0]);
            return;
        }
        EntityPlayerMP player = this.getPlayer(sender, args[0]);
        if (player == null) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalidplayer", new Object[0]);
            return;
        }
        PlayerStorage storage = this.getPlayerStorage(player);
        if (storage != null) {
            NBTTagCompound[] all_nbt = storage.getList();
            int intPartyPosition1 = -1;
            int intPartyPosition2 = -1;
            if (args.length == 1) {
                boolean pairFound = false;
                for (int x = 0; x < all_nbt.length; ++x) {
                    NBTTagCompound nbt1 = all_nbt[x];
                    if (nbt1 != null) {
                        for (int y = 0; y < all_nbt.length; ++y) {
                            NBTTagCompound nbt2 = all_nbt[y];
                            if (nbt1 != nbt2 && nbt2 != null && Entity10CanBreed.canBreed((EntityPixelmon)PixelmonEntityList.createEntityFromNBT(nbt1, player.field_70170_p), (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(nbt2, player.field_70170_p))) {
                                pairFound = true;
                                intPartyPosition1 = x;
                                intPartyPosition2 = y;
                            }
                            if (pairFound) break;
                        }
                    }
                    if (!pairFound) {
                        continue;
                    }
                    break;
                }
            } else if (args.length == 3) {
                intPartyPosition1 = Breed.func_180528_a((String)args[1], (int)1) - 1;
                intPartyPosition2 = Breed.func_180528_a((String)args[2], (int)1) - 1;
                if (intPartyPosition1 > 5 || intPartyPosition1 < 0) {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.breed.invalidslot", "1");
                    this.sendMessage(sender, TextFormatting.RED, this.func_71518_a(sender), new Object[0]);
                    return;
                }
                if (intPartyPosition2 > 5 || intPartyPosition2 < 0) {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.breed.invalidslot", "2");
                    this.sendMessage(sender, TextFormatting.RED, this.func_71518_a(sender), new Object[0]);
                    return;
                }
            }
            if (intPartyPosition1 == -1 || intPartyPosition2 == -1) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.breed.novalidpairs", player.func_145748_c_().func_150260_c());
                return;
            }
            int nullPartySlot = -1;
            if (all_nbt[intPartyPosition1] == null) {
                nullPartySlot = intPartyPosition1 + 1;
            } else if (all_nbt[intPartyPosition2] == null) {
                nullPartySlot = intPartyPosition2 + 1;
            }
            if (nullPartySlot > -1) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.breed.nullslot", nullPartySlot);
                return;
            }
            EntityPixelmon pixelmon1 = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(all_nbt[intPartyPosition1], player.field_70170_p);
            EntityPixelmon pixelmon2 = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(all_nbt[intPartyPosition2], player.field_70170_p);
            if (!pixelmon1.isEgg && !pixelmon2.isEgg && Entity10CanBreed.canBreed(pixelmon1, pixelmon2)) {
                EntityPixelmon egg = (EntityPixelmon)PixelmonEntityList.createEntityByName("Magikarp", player.field_70170_p);
                egg.makeEntityIntoEgg(pixelmon1, pixelmon2);
                BreedEvent.MakeEgg makeEvent = new BreedEvent.MakeEgg(player.func_110124_au(), null, egg, pixelmon2, pixelmon2);
                if (Pixelmon.EVENT_BUS.post((Event)makeEvent)) {
                    return;
                }
                BreedEvent.CollectEgg eggEvent = new BreedEvent.CollectEgg(player.func_110124_au(), null, makeEvent.getEgg());
                Pixelmon.EVENT_BUS.post((Event)eggEvent);
                this.sendMessage(sender, "pixelmon.command.breed.giveegg", pixelmon1.getNickname(), pixelmon2.getNickname());
                storage.addToParty(eggEvent.getEgg());
            } else {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.breed.notcompatible", pixelmon1.isEgg ? I18n.func_74838_a((String)"pixelmon.egg.name") : pixelmon1.getNickname(), pixelmon2.isEgg ? I18n.func_74838_a((String)"pixelmon.egg.name") : pixelmon2.getNickname());
            }
        } else {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalidplayer", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return this.tabCompleteUsernames(args);
        }
        if (args.length == 2 || args.length == 3) {
            return Breed.func_71530_a((String[])args, (String[])new String[]{"1", "2", "3", "4", "5", "6"});
        }
        return Collections.emptyList();
    }
}

