/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.CompositeSpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.conditions.SpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnConditionTypeAdapter;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;

public class BetterSpawnerConfig {
    public static BetterSpawnerConfig INSTANCE = null;
    public static final String PATH = "config/pixelmon/BetterSpawnerConfig.json";
    public static final HashMap<String, Long> intervalTimes = new HashMap();
    public CompositeSpawnCondition globalCompositeCondition = new CompositeSpawnCondition();
    public HashMap<String, Integer> intervalSeconds = new HashMap();
    public HashMap<String, ArrayList<String>> blockCategories = new HashMap();
    public HashMap<String, ArrayList<String>> biomeCategories = new HashMap();

    public static void load() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(SpawnCondition.class, (Object)new SpawnConditionTypeAdapter()).create();
            File file = new File(PATH);
            file.getParentFile().mkdirs();
            try {
                if (file.exists()) {
                    INSTANCE = (BetterSpawnerConfig)gson.fromJson((Reader)new FileReader(PATH), BetterSpawnerConfig.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (INSTANCE == null) {
                INSTANCE = new BetterSpawnerConfig();
                SpawnCondition condition = new SpawnCondition();
                condition.dimensions = Lists.newArrayList(PixelmonConfig.spawnDimensions);
                BetterSpawnerConfig.INSTANCE.globalCompositeCondition = new CompositeSpawnCondition(Lists.newArrayList((Object[])new SpawnCondition[]{condition}), Lists.newArrayList());
                BetterSpawnerConfig.INSTANCE.blockCategories.put("land", Lists.newArrayList((Object[])new String[]{Blocks.field_150405_ch.getRegistryName().toString(), Blocks.field_150406_ce.getRegistryName().toString(), Blocks.field_192442_dQ.getRegistryName().toString(), Blocks.field_192438_dM.getRegistryName().toString(), Blocks.field_192439_dN.getRegistryName().toString(), Blocks.field_192436_dK.getRegistryName().toString(), Blocks.field_192434_dI.getRegistryName().toString(), Blocks.field_192440_dO.getRegistryName().toString(), Blocks.field_192430_dE.getRegistryName().toString(), Blocks.field_192432_dG.getRegistryName().toString(), Blocks.field_192429_dD.getRegistryName().toString(), Blocks.field_192428_dC.getRegistryName().toString(), Blocks.field_192433_dH.getRegistryName().toString(), Blocks.field_192437_dL.getRegistryName().toString(), Blocks.field_192441_dP.getRegistryName().toString(), Blocks.field_192435_dJ.getRegistryName().toString(), Blocks.field_192427_dB.getRegistryName().toString(), Blocks.field_192431_dF.getRegistryName().toString(), Blocks.field_150349_c.getRegistryName().toString(), Blocks.field_150346_d.getRegistryName().toString(), Blocks.field_150348_b.getRegistryName().toString(), Blocks.field_150392_bi.getRegistryName().toString(), Blocks.field_150354_m.getRegistryName().toString(), Blocks.field_150351_n.getRegistryName().toString(), Blocks.field_150391_bh.getRegistryName().toString(), Blocks.field_150433_aE.getRegistryName().toString(), Blocks.field_150424_aL.getRegistryName().toString(), Blocks.field_150425_aM.getRegistryName().toString(), Blocks.field_150432_aD.getRegistryName().toString(), Blocks.field_185778_de.getRegistryName().toString(), Blocks.field_150403_cj.getRegistryName().toString(), "biomesoplenty:ash_block", "biomesoplenty:dirt", "biomesoplenty:dried_sand", "biomesoplenty:grass"}));
                BetterSpawnerConfig.INSTANCE.blockCategories.put("air", Lists.newArrayList((Object[])new String[]{Blocks.field_150350_a.getRegistryName().toString(), Blocks.field_150329_H.getRegistryName().toString(), Blocks.field_150431_aC.getRegistryName().toString(), Blocks.field_150328_O.getRegistryName().toString(), Blocks.field_150327_N.getRegistryName().toString(), PixelmonBlocks.pixelmonGrassBlock.getRegistryName().toString(), PixelmonBlocks.pokeGrassBlock.getRegistryName().toString(), "biomesoplenty:double_plant", "biomesoplenty:flower_0", "biomesoplenty:flower_1", "biomesoplenty:mushroom", "biomesoplenty:plant_0", "biomesoplenty:plant_1"}));
                BetterSpawnerConfig.INSTANCE.blockCategories.put("water", Lists.newArrayList((Object[])new String[]{Blocks.field_150355_j.getRegistryName().toString(), "biomesoplenty:coral", "biomesoplenty:hot_spring_water", "biomesoplenty:seaweed"}));
                BetterSpawnerConfig.INSTANCE.blockCategories.put("lava", Lists.newArrayList((Object[])new String[]{Blocks.field_150353_l.getRegistryName().toString()}));
                BetterSpawnerConfig.INSTANCE.blockCategories.put("seesSkyException", Lists.newArrayList((Object[])new String[]{Blocks.field_150362_t.getRegistryName().toString(), Blocks.field_150361_u.getRegistryName().toString(), PixelmonBlocks.hiddenCube.getRegistryName().toString(), "biomesoplenty:leaves_0", "biomesoplenty:leaves_1", "biomesoplenty:leaves_2", "biomesoplenty:leaves_3", "biomesoplenty:leaves_4", "biomesoplenty:leaves_5"}));
                BetterSpawnerConfig.INSTANCE.blockCategories.put("high grass", Lists.newArrayList((Object[])new String[]{Blocks.field_150329_H.getRegistryName().toString(), PixelmonBlocks.pixelmonGrassBlock.getRegistryName().toString(), PixelmonBlocks.pokeGrassBlock.getRegistryName().toString()}));
                BetterSpawnerConfig.INSTANCE.blockCategories.put("beach", Lists.newArrayList((Object[])new String[]{Blocks.field_150354_m.getRegistryName().toString(), Blocks.field_150435_aG.getRegistryName().toString(), "biomesoplenty:white_sand"}));
                BetterSpawnerConfig.INSTANCE.intervalSeconds.put("legendary", 7200);
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("oceanic", Lists.newArrayList((Object[])new String[]{Biomes.field_76771_b.getRegistryName().toString(), Biomes.field_150575_M.getRegistryName().toString(), Biomes.field_76776_l.getRegistryName().toString(), "coral_reef", "kelp_forest"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("arid", Lists.newArrayList((Object[])new String[]{Biomes.field_76769_d.getRegistryName().toString(), Biomes.field_76786_s.getRegistryName().toString(), Biomes.field_185442_R.getRegistryName().toString(), "outback", "shrubland"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("mountainous", Lists.newArrayList((Object[])new String[]{Biomes.field_76770_e.getRegistryName().toString(), Biomes.field_76783_v.getRegistryName().toString(), Biomes.field_150580_W.getRegistryName().toString(), Biomes.field_185443_S.getRegistryName().toString(), Biomes.field_185434_af.getRegistryName().toString(), "alps", "crag", "highland", "mountain", "overgrown_cliffs"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("freezing", Lists.newArrayList((Object[])new String[]{Biomes.field_150584_S.getRegistryName().toString(), Biomes.field_150579_T.getRegistryName().toString(), Biomes.field_150577_O.getRegistryName().toString(), Biomes.field_76777_m.getRegistryName().toString(), Biomes.field_76776_l.getRegistryName().toString(), Biomes.field_185431_ac.getRegistryName().toString(), Biomes.field_76775_o.getRegistryName().toString(), Biomes.field_76774_n.getRegistryName().toString(), Biomes.field_185445_W.getRegistryName().toString(), "alps", "alps_foothills", "cold_desert", "coniferous_forest", "crag", "snowy_coniferous_forest", "snowy_forest", "tundra", "glacier"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("freezing mountains", Lists.newArrayList((Object[])new String[]{Biomes.field_76775_o.getRegistryName().toString(), Biomes.field_150579_T.getRegistryName().toString(), "alps", "crag"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("mesas", Lists.newArrayList((Object[])new String[]{Biomes.field_150589_Z.getRegistryName().toString(), Biomes.field_150608_ab.getRegistryName().toString(), Biomes.field_150607_aa.getRegistryName().toString(), Biomes.field_185437_ai.getRegistryName().toString(), Biomes.field_185439_ak.getRegistryName().toString(), Biomes.field_185438_aj.getRegistryName().toString()}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("savannas", Lists.newArrayList((Object[])new String[]{Biomes.field_150588_X.getRegistryName().toString(), Biomes.field_150587_Y.getRegistryName().toString(), Biomes.field_185435_ag.getRegistryName().toString(), Biomes.field_185436_ah.getRegistryName().toString(), "brushland", "lush_desert", "outback", "xeric_shrubland"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("jungles", Lists.newArrayList((Object[])new String[]{Biomes.field_76782_w.getRegistryName().toString(), Biomes.field_150574_L.getRegistryName().toString(), Biomes.field_76792_x.getRegistryName().toString(), Biomes.field_185446_X.getRegistryName().toString(), Biomes.field_185447_Y.getRegistryName().toString(), "eucalyptus_forest", "overgrown_cliffs", "rainforest", "tropical_rainforest", "tropical_island"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("flowery", Lists.newArrayList((Object[])new String[]{Biomes.field_185441_Q.getRegistryName().toString(), Biomes.field_185444_T.getRegistryName().toString(), "cherry_blossom_grove", "flower_field", "lavender_fields"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("swamps", Lists.newArrayList((Object[])new String[]{Biomes.field_76780_h.getRegistryName().toString(), Biomes.field_150599_m.getRegistryName().toString(), "bayou", "bog", "dead_swamp", "fen", "land_of_lakes", "lush_swamp", "mangrove", "marsh", "moor", "quagmire", "wetland"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("taigas", Lists.newArrayList((Object[])new String[]{Biomes.field_76768_g.getRegistryName().toString(), Biomes.field_76784_u.getRegistryName().toString(), Biomes.field_150590_f.getRegistryName().toString()}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("redwoods", Lists.newArrayList((Object[])new String[]{Biomes.field_150578_U.getRegistryName().toString(), Biomes.field_150581_V.getRegistryName().toString(), Biomes.field_185432_ad.getRegistryName().toString(), Biomes.field_185433_ae.getRegistryName().toString(), "redwood_forest"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("birches", Lists.newArrayList((Object[])new String[]{Biomes.field_150583_P.getRegistryName().toString(), Biomes.field_150582_Q.getRegistryName().toString(), Biomes.field_185448_Z.getRegistryName().toString(), Biomes.field_185429_aa.getRegistryName().toString()}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("forests", Lists.newArrayList((Object[])new String[]{Biomes.field_76767_f.getRegistryName().toString(), Biomes.field_76785_t.getRegistryName().toString(), Biomes.field_185444_T.getRegistryName().toString(), Biomes.field_150585_R.getRegistryName().toString(), Biomes.field_185430_ab.getRegistryName().toString(), "boreal_forest", "maple_woods", "orchard", "seasonal_forest", "woodland"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("mushroom", Lists.newArrayList((Object[])new String[]{Biomes.field_76789_p.getRegistryName().toString(), Biomes.field_76788_q.getRegistryName().toString(), "fungi_forest"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("plains", Lists.newArrayList((Object[])new String[]{Biomes.field_76772_c.getRegistryName().toString(), Biomes.field_185441_Q.getRegistryName().toString(), "chaparral", "grassland", "grove", "prairie", "steppe"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("hills", Lists.newArrayList((Object[])new String[]{Biomes.field_150582_Q.getRegistryName().toString(), Biomes.field_150579_T.getRegistryName().toString(), Biomes.field_76786_s.getRegistryName().toString(), Biomes.field_76785_t.getRegistryName().toString(), Biomes.field_76792_x.getRegistryName().toString(), Biomes.field_185429_aa.getRegistryName().toString(), Biomes.field_150581_V.getRegistryName().toString(), Biomes.field_76784_u.getRegistryName().toString(), "boreal_forest", "grassland", "highland", "moor"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("freezing forests", Lists.newArrayList((Object[])new String[]{Biomes.field_150584_S.getRegistryName().toString(), Biomes.field_150579_T.getRegistryName().toString(), Biomes.field_185431_ac.getRegistryName().toString(), "boreal_forest", "coniferous_forest", "fen", "snowy_coniferous_forest"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("all forests", Lists.newArrayList((Object[])new String[]{Biomes.field_76767_f.getRegistryName().toString(), Biomes.field_76785_t.getRegistryName().toString(), Biomes.field_185444_T.getRegistryName().toString(), Biomes.field_150585_R.getRegistryName().toString(), Biomes.field_185430_ab.getRegistryName().toString(), Biomes.field_76768_g.getRegistryName().toString(), Biomes.field_76784_u.getRegistryName().toString(), Biomes.field_150590_f.getRegistryName().toString(), Biomes.field_150578_U.getRegistryName().toString(), Biomes.field_150581_V.getRegistryName().toString(), Biomes.field_185432_ad.getRegistryName().toString(), Biomes.field_185433_ae.getRegistryName().toString(), Biomes.field_150583_P.getRegistryName().toString(), Biomes.field_150582_Q.getRegistryName().toString(), Biomes.field_185448_Z.getRegistryName().toString(), Biomes.field_185429_aa.getRegistryName().toString()}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("mountainous forests", Lists.newArrayList((Object[])new String[]{Biomes.field_150580_W.getRegistryName().toString(), Biomes.field_185434_af.getRegistryName().toString()}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("nether", Lists.newArrayList((Object[])new String[]{"corrupted_sands", "fungi_forest", "phantasmagoric_inferno", "polar_chasm", "visceral_heap", "undergarden"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("magical", Lists.newArrayList((Object[])new String[]{"cherry_blossom_grove", "lavender_field", "mystic_grove", "sacred_springs"}));
                BetterSpawnerConfig.INSTANCE.biomeCategories.put("evil", Lists.newArrayList((Object[])new String[]{"dead_forest", "dead_swamp", "ominous_woods", "wasteland"}));
                if (!file.exists()) {
                    String json = gson.toJson((Object)INSTANCE);
                    PrintWriter pw = new PrintWriter(file);
                    pw.write(json);
                    pw.flush();
                    pw.close();
                } else {
                    Pixelmon.LOGGER.error("Could not parse the BetterSpawnerConfig.json. Check it in a JSON parser. Using default options.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkInterval(String interval) {
        if (interval == null) {
            return true;
        }
        if (BetterSpawnerConfig.INSTANCE.intervalSeconds.get(interval) == -1) {
            return false;
        }
        Long last = intervalTimes.get(interval);
        if (last == null || !BetterSpawnerConfig.INSTANCE.intervalSeconds.containsKey(interval)) {
            return true;
        }
        return last < System.currentTimeMillis();
    }

    public static void consumeInterval(String interval) {
        if (BetterSpawnerConfig.INSTANCE.intervalSeconds.containsKey(interval)) {
            intervalTimes.put(interval, System.currentTimeMillis() + (long)(BetterSpawnerConfig.INSTANCE.intervalSeconds.get(interval) * 1000));
        }
    }

    public static ArrayList<String> getLandBlocks() {
        return BetterSpawnerConfig.INSTANCE.blockCategories.get("land");
    }

    public static ArrayList<String> getWaterBlocks() {
        return BetterSpawnerConfig.INSTANCE.blockCategories.get("water");
    }

    public static ArrayList<String> getLavaBlocks() {
        return BetterSpawnerConfig.INSTANCE.blockCategories.get("lava");
    }

    public static ArrayList<String> getAirBlocks() {
        return BetterSpawnerConfig.INSTANCE.blockCategories.get("air");
    }

    public static ArrayList<String> getSeesSkyExceptionBlocks() {
        return BetterSpawnerConfig.INSTANCE.blockCategories.get("seesSkyException");
    }

    public static ArrayList<String> getBlockCategory(String blockCategory) {
        if (BetterSpawnerConfig.INSTANCE.blockCategories.containsKey(blockCategory)) {
            return BetterSpawnerConfig.INSTANCE.blockCategories.get(blockCategory);
        }
        return new ArrayList<String>();
    }

    public static boolean doesBlockSeeSky(IBlockState state) {
        if (state == null) {
            return false;
        }
        return !state.func_185904_a().func_76230_c() || BetterSpawnerConfig.getAirBlocks().contains(state.func_177230_c().getRegistryName().toString()) || BetterSpawnerConfig.getSeesSkyExceptionBlocks().contains(state.func_177230_c().getRegistryName().toString());
    }
}

