/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.EnumEntityListClassType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.EntityChairMount;
import com.pixelmonmod.pixelmon.entities.EntityLegendFinder;
import com.pixelmonmod.pixelmon.entities.custom.EntityPixelmonPainting;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityEmptyPokeball;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityOccupiedPokeball;
import com.pixelmonmod.pixelmon.entities.projectiles.EntityHook;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.spawning.SpawnRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.EntityId;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@GameRegistry.ObjectHolder(value="pixelmon")
public class PixelmonEntityList {
    public static final EntityEntry NPC_TRAINER = null;
    public static final EntityEntry HALLOWEEN = null;
    public static final EntityEntry NPC_TRADER = null;
    public static final EntityEntry PIXELMON = null;
    public static final EntityEntry STATUE = null;
    public static final EntityEntry NPC_CHATTING = null;
    public static final EntityEntry NPC_RELEARNER = null;
    public static final EntityEntry NPC_TUTOR = null;
    public static final EntityEntry EMPTY_POKEBALL = null;
    public static final EntityEntry HOOK = null;
    public static final EntityEntry CHAIR_MOUNT = null;
    public static final EntityEntry NPC_NURSEJOY = null;
    public static final EntityEntry NPC_SHOPKEEPER = null;
    public static final EntityEntry PAINTING = null;
    public static final EntityEntry OCCUPIED_POKEBALL = null;
    public static final EntityEntry LEGENDARY_FINDER = null;

    static void registerEntities() {
        int entityID = 0;
        ResourceLocation var10000 = new ResourceLocation("pixelmon", "npc_trainer");
        int var3 = entityID + 1;
        EntityRegistry.registerModEntity((ResourceLocation)var10000, NPCTrainer.class, (String)"Trainer", (int)entityID, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_trader"), NPCTrader.class, (String)"Trader", (int)n, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n2 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "pixelmon"), EntityPixelmon.class, (String)"Pixelmon", (int)n2, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n3 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "statue"), EntityStatue.class, (String)"Statue", (int)n3, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n4 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_chatting"), NPCChatting.class, (String)"ChattingNPC", (int)n4, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n5 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_relearner"), NPCRelearner.class, (String)"Relearner", (int)n5, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n6 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_tutor"), NPCTutor.class, (String)"Tutor", (int)n6, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n7 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "empty_pokeball"), EntityEmptyPokeball.class, (String)"Pokeball", (int)n7, (Object)Pixelmon.instance, (int)80, (int)1, (boolean)true);
        int n8 = ++var3;
        int hookId = n8;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "hook"), EntityHook.class, (String)"Hook", (int)n8, (Object)Pixelmon.instance, (int)75, (int)1, (boolean)true);
        int n9 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "chair_mount"), EntityChairMount.class, (String)"EntityChairMount", (int)n9, (Object)Pixelmon.instance, (int)80, (int)1, (boolean)true);
        int n10 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_nursejoy"), NPCNurseJoy.class, (String)"NurseJoy", (int)n10, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n11 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_shopkeeper"), NPCShopkeeper.class, (String)"Shopkeeper", (int)n11, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n12 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "painting"), EntityPixelmonPainting.class, (String)"PixelmonPainting", (int)n12, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n13 = ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "occupied_pokeball"), EntityOccupiedPokeball.class, (String)"OccupiedPokeball", (int)n13, (Object)Pixelmon.instance, (int)80, (int)1, (boolean)true);
        int n14 = ++var3;
        ++var3;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "legend_finder"), EntityLegendFinder.class, (String)"LegendFinder", (int)n14, (Object)Pixelmon.instance, (int)80, (int)1, (boolean)true);
        PixelmonEntityList.remap();
        ModContainer pixelmon = (ModContainer)Loader.instance().getIndexedModList().get("pixelmon");
        EntityRegistry.instance().lookupModSpawn(pixelmon, hookId).setCustomSpawning(null, false);
    }

    public static EntityLiving createEntityByName(String entityName, World world) {
        return PixelmonEntityList.createEntityByName(entityName, world, null);
    }

    public static EntityLiving createEntityByName(String entityName, World world, String biomeID) {
        Object entity = null;
        try {
            EnumEntityListClassType type = null;
            if (EnumPokemon.hasPokemonAnyCase(entityName)) {
                type = EnumEntityListClassType.Pixelmon;
                entityName = EnumPokemon.getFromNameAnyCase((String)entityName).name;
            }
            if (type == EnumEntityListClassType.Pixelmon) {
                entity = new EntityPixelmon(world);
                entity.init(entityName);
            } else if (ServerNPCRegistry.trainers.has(entityName)) {
                BaseTrainer trainer = ServerNPCRegistry.trainers.get(entityName);
                entity = new NPCTrainer(world);
                ((NPCTrainer)((Object)entity)).init(trainer);
            } else {
                try {
                    EnumNPCType npcType = EnumNPCType.valueOf(entityName);
                    if (npcType == EnumNPCType.Trader) {
                        entity = new NPCTrader(world);
                    } else if (npcType == EnumNPCType.Tutor) {
                        entity = new NPCTutor(world);
                    } else if (npcType == EnumNPCType.Shopkeeper) {
                        entity = new NPCShopkeeper(world);
                        ((NPCShopkeeper)((Object)entity)).initWanderingAI();
                        ((NPCShopkeeper)((Object)entity)).initRandom(biomeID);
                    } else {
                        entity = npcType == EnumNPCType.Relearner ? new NPCRelearner(world) : new NPCTrainer(world);
                    }
                    ((EntityNPC)((Object)entity)).init(entityName);
                }
                catch (IllegalArgumentException var6) {
                    entity = new NPCTrainer(world);
                }
            }
        }
        catch (Exception var7) {
            var7.printStackTrace();
        }
        return (EntityLiving)entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound par0NBTTagCompound, World par1World) {
        EntityLiving entity = null;
        try {
            Class<EntityPixelmon> var3 = EntityPixelmon.class;
            entity = (EntityLiving)var3.getConstructor(World.class).newInstance(par1World);
            ((EntityPixelmon)entity).init(par0NBTTagCompound.func_74779_i("Name"));
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        if (entity != null) {
            entity.func_70020_e(par0NBTTagCompound);
        } else if (PixelmonConfig.printErrors) {
            System.out.println("Skipping Entity with id " + par0NBTTagCompound.func_74779_i("id"));
        }
        return entity;
    }

    public static void addSpawns() {
        HashMap<String, String> hashmap = new HashMap<String, String>();
        Pixelmon.LOGGER.info("Registering entity spawns.");
        for (EnumPokemon pokemon : EnumPokemon.values()) {
            SpawnRegistry.getGenerationInfo(hashmap, pokemon.name);
        }
        for (BaseTrainer trainer : ServerNPCRegistry.trainers.getTypes()) {
            int rarity = trainer.rarity;
            if (rarity < 1) continue;
            SpawnRegistry.addNPCSpawn(trainer.name, rarity, EnumNPCType.Trainer);
        }
        if (ServerNPCRegistry.shopkeepers.hasRoaming()) {
            String[] biomeIDs = ServerNPCRegistry.shopkeepers.getRoamingBiomes();
            SpawnRegistry.addNPCSpawn("Shopkeeper", 1, EnumNPCType.Shopkeeper, biomeIDs);
        }
        SpawnRegistry.addNPCSpawn("Tutor", 1, EnumNPCType.Tutor);
        SpawnRegistry.addNPCSpawn("Trader", 1, EnumNPCType.Trader);
        SpawnRegistry.addNPCSpawn("Relearner", 1, EnumNPCType.Relearner);
    }

    private static void remap() {
        Map remap = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityId.class, null, (int)0);
        remap.put("pixelmon.Trainer", "pixelmon:npc_trainer");
        remap.put("pixelmon.Hallwoeen", "pixelmon:halloween");
        remap.put("pixelmon.Trader", "pixelmon:npc_trader");
        remap.put("pixelmon.Pixelmon", "pixelmon:pixelmon");
        remap.put("pixelmon.Statue", "pixelmon:statue");
        remap.put("pixelmon.ChattingNPC", "pixelmon:npc_chatting");
        remap.put("pixelmon.Relearner", "pixelmon:npc_relearner");
        remap.put("pixelmon.Tutor", "pixelmon:npc_tutor");
        remap.put("pixelmon.Pokeball", "pixelmon:empty_pokeball");
        remap.put("pixelmon.Hook", "pixelmon:hook");
        remap.put("pixelmon.EntityChairMount", "pixelmon:chair_mount");
        remap.put("pixelmon.NurseJoy", "pixelmon:npc_nursejoy");
        remap.put("pixelmon.Shopkeeper", "pixelmon:npc_shopkeeper");
        remap.put("pixelmon.PixelmonPainting", "pixelmon:painting");
        remap.put("pixelmon.OccupiedPokeball", "pixelmon:occupied_pokeball");
        remap.put("pixelmon.LegendFinder", "pixelmon:legend_finder");
    }
}

