/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.InteractNPC;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NPCRelearner
extends EntityNPC {
    private static final DataParameter<ItemStack> COST = EntityDataManager.func_187226_a(NPCRelearner.class, (DataSerializer)DataSerializers.field_187196_f);

    public NPCRelearner(World world) {
        super(world);
        this.init(I18n.func_74838_a((String)"pixelmon.npc.relearnername"));
        this.field_70180_af.func_187214_a(COST, (Object)ItemStack.field_190927_a);
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/npcchat1.png";
    }

    @Override
    public String getDisplayText() {
        return I18n.func_74838_a((String)"pixelmon.npc.relearnername");
    }

    public void func_70024_g(double par1, double par3, double par5) {
    }

    public ItemStack getCost() {
        ItemStack cost = (ItemStack)this.field_70180_af.func_187225_a(COST);
        if (cost.func_190926_b() || cost.func_77973_b() instanceof ItemNPCEditor || cost.func_77973_b() == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        return cost;
    }

    public void setCost(ItemStack item) {
        this.field_70180_af.func_187227_b(COST, (Object)item);
    }

    @Override
    public boolean interactWithNPC(EntityPlayer player, EnumHand hand) {
        if (player instanceof EntityPlayerMP) {
            ItemStack cost = this.getCost();
            ItemStack itemstack = player.func_184586_b(hand);
            if (player.field_71075_bZ.field_75098_d) {
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77973_b() instanceof ItemNPCEditor) {
                        this.openRelearnerGui(player);
                    } else if (cost.func_190926_b() || cost.func_77973_b() != itemstack.func_77973_b() || cost.func_77952_i() != itemstack.func_77952_i()) {
                        cost = new ItemStack(itemstack.func_77973_b());
                        cost.func_77964_b(itemstack.func_77952_i());
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, I18n.func_74838_a((String)"pixelmon.npc.relearnersetitem"), cost.func_82833_r(), cost.func_190916_E());
                    } else if (cost.func_190916_E() != cost.func_77976_d()) {
                        cost.func_190917_f(1);
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, I18n.func_74838_a((String)"pixelmon.npc.relearnersetitem"), cost.func_82833_r(), cost.func_190916_E());
                    } else {
                        ChatHandler.sendChat((Entity)player, I18n.func_74838_a((String)"pixelmon.npc.relearnerfull"), new Object[0]);
                    }
                } else if (!cost.func_190926_b()) {
                    cost.func_190918_g(1);
                    if (cost.func_190916_E() <= 0) {
                        cost = ItemStack.field_190927_a;
                        ChatHandler.sendChat((Entity)player, I18n.func_74838_a((String)"pixelmon.npc.relearnernoitem"), new Object[0]);
                        this.setCost(cost);
                    } else {
                        this.setCost(cost);
                        ChatHandler.sendChat((Entity)player, I18n.func_74838_a((String)"pixelmon.npc.relearnersetitem"), cost.func_82833_r(), cost.func_190916_E());
                    }
                }
            } else if (!cost.func_190926_b()) {
                if (!itemstack.func_190926_b() && itemstack.func_77973_b() == cost.func_77973_b() && itemstack.func_190916_E() >= cost.func_190916_E() && itemstack.func_77952_i() == cost.func_77952_i()) {
                    this.openRelearnerGui(player);
                } else {
                    ChatHandler.sendChat((Entity)player, I18n.func_74838_a((String)"pixelmon.npc.relearnercost"), cost.func_82833_r(), cost.func_190916_E());
                }
            } else {
                this.openRelearnerGui(player);
            }
        } else {
            this.field_70714_bg.field_75782_a.clear();
        }
        return true;
    }

    public void openRelearnerGui(EntityPlayer player) {
        Pixelmon.network.sendTo((IMessage)new InteractNPC(this.getId(), EnumNPCType.Relearner), (EntityPlayerMP)player);
        player.openGui((Object)Pixelmon.instance, EnumGui.ChooseRelearnMove.getIndex().intValue(), player.field_70170_p, 0, 0, 0);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        ItemStack cost = this.getCost();
        if (!cost.func_190926_b()) {
            nbt.func_74768_a("Cost", Item.func_150891_b((Item)(!((ItemStack)this.field_70180_af.func_187225_a(COST)).func_190926_b() ? ((ItemStack)this.field_70180_af.func_187225_a(COST)).func_77973_b() : Items.field_190931_a)));
            nbt.func_74768_a("costNum", cost.func_190916_E());
            nbt.func_74768_a("CostDamage", cost.func_77952_i());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("Cost")) {
            ItemStack cost = new ItemStack(Item.func_150899_d((int)nbt.func_74762_e("Cost")), nbt.func_74762_e("costNum"));
            cost.func_77964_b(nbt.func_74762_e("CostDamage"));
            this.setCost(cost);
        }
    }

    @Override
    public void initAI() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPixelmon.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, SharedMonsterAttributes.field_111263_d.func_111110_b()));
                break;
            }
        }
    }

    public boolean func_70104_M() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    protected boolean func_70692_ba() {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }
}

