/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.database.DatabaseTrades;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import java.util.ArrayList;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class NPCTrader
extends EntityNPC {
    private TradePair tradePair;
    public static final DataParameter<Integer> dwLevel = EntityDataManager.func_187226_a(NPCTrader.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> dwShiny = EntityDataManager.func_187226_a(NPCTrader.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<String> dwOffer = EntityDataManager.func_187226_a(NPCTrader.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> dwExchange = EntityDataManager.func_187226_a(NPCTrader.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> dwForm = EntityDataManager.func_187226_a(NPCTrader.class, (DataSerializer)DataSerializers.field_187192_b);

    public NPCTrader(World par1World) {
        super(par1World);
        this.setName(I18n.func_74838_a((String)"pixelmon.npc.tradername"));
        this.field_70180_af.func_187214_a(dwLevel, (Object)10);
        this.field_70180_af.func_187214_a(dwShiny, (Object)false);
        this.field_70180_af.func_187214_a(dwExchange, (Object)"null");
        this.field_70180_af.func_187214_a(dwOffer, (Object)"null");
        this.field_70180_af.func_187214_a(dwForm, (Object)-1);
        this.init("Youngster");
    }

    public void func_110159_bB() {
        if (this.func_110167_bD()) {
            this.func_110160_i(true, true);
        }
    }

    @Override
    public void init(String name) {
        super.init(name);
        if ((Integer)this.field_70180_af.func_187225_a(dwModel) == -1) {
            BaseTrainer trainer = ServerNPCRegistry.trainers.getRandomBase();
            this.setBaseTrainer(trainer);
            if (trainer.textures.size() > 1) {
                this.field_70180_af.func_187227_b(dwTextureIndex, (Object)this.field_70170_p.field_73012_v.nextInt(trainer.textures.size()));
            }
        }
        if (!this.hasTrade()) {
            this.setNewTrade();
        }
        this.tradePair = new TradePair(EnumPokemon.getFromName(this.getOffer()).get(), EnumPokemon.getFromName(this.getExchange()).get());
        if (((String)this.field_70180_af.func_187225_a(EntityNPC.dwNickname)).equalsIgnoreCase("")) {
            this.field_70180_af.func_187227_b(EntityNPC.dwNickname, (Object)ServerNPCRegistry.getRandomName());
        }
    }

    public void setNewTrade() {
        ArrayList<String> pokemon;
        while (!EnumPokemon.hasPokemon((pokemon = DatabaseTrades.getTradeFromDatabase(DatabaseTrades.assignRandomTradeID())).get(0)) || !EnumPokemon.hasPokemon(pokemon.get(1))) {
        }
        this.setExchange(pokemon.get(0));
        String newOffer = pokemon.get(1);
        this.setOffer(newOffer);
        if (Entity3HasStats.hasForms(newOffer)) {
            this.setForm(RandomHelper.getRandomNumberBetween(0, Entity3HasStats.getNumForms(newOffer) - 1));
        }
    }

    public TradePair getTradePair(ArrayList<String> pokemon) {
        return new TradePair(EnumPokemon.getFromName(pokemon.get(0)).get(), EnumPokemon.getFromName(pokemon.get(1)).get());
    }

    public TradePair getTrade() {
        return new TradePair(EnumPokemon.getFromName(this.getOffer()).get(), EnumPokemon.getFromName(this.getExchange()).get());
    }

    @Override
    public void unloadEntity() {
        this.func_70623_bb();
        this.func_70106_y();
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player instanceof EntityPlayerMP) {
            this.updateTradePair();
            ItemStack stack = player.func_184586_b(hand);
            int id = this.getId();
            if (stack != null && stack.func_77973_b() == PixelmonItems.trainerEditor) {
                this.setAIMode(EnumTrainerAI.StandStill);
                this.initAI();
                player.openGui((Object)Pixelmon.instance, EnumGui.NPCTrade.getIndex().intValue(), player.field_70170_p, id, 0, 0);
            } else {
                player.openGui((Object)Pixelmon.instance, EnumGui.NPCTraderGui.getIndex().intValue(), player.field_70170_p, id, 0, 0);
            }
        }
        return true;
    }

    public boolean hasTrade() {
        return !this.getExchange().equals("null") && !this.getOffer().equals("null");
    }

    public void updateTradePair() {
        if (!this.hasTrade()) {
            this.setNewTrade();
        }
        this.tradePair = new TradePair(EnumPokemon.getFromName(this.getOffer()).get(), EnumPokemon.getFromName(this.getExchange()).get());
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.updateTradePair();
        nbt.func_74778_a("Offer", this.getOffer());
        nbt.func_74778_a("Exchange", this.getExchange());
        nbt.func_74777_a("ModelIndex", (short)((Integer)this.field_70180_af.func_187225_a(dwModel)).intValue());
        if (this.getBaseTrainer().textures.size() > 1) {
            nbt.func_74768_a("TextureIndex", ((Integer)this.field_70180_af.func_187225_a(dwTextureIndex)).intValue());
        }
        nbt.func_74768_a("Shiny", this.getIsShiny() ? 1 : 0);
        nbt.func_74768_a("Lvl", this.getLevel());
        nbt.func_74768_a("Variant", this.getForm());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("ModelIndex")) {
            this.field_70180_af.func_187227_b(dwModel, (Object)nbt.func_74765_d("ModelIndex"));
            if (this.getBaseTrainer().textures.size() > 1) {
                this.field_70180_af.func_187227_b(dwTextureIndex, (Object)nbt.func_74762_e("TextureIndex"));
            }
        }
        this.setExchange(nbt.func_74779_i("Exchange"));
        this.setOffer(nbt.func_74779_i("Offer"));
        this.setIsShiny(nbt.func_74762_e("Shiny") == 1);
        this.setLevel(nbt.func_74762_e("Lvl"));
        this.setForm(nbt.func_74762_e("Variant"));
    }

    public void updateTrade(String exchange, String offer, int level, boolean isShiny, int form) {
        this.setExchange(exchange);
        this.setOffer(offer);
        this.setLevel(level);
        this.setIsShiny(isShiny);
        this.setForm(form);
    }

    @Override
    public String getDisplayText() {
        return I18n.func_74838_a((String)"pixelmon.npc.tradername");
    }

    public String getExchange() {
        return (String)this.field_70180_af.func_187225_a(dwExchange);
    }

    public String getOffer() {
        return (String)this.field_70180_af.func_187225_a(dwOffer);
    }

    public void setOffer(String offer) {
        this.field_70180_af.func_187227_b(dwOffer, (Object)offer);
    }

    public void setExchange(String exchange) {
        this.field_70180_af.func_187227_b(dwExchange, (Object)exchange);
    }

    public boolean getIsShiny() {
        return (Boolean)this.field_70180_af.func_187225_a(dwShiny);
    }

    public void setIsShiny(boolean isShiny) {
        this.field_70180_af.func_187227_b(dwShiny, (Object)isShiny);
    }

    public int getForm() {
        return (Integer)this.field_70180_af.func_187225_a(dwForm);
    }

    public void setForm(int form) {
        this.field_70180_af.func_187227_b(dwForm, (Object)form);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(dwLevel);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(dwLevel, (Object)level);
    }

    @Override
    public void initAI() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPixelmon.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, SharedMonsterAttributes.field_111263_d.func_111110_b()));
                break;
            }
        }
    }

    public boolean func_70104_M() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    protected boolean func_70692_ba() {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }

    public class TradePair {
        public EnumPokemon offer;
        public EnumPokemon exchangefor;

        public TradePair(EnumPokemon offer, EnumPokemon exchangefor) {
            this.offer = offer;
            this.exchangefor = exchangefor;
        }
    }
}

