/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.StatuePacketClient;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity4Textures;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStatue
extends Entity3HasStats {
    public static final DataParameter<Float> dwRotation = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<String> dwLabel = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> dwAnimation = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> dwAnimationFrame = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> dwIsFlying = EntityDataManager.func_187226_a(EntityPixelmon.class, (DataSerializer)DataSerializers.field_187198_h);
    private String lastAnimation = null;
    private int lastFrame = -1;

    public EntityStatue(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(dwRotation, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(EntityPixelmon.dwTextures, (Object)-1);
        this.field_70180_af.func_187214_a(EntityPixelmon.dwCustomTexture, (Object)"");
        this.field_70180_af.func_187214_a(dwLabel, (Object)"");
        this.field_70180_af.func_187214_a(dwAnimation, (Object)"");
        this.field_70180_af.func_187214_a(dwAnimationFrame, (Object)0);
        this.field_70180_af.func_187214_a(dwIsFlying, (Object)false);
    }

    @Override
    public void init(String name) {
        if (this.baseStats != null && !name.equals(this.baseStats.pixelmonName)) {
            this.baseStats = null;
        }
        super.init(name);
        if (this.getTextureType() == null) {
            this.setTextureType(EnumStatueTextureType.OriginalTexture);
        }
        this.initAnimation();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("StartingYaw", this.field_70177_z);
        nbt.func_74778_a("statueLabel", this.getLabel());
        nbt.func_74777_a("statueTexture", (short)this.getTextureType().ordinal());
        nbt.func_74778_a("statueAnimation", this.getAnimation());
        nbt.func_74768_a("statueFrame", this.getAnimationFrame());
        nbt.func_74757_a("statueModelType", !this.getIsFlying());
        if (!((String)this.field_70180_af.func_187225_a(EntityPixelmon.dwCustomTexture)).isEmpty()) {
            nbt.func_74778_a("CustomTexture", (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwCustomTexture));
        } else {
            nbt.func_82580_o("CustomTexture");
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("StartingYaw")) {
            this.setRotation(nbt.func_74760_g("StartingYaw"));
        }
        if (nbt.func_74764_b("statueLabel")) {
            this.setLabel(nbt.func_74779_i("statueLabel"));
            this.setTextureType(EnumStatueTextureType.getFromOrdinal(nbt.func_74765_d("statueTexture")));
        }
        if (nbt.func_74764_b("statueAnimation")) {
            this.setAnimation(nbt.func_74779_i("statueAnimation"));
            this.setAnimationFrame(nbt.func_74762_e("statueFrame"));
            this.setIsFlying(!nbt.func_74767_n("statueModelType"));
        }
        this.field_70180_af.func_187227_b(EntityPixelmon.dwCustomTexture, (Object)nbt.func_74779_i("CustomTexture"));
    }

    @Override
    public void func_70071_h_() {
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70177_z = this.field_70759_as = this.getRotation();
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && (this.lastAnimation == null || this.lastFrame == -1 || this.lastFrame != this.getAnimationFrame() || !this.lastAnimation.equals(this.getAnimation())) && this.isSmd()) {
            this.lastAnimation = this.getAnimation();
            this.lastFrame = this.getAnimationFrame();
            ValveStudioModel model = ((PixelmonModelSmd)this.getModel()).theModel;
            model.setAnimation(this.getAnimation());
            SmdAnimation theAnim = model.currentAnimation;
            if (theAnim == null || theAnim.totalFrames == 0) {
                return;
            }
            if (this.getAnimationFrame() >= theAnim.totalFrames) {
                this.setAnimationFrame(theAnim.totalFrames - 1);
            }
            theAnim.setCurrentFrame(this.getAnimationFrame());
            model.animate();
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player instanceof EntityPlayerMP && !stack.func_190926_b() && stack.func_77973_b() == PixelmonItems.chisel) {
            Pixelmon.network.sendTo((IMessage)new StatuePacketClient(this.getPokemonId()), (EntityPlayerMP)player);
            player.openGui((Object)Pixelmon.instance, EnumGui.StatueEditor.getIndex().intValue(), this.field_70170_p, this.func_145782_y(), 0, 0);
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable p_90011_1_) {
        return null;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    public EnumStatueTextureType getTextureType() {
        return EnumStatueTextureType.getFromOrdinal((Integer)this.field_70180_af.func_187225_a(EntityPixelmon.dwTextures));
    }

    public void setTextureType(EnumStatueTextureType type) {
        this.setBoss(type.bossMode);
        this.field_70180_af.func_187227_b(EntityPixelmon.dwTextures, (Object)type.ordinal());
    }

    public String getLabel() {
        return (String)this.field_70180_af.func_187225_a(dwLabel);
    }

    public void setLabel(String label) {
        this.field_70180_af.func_187227_b(dwLabel, (Object)label);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        EnumStatueTextureType type = this.getTextureType();
        if (type == EnumStatueTextureType.Stone) {
            return new ResourceLocation("pixelmon:textures/pokemon/statue.png");
        }
        if (type == EnumStatueTextureType.Gold) {
            return new ResourceLocation("pixelmon:textures/pokemon/gold.png");
        }
        if (type == EnumStatueTextureType.Silver) {
            return new ResourceLocation("pixelmon:textures/pokemon/silver.png");
        }
        if (type == EnumStatueTextureType.Bronze) {
            return new ResourceLocation("pixelmon:textures/pokemon/bronze.png");
        }
        EnumPokemon pokemon = this.getSpecies();
        String specialTexture = this.baseStats.pokemon.getSpecialTexture().toString();
        return Entity4Textures.getTextureFor(pokemon, pokemon.getFormEnum(this.getForm()), this.getGender(), type == EnumStatueTextureType.Special ? specialTexture : (String)this.field_70180_af.func_187225_a(EntityPixelmon.dwCustomTexture), type == EnumStatueTextureType.Shiny);
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    public void setRotation(float rotation) {
        this.field_70180_af.func_187227_b(dwRotation, (Object)Float.valueOf(rotation));
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(dwRotation)).floatValue();
    }

    @Override
    public AnimationType getCurrentAnimation() {
        return AnimationType.getTypeFor(this.getAnimation());
    }

    public String getAnimation() {
        String animationType = (String)this.field_70180_af.func_187225_a(dwAnimation);
        if (animationType == null || animationType.equals("")) {
            animationType = "walk";
            this.setAnimation(animationType);
        }
        return animationType;
    }

    public void setAnimation(String animationName) {
        this.field_70180_af.func_187227_b(dwAnimation, (Object)animationName);
    }

    public int getAnimationFrame() {
        return (Integer)this.field_70180_af.func_187225_a(dwAnimationFrame);
    }

    public void setAnimationFrame(int animationFrame) {
        if (animationFrame < 0) {
            animationFrame = 0;
        }
        this.field_70180_af.func_187227_b(dwAnimationFrame, (Object)animationFrame);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSmd() {
        return this.getModel() instanceof PixelmonModelSmd;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFrameCount() {
        if (this.isSmd()) {
            ValveStudioModel model = ((PixelmonModelSmd)this.getModel()).theModel;
            model.setAnimation(this.getAnimation());
            SmdAnimation theAnim = model.currentAnimation;
            return theAnim == null ? 0 : theAnim.totalFrames;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public String nextAnimation() {
        if (this.isSmd()) {
            String animation = this.getAnimation();
            Iterator<Map.Entry<String, SmdAnimation>> it = ((PixelmonModelSmd)this.getModel()).theModel.anims.entrySet().iterator();
            String first = null;
            boolean takeNext = false;
            while (it.hasNext()) {
                Map.Entry<String, SmdAnimation> entry = it.next();
                String key = entry.getKey();
                if (first == null) {
                    first = key;
                }
                if (takeNext) {
                    return key;
                }
                if (!key.equals(animation)) continue;
                takeNext = true;
            }
            return first;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getAllAnimations() {
        ArrayList<String> animations = new ArrayList<String>();
        if (this.isSmd()) {
            animations.addAll(((PixelmonModelSmd)this.getModel()).theModel.anims.keySet());
        }
        return animations;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase getModel() {
        if (this.getIsFlying() && this.hasFlyingModel()) {
            return PixelmonModelRegistry.getFlyingModel(this.getSpecies(), this.getFormEnum());
        }
        return PixelmonModelRegistry.getModel(this.getSpecies(), this.getFormEnum());
    }

    public boolean getIsFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(dwIsFlying);
    }

    public void setIsFlying(boolean isFlying) {
        this.field_70180_af.func_187227_b(dwIsFlying, (Object)isFlying);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFlyingModel() {
        return PixelmonModelRegistry.hasFlyingModel(this.getSpecies(), this.getSpecies().getFormEnum(this.getForm()));
    }
}

