/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves;

import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Cut
extends ExternalMoveBase {
    ArrayList<EnumFacing[]> checkDirections;

    public Cut() {
        super("cut", "Cut");
    }

    @Override
    public boolean execute(EntityPixelmon user, RayTraceResult target, int moveIndex) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            World world = user.field_70170_p;
            BlockPos pos = target.func_178782_a();
            Block block = world.func_180495_p(pos).func_177230_c();
            if (block != Blocks.field_150364_r && block != Blocks.field_150363_s) {
                return false;
            }
            if (world.func_180495_p(pos).func_177229_b((IProperty)BlockLog.field_176299_a) != BlockLog.EnumAxis.Y) {
                return false;
            }
            if (this.checkDirections == null) {
                this.setCheckDirections();
            }
            List<BlockPos> logs = this.findTreeLogs(world, pos);
            if (user.stats.Attack < 300 && logs.size() > user.stats.Attack / 30 * 5 + 5) {
                ChatHandler.sendChat((Entity)user.func_70902_q(), "externalMove.Cut.fail", user.getNickname());
                return false;
            }
            for (BlockPos log : logs) {
                IBlockState state = world.func_180495_p(log);
                if (!((EntityPlayerMP)user.func_70902_q()).field_71134_c.func_180237_b(log)) continue;
                block.func_176226_b(world, log, state, 2);
            }
            return true;
        }
        return false;
    }

    private List<BlockPos> findTreeLogs(World world, BlockPos pos) {
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> newLogs = new ArrayList<BlockPos>();
        newLogs.add(pos);
        while (!newLogs.isEmpty()) {
            this.addAdjacentLogs(world, (BlockPos)newLogs.get(0), newLogs, logs);
            logs.add((BlockPos)newLogs.get(0));
            newLogs.remove(0);
        }
        return logs;
    }

    private void addAdjacentLogs(World world, BlockPos pos, List<BlockPos> newLogs, List<BlockPos> logs) {
        for (EnumFacing[] facings : this.checkDirections) {
            BlockPos loc = pos;
            for (EnumFacing f : facings) {
                loc = loc.func_177972_a(f);
            }
            Block block = world.func_180495_p(loc).func_177230_c();
            if (block != Blocks.field_150364_r && block != Blocks.field_150363_s || this.hasLog(logs, loc) || this.hasLog(newLogs, loc)) continue;
            newLogs.add(loc);
        }
    }

    private boolean hasLog(List<BlockPos> logs, BlockPos loc) {
        for (BlockPos log : logs) {
            if (!log.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCooldown(EntityPixelmon user) {
        return 800 - (int)((double)user.stats.Speed * 1.5);
    }

    @Override
    public int getCooldown(PixelmonData user) {
        return 800 - (int)((double)user.Speed * 1.5);
    }

    @Override
    public boolean isDestructive() {
        return true;
    }

    private void setCheckDirections() {
        this.checkDirections = new ArrayList();
        this.checkDirections.add(new EnumFacing[]{EnumFacing.NORTH});
        this.checkDirections.add(new EnumFacing[]{EnumFacing.SOUTH});
        this.checkDirections.add(new EnumFacing[]{EnumFacing.EAST});
        this.checkDirections.add(new EnumFacing[]{EnumFacing.WEST});
        this.checkDirections.add(new EnumFacing[]{EnumFacing.UP});
        this.checkDirections.add(new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH});
        this.checkDirections.add(new EnumFacing[]{EnumFacing.UP, EnumFacing.SOUTH});
        this.checkDirections.add(new EnumFacing[]{EnumFacing.UP, EnumFacing.EAST});
        this.checkDirections.add(new EnumFacing[]{EnumFacing.UP, EnumFacing.WEST});
    }
}

