/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.pokemon.MovesetEvent;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.database.DatabaseMoves;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity6CanBattle;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.EntityLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.NBTLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.RandomAccess;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Moveset
extends AbstractList<Attack>
implements RandomAccess,
Cloneable {
    public PokemonLink pokemonLink = null;
    public Attack[] attacks = new Attack[4];

    public Moveset() {
        this.pokemonLink = null;
    }

    public Moveset(PokemonLink owner) {
        this.pokemonLink = owner;
    }

    public Moveset(Entity6CanBattle owner) {
        this.pokemonLink = owner.getPixelmonWrapper() != null ? owner.getPixelmonWrapper().getInnerLink() : new EntityLink(owner);
    }

    public Moveset(NBTTagCompound owner) {
        this.pokemonLink = new NBTLink(owner);
    }

    public Moveset(Attack[] attacks) {
        this.attacks = attacks;
    }

    public Moveset(int index, Attack a) {
        this.attacks[0] = a;
    }

    @Override
    public Attack get(int index) {
        if (index < 0 || index > 3) {
            return null;
        }
        return this.attacks[index];
    }

    @Override
    public boolean add(Attack a) {
        if (this.size() >= 4) {
            return false;
        }
        this.set(this.size(), a);
        return true;
    }

    @Override
    public Attack set(int index, Attack a) {
        Attack previousAttack = this.attacks[index];
        this.attacks[index] = a;
        if (this.pokemonLink == null || this.pokemonLink.getPlayerOwner() == null) {
            return previousAttack;
        }
        if (previousAttack != null) {
            Pixelmon.EVENT_BUS.post((Event)new MovesetEvent.ForgotMoveEvent(this.pokemonLink, this, previousAttack));
        }
        if (a != null) {
            Pixelmon.EVENT_BUS.post((Event)new MovesetEvent.LearntMoveEvent(this.pokemonLink, this, previousAttack, a));
        }
        return previousAttack;
    }

    public void swap(int index, int index2) {
        Attack a = this.attacks[index];
        this.attacks[index] = this.attacks[index2];
        this.attacks[index2] = a;
    }

    @Override
    public Attack remove(int index) {
        Attack a = this.get(index);
        int oldSize = this.size();
        for (int i = index + 1; i < this.size(); ++i) {
            this.set(i - 1, this.get(i));
        }
        this.set(oldSize - 1, null);
        return a;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Attack)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.attacks[i] != o) continue;
            this.set(i, null);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.attacks[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isAt(int index, Attack a) {
        if (this.isEmpty()) {
            return false;
        }
        if (!this.contains(a)) {
            return false;
        }
        return this.attacks[index] == a;
    }

    @Override
    public boolean contains(Object o) {
        if (this.isEmpty()) {
            return false;
        }
        if (o instanceof Attack) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.attacks[i].equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.attacks = new Attack[4];
    }

    public void writeToNBT(NBTTagCompound var1) {
        this.writeToNBT(var1, true);
    }

    public void writeToNBT(NBTTagCompound var1, boolean changePP) {
        int size = this.size();
        var1.func_74768_a("PixelmonNumberMoves", size);
        for (int i = 0; i < size; ++i) {
            Attack attack = this.get(i);
            if (attack != null) {
                String moveKey = "PixelmonMoveID" + i;
                boolean savePP = true;
                if (!changePP && var1.func_74764_b(moveKey)) {
                    savePP = var1.func_74762_e(moveKey) != attack.baseAttack.attackIndex;
                }
                var1.func_74768_a(moveKey, attack.baseAttack.attackIndex);
                if (!savePP) continue;
                var1.func_74768_a("PixelmonMovePP" + i, attack.pp);
                var1.func_74768_a("PixelmonMovePPBase" + i, attack.ppBase);
                var1.func_74768_a("PixelmonMovePPMax" + i, attack.baseAttack.ppMax);
                continue;
            }
            if (size >= 4) continue;
            ++size;
        }
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.clear();
        int numMoves = var1.func_74762_e("PixelmonNumberMoves");
        for (int i = 0; i < numMoves; ++i) {
            Attack a = !var1.func_74764_b("PixelmonMoveID" + i) && var1.func_74764_b("PixelmonMoveName" + i) ? DatabaseMoves.getAttack(var1.func_74779_i("PixelmonMoveName" + i)) : DatabaseMoves.getAttack(var1.func_74762_e("PixelmonMoveID" + i));
            if (a == null) continue;
            if (var1.func_74764_b("PixelmonMovePP" + i)) {
                a.pp = var1.func_74762_e("PixelmonMovePP" + i);
            }
            if (var1.func_74764_b("PixelmonMovePPBase" + i)) {
                a.ppBase = var1.func_74762_e("PixelmonMovePPBase" + i);
            }
            this.attacks[i] = a;
        }
    }

    public boolean hasAttack(Attack a) {
        for (Attack attack : this.attacks) {
            if (attack == null || attack.baseAttack.attackIndex != a.baseAttack.attackIndex) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttack(String ... attackNames) {
        for (Attack attack : this.attacks) {
            if (attack == null || !attack.isAttack(attackNames)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttackCategory(int attackCategory) {
        for (Attack attack : this.attacks) {
            if (attack == null || attack.baseAttack.attackCategory != attackCategory) continue;
            return true;
        }
        return false;
    }

    public boolean hasOffensiveAttackType(EnumType ... types) {
        for (Attack attack : this.attacks) {
            for (EnumType type : types) {
                if (attack == null || attack.baseAttack.attackCategory == 2 || attack.baseAttack.attackType != type) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceWith(ArrayList<Integer> attackIds) {
        this.clear();
        this.addAll(attackIds.stream().map(DatabaseMoves::getAttack).collect(Collectors.toList()));
    }

    public boolean hasFullPP() {
        for (int i = 0; i < this.size(); ++i) {
            Attack a = this.get(i);
            if (a.pp >= a.ppBase) continue;
            return false;
        }
        return true;
    }

    public Moveset copy() {
        Attack[] attacks = new Attack[this.attacks.length];
        for (int i = 0; i < this.attacks.length; ++i) {
            if (this.attacks[i] == null) continue;
            attacks[i] = this.attacks[i].copy();
        }
        return new Moveset(attacks);
    }

    public void getNBTTags(HashMap<String, Class> tags) {
        tags.put("PixelmonNumberMoves", Integer.class);
        for (int i = 0; i < 4; ++i) {
            tags.put("PixelmonMoveID" + i, Integer.class);
            tags.put("PixelmonMovePP" + i, Integer.class);
            tags.put("PixelmonMovePPBase" + i, Integer.class);
            tags.put("PixelmonMovePPMax" + i, Integer.class);
        }
    }

    public boolean replaceMove(String oldMove, Attack newMove) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.attacks[i].isAttack(oldMove)) continue;
            this.attacks[i] = newMove;
            return true;
        }
        return false;
    }

    public void healAllPP() {
        for (int i = 0; i < this.size(); ++i) {
            Attack attack = this.attacks[i];
            attack.pp = attack.ppBase;
        }
    }

    public static Moveset loadMoveset(PokemonLink pokemon) {
        return DatabaseMoves.getInitialMoves(pokemon, pokemon.getLevel());
    }
}

