/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.links;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUp;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FriendShip;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WrapperLink
extends PokemonLink {
    private PixelmonWrapper pixelmon;
    private PokemonLink innerLink;

    public WrapperLink(PixelmonWrapper pixelmon) {
        this.pixelmon = pixelmon;
        this.innerLink = pixelmon.getInnerLink();
    }

    @Override
    public BaseStats getBaseStats() {
        return this.pixelmon.getBaseStats();
    }

    @Override
    public Stats getStats() {
        return this.pixelmon.getStats();
    }

    @Override
    public ItemHeld getHeldItem() {
        return this.pixelmon.getHeldItem();
    }

    @Override
    public void setHeldItem(ItemStack item) {
        this.pixelmon.setHeldItem(item);
    }

    @Override
    public int getHealth() {
        return this.pixelmon.getHealth();
    }

    @Override
    public int getMaxHealth() {
        return this.pixelmon.getMaxHealth();
    }

    @Override
    public void setHealth(int health) {
        int currentHealth = this.getHealth();
        if (health > currentHealth) {
            this.pixelmon.healEntityBy(health - currentHealth);
        } else if (health < currentHealth) {
            this.pixelmon.doBattleDamage(this.pixelmon, currentHealth - health, DamageTypeEnum.SELF);
        }
    }

    @Override
    public void setHealthDirect(int health) {
        this.pixelmon.setHealth(health);
    }

    @Override
    public int getLevel() {
        return this.pixelmon.getLevelNum();
    }

    @Override
    public void setLevel(int level) {
        this.pixelmon.setLevelNum(level);
    }

    @Override
    public int getExp() {
        return this.pixelmon.getExp();
    }

    @Override
    public void setExp(int experience) {
        this.pixelmon.setExp(experience);
    }

    @Override
    public FriendShip getFriendship() {
        return this.pixelmon.getFriendship();
    }

    @Override
    public boolean doesLevel() {
        return this.pixelmon.doesLevel();
    }

    @Override
    public EntityPlayerMP getPlayerOwner() {
        return this.pixelmon.getPlayerOwner();
    }

    @Override
    public String getRealNickname() {
        return this.pixelmon.getNickname();
    }

    @Override
    public BattleControllerBase getBattleController() {
        return this.pixelmon.bc;
    }

    @Override
    public Moveset getMoveset() {
        return this.pixelmon.getMoveset();
    }

    @Override
    public int[] getPokemonID() {
        return this.pixelmon.getPokemonID();
    }

    @Override
    public EntityPixelmon getEntity() {
        if (this.pixelmon.pokemon != null) {
            return this.pixelmon.pokemon;
        }
        BattleParticipant participant = this.pixelmon.getParticipant();
        PlayerStorage storage = participant.getStorage();
        if (storage == null) {
            return null;
        }
        return storage.sendOut(this.getPokemonID(), participant.getWorld());
    }

    @Override
    public void setScale(float scale) {
    }

    @Override
    public World getWorld() {
        return this.pixelmon.getParticipant().getWorld();
    }

    @Override
    public Gender getGender() {
        return this.pixelmon.getGender();
    }

    @Override
    public BlockPos getPos() {
        EntityPixelmon entity = this.pixelmon.pokemon;
        if (this.pixelmon.pokemon == null) {
            entity = this.pixelmon.getParticipant().getEntity();
        }
        return entity.func_180425_c();
    }

    @Override
    public Optional<PlayerStorage> getStorage() {
        return Optional.of(this.pixelmon.getParticipant().getStorage());
    }

    @Override
    public void update(EnumUpdateType ... updateTypes) {
        this.pixelmon.update(updateTypes);
    }

    @Override
    public void updateStats() {
        this.pixelmon.getStats().setLevelStats(this.pixelmon.getNature(), this.pixelmon.getBaseStats(), this.pixelmon.getLevelNum());
        this.pixelmon.update(EnumUpdateType.HP, EnumUpdateType.Stats);
    }

    @Override
    public void updateLevelUp(PixelmonStatsData stats) {
        EntityPlayerMP owner = this.pixelmon.getPlayerOwner();
        if (owner != null) {
            PixelmonStatsData stats2 = PixelmonStatsData.createPacket(this);
            Pixelmon.network.sendTo((IMessage)new LevelUp(this.pixelmon.nbt, this.getLevel(), stats, stats2), owner);
            this.pixelmon.updateHPIncrease();
        }
    }

    @Override
    public void sendMessage(String langKey, Object ... data) {
        this.pixelmon.bc.sendToAll(langKey, data);
    }

    @Override
    public String getNickname() {
        return this.pixelmon.getNickname();
    }

    @Override
    public String getOriginalTrainer() {
        return this.pixelmon.getOriginalTrainer();
    }

    @Override
    public String getRealTextureNoCheck(PixelmonWrapper pw) {
        return this.pixelmon.getRealTextureNoCheck();
    }

    @Override
    public boolean removeStatuses(StatusType ... statuses) {
        return this.pixelmon.removeStatuses(statuses);
    }

    @Override
    public EnumNature getNature() {
        return this.pixelmon.getNature();
    }

    @Override
    public int getExpToNextLevel() {
        return this.pixelmon.getLevel().expToNextLevel;
    }

    @Override
    public StatusPersist getPrimaryStatus() {
        return this.pixelmon.getPrimaryStatus();
    }

    @Override
    public AbilityBase getAbility() {
        return this.pixelmon.getAbility();
    }

    @Override
    public List<EnumType> getType() {
        return this.pixelmon.type;
    }

    @Override
    public int getForm() {
        return this.pixelmon.getForm();
    }

    @Override
    public boolean isShiny() {
        return this.innerLink.isShiny();
    }

    @Override
    public boolean isEgg() {
        return false;
    }

    @Override
    public int getEggCycles() {
        return 0;
    }

    @Override
    public EnumGrowth getGrowth() {
        return this.innerLink.getGrowth();
    }

    @Override
    public EnumPokeballs getCaughtBall() {
        return this.innerLink.getCaughtBall();
    }

    @Override
    public int getPartyPosition() {
        return this.pixelmon.getPartyPosition();
    }

    @Override
    public ItemStack getHeldItemStack() {
        return this.innerLink.getHeldItemStack();
    }

    @Override
    public boolean hasOwner() {
        return this.pixelmon.getParticipant().getType() != ParticipantType.WildPokemon;
    }

    @Override
    public EnumBossMode getBossMode() {
        return this.innerLink.getBossMode();
    }

    @Override
    public int getSpecialTexture() {
        return this.innerLink.getSpecialTexture();
    }

    @Override
    public boolean isInRanch() {
        return false;
    }

    @Override
    public int[] getEggMoves() {
        return this.innerLink.getEggMoves();
    }

    @Override
    public Level getLevelContainer() {
        return this.pixelmon.getLevel();
    }

    public PixelmonWrapper getPokemon() {
        return this.pixelmon;
    }

    @Override
    public NBTTagCompound getNBT() {
        return this.innerLink.getNBT();
    }
}

