/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.CheckPokemonEditorAllowed;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditedPlayer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateSinglePokemon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumGui;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemPokemonEditor
extends PixelmonItem {
    public ItemPokemonEditor() {
        super("pokemon_editor");
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        EntityPlayerMP playerMP;
        Optional<PlayerStorage> optstorage;
        if (!world.field_72995_K && player.field_71075_bZ.field_75098_d && hand == EnumHand.MAIN_HAND && ItemPokemonEditor.checkPermission((EntityPlayerMP)player) && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(playerMP = (EntityPlayerMP)player)).isPresent()) {
            PlayerStorage storage = optstorage.get();
            storage.sendUpdatedList();
            storage.recallAllPokemon();
            Pixelmon.network.sendTo((IMessage)new SetEditedPlayer(player.func_110124_au(), player.getDisplayNameString(), null), playerMP);
            player.openGui((Object)Pixelmon.instance, EnumGui.PokemonEditor.ordinal(), world, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityPlayerMP && player.field_71075_bZ.field_75098_d) {
            EntityPlayerMP otherPlayer;
            Optional<PlayerStorage> optstorage;
            if (ItemPokemonEditor.checkPermission((EntityPlayerMP)player) && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(otherPlayer = (EntityPlayerMP)entity)).isPresent()) {
                PlayerStorage storage = optstorage.get();
                if (storage.guiOpened) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.general.playerbusy", new Object[0]);
                    return true;
                }
                Pixelmon.network.sendTo((IMessage)new CheckPokemonEditorAllowed(player.func_110124_au()), otherPlayer);
            }
            return true;
        }
        return false;
    }

    public static void updateEditedPlayer(EntityPlayerMP editingPlayer, UUID editedPlayer) {
        Optional<PlayerStorage> optstorage;
        if (!ItemPokemonEditor.checkPermission(editingPlayer)) {
            return;
        }
        if (!editingPlayer.func_110124_au().equals(editedPlayer) && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorageFromUUID(editingPlayer.func_184102_h(), editedPlayer)).isPresent()) {
            PlayerStorage storage = optstorage.get();
            Pixelmon.network.sendTo((IMessage)new SetEditedPlayer(editedPlayer, storage.convertToData()), editingPlayer);
        }
    }

    public static void updateSinglePokemon(EntityPlayerMP editingPlayer, UUID editedPlayer, int slot) {
        Optional<PlayerStorage> optstorage;
        if (!ItemPokemonEditor.checkPermission(editingPlayer)) {
            return;
        }
        if (!editingPlayer.func_110124_au().equals(editedPlayer) && (optstorage = PixelmonStorage.pokeBallManager.getPlayerStorageFromUUID(editingPlayer.func_184102_h(), editedPlayer)).isPresent()) {
            PlayerStorage storage = optstorage.get();
            NBTTagCompound pokemonNBT = storage.getList()[slot];
            PixelmonData pokemonData = pokemonNBT == null ? null : new PixelmonData(pokemonNBT);
            Pixelmon.network.sendTo((IMessage)new UpdateSinglePokemon(slot, pokemonData), editingPlayer);
        }
    }

    public static boolean checkPermission(EntityPlayerMP editingPlayer) {
        if (PixelmonConfig.allowPokemonEditors && editingPlayer.func_70003_b(4, "pixelmon.pokemoneditor.use")) {
            return true;
        }
        ChatHandler.sendChat((Entity)editingPlayer, "gui.pokemoneditor.notallowedserver", new Object[0]);
        return false;
    }
}

