/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.sounds;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PixelSounds {
    public static SoundEvent pc;
    public static SoundEvent pokelootObtained;
    public static SoundEvent cameraShutter;
    public static SoundEvent healerActive;
    public static SoundEvent pokeballClose;
    public static SoundEvent pokeballRelease;
    public static SoundEvent pokeballCapture;
    public static SoundEvent pokeballCaptureSuccess;
    public static EnumMap<EnumPokemon, Map<BaseStats.SoundType, SoundEvent>> pixelmonSounds;

    public static void registerSounds(IForgeRegistry<SoundEvent> registry) {
        String prefix = "pixelmon:";
        pc = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PC");
        pokelootObtained = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokelootObtained");
        cameraShutter = PixelSounds.registerSound(registry, prefix + "pixelmon.item.CameraShutter");
        healerActive = PixelSounds.registerSound(registry, prefix + "pixelmon.block.healerActivate");
        pokeballClose = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokeballClose");
        pokeballRelease = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokeballRelease");
        pokeballCapture = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokeballCapture");
        pokeballCaptureSuccess = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokeballCaptureSuccess");
        pixelmonSounds = new EnumMap(EnumPokemon.class);
        PixelSounds.registerCries(registry);
    }

    private static SoundEvent registerSound(IForgeRegistry<SoundEvent> registry, String soundNameIn) {
        ResourceLocation resourcelocation = new ResourceLocation(soundNameIn);
        SoundEvent event = (SoundEvent)new SoundEvent(resourcelocation).setRegistryName(resourcelocation);
        registry.register((IForgeRegistryEntry)event);
        return event;
    }

    private static void registerCries(IForgeRegistry<SoundEvent> registry) {
        String prefix = "pixelmon:pixelmon.mob.";
        InputStream istream = PixelSounds.class.getResourceAsStream("/assets/pixelmon/sounds.json");
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(istream));
        JsonObject json = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        for (EnumPokemon pixelmon : EnumPokemon.values()) {
            SoundEvent event;
            JsonElement ele = json.get("pixelmon.mob." + pixelmon.name.toLowerCase());
            if (ele != null) {
                event = PixelSounds.registerSound(registry, prefix + pixelmon.name.toLowerCase());
                if (!pixelmonSounds.containsKey((Object)pixelmon)) {
                    pixelmonSounds.put(pixelmon, Maps.newEnumMap(BaseStats.SoundType.class));
                }
                pixelmonSounds.get((Object)pixelmon).put(BaseStats.SoundType.Neutral, event);
            }
            if (json.get("pixelmon.mob." + pixelmon.name.toLowerCase() + "F") != null) {
                event = PixelSounds.registerSound(registry, prefix + pixelmon.name.toLowerCase() + "F");
                if (!pixelmonSounds.containsKey((Object)pixelmon)) {
                    pixelmonSounds.put(pixelmon, Maps.newEnumMap(BaseStats.SoundType.class));
                }
                pixelmonSounds.get((Object)pixelmon).put(BaseStats.SoundType.Female, event);
            }
            if (json.get("pixelmon.mob." + pixelmon.name.toLowerCase() + "M") == null) continue;
            event = PixelSounds.registerSound(registry, prefix + pixelmon.name.toLowerCase() + "M");
            if (!pixelmonSounds.containsKey((Object)pixelmon)) {
                pixelmonSounds.put(pixelmon, Maps.newEnumMap(BaseStats.SoundType.class));
            }
            pixelmonSounds.get((Object)pixelmon).put(BaseStats.SoundType.Male, event);
        }
    }

    public static void linkPixelmonSounds() {
        for (EnumPokemon pixelmon : EnumPokemon.values()) {
            Optional<BaseStats> statsOptional;
            if (!pixelmonSounds.containsKey((Object)pixelmon) || !(statsOptional = Entity3HasStats.getBaseStats(pixelmon.name)).isPresent()) continue;
            BaseStats stats = statsOptional.get();
            Map<BaseStats.SoundType, SoundEvent> map = pixelmonSounds.get((Object)pixelmon);
            if (map.containsKey((Object)BaseStats.SoundType.Neutral)) {
                stats.addSound(BaseStats.SoundType.Neutral, map.get((Object)BaseStats.SoundType.Neutral));
            }
            if (map.containsKey((Object)BaseStats.SoundType.Female)) {
                stats.addSound(BaseStats.SoundType.Female, map.get((Object)BaseStats.SoundType.Female));
            }
            if (!map.containsKey((Object)BaseStats.SoundType.Male)) continue;
            stats.addSound(BaseStats.SoundType.Male, map.get((Object)BaseStats.SoundType.Male));
        }
    }
}

