/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.BaseStorage;
import com.pixelmonmod.pixelmon.storage.ComputerBox;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerStorage;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class PlayerComputerStorage
extends BaseStorage {
    public static int boxCount = PixelmonConfig.computerBoxes;
    private ComputerBox[] storageBoxes = new ComputerBox[boxCount];
    public PlayerStorage playerStorage;
    public int lastBoxOpen = 0;

    public PlayerComputerStorage(MinecraftServer server, UUID uuid) {
        super(uuid);
        for (int i = 0; i < boxCount; ++i) {
            this.storageBoxes[i] = new ComputerBox(this, i);
        }
    }

    public PlayerComputerStorage(EntityPlayerMP player) {
        this(player.field_70170_p.func_73046_m(), player.func_110124_au());
        Optional<PlayerStorage> optstorage = PixelmonStorage.pokeBallManager.getPlayerStorage(player);
        if (optstorage.isPresent()) {
            this.playerStorage = optstorage.get();
        }
    }

    public boolean addToComputer(NBTTagCompound nbtTagCompound) {
        for (ComputerBox c : this.storageBoxes) {
            if (!c.hasSpace()) continue;
            c.addToFirstSpace(nbtTagCompound);
            return true;
        }
        return false;
    }

    public void addToComputer(EntityPixelmon p) {
        for (ComputerBox c : this.storageBoxes) {
            if (!c.hasSpace()) continue;
            c.add(p);
            return;
        }
        ChatHandler.sendChat((Entity)p.func_70902_q(), "pixelmon.storage.compfull", new Object[0]);
    }

    public int count() {
        int count = 0;
        for (ComputerBox c : this.storageBoxes) {
            count += c.count();
        }
        return count;
    }

    public void changePokemon(int box, int boxPos, NBTTagCompound n) {
        if (n != null) {
            n.func_74768_a("BoxNumber", box);
            n.func_74768_a("PixelmonOrder", boxPos);
        }
        ComputerBox c = this.storageBoxes[box];
        c.changePokemon(boxPos, n);
    }

    public void addToBox(int originalBox, NBTTagCompound n) {
        ComputerBox c = this.storageBoxes[originalBox];
        if (n != null) {
            n.func_74768_a("BoxNumber", originalBox);
        }
        c.addToFirstSpace(n);
    }

    public ComputerBox getBox(int boxNumber) {
        return this.storageBoxes[boxNumber];
    }

    public ComputerBox getBoxFromPosition(int pos) {
        for (int i = 0; i < boxCount; ++i) {
            if (this.storageBoxes[i].position != pos) continue;
            return this.storageBoxes[i];
        }
        return null;
    }

    public ComputerBox[] getBoxList() {
        return this.storageBoxes;
    }

    public void readFromNBT(NBTTagCompound var1) {
        if (var1.func_74764_b("lastBoxOpen")) {
            this.lastBoxOpen = var1.func_74762_e("lastBoxOpen");
            if (this.lastBoxOpen >= boxCount) {
                this.lastBoxOpen = 0;
            }
        }
        for (int i = 0; i < this.storageBoxes.length; ++i) {
            NBTBase nbtbase;
            if (!var1.func_74764_b("" + i) || !((nbtbase = var1.func_74781_a("" + i)) instanceof NBTTagCompound)) continue;
            NBTTagCompound tag = (NBTTagCompound)nbtbase;
            ComputerBox c = new ComputerBox(this, i);
            c.load(tag);
            this.storageBoxes[i] = c;
        }
    }

    public void writeToNBT(NBTTagCompound n) {
        n.func_74768_a("lastBoxOpen", this.lastBoxOpen);
        for (ComputerBox c : this.storageBoxes) {
            NBTTagCompound cTag = new NBTTagCompound();
            c.save(cTag);
            n.func_74782_a("" + c.position, (NBTBase)cTag);
        }
    }

    public boolean hasChanges() {
        for (ComputerBox c : this.storageBoxes) {
            if (!c.hasChanged) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int[] pokemonID) {
        for (ComputerBox b : this.storageBoxes) {
            if (!b.contains(pokemonID)) continue;
            return true;
        }
        return false;
    }

    public EntityPixelmon getPokemonEntity(int[] pokemonID, World world) {
        for (ComputerBox b : this.storageBoxes) {
            if (!b.contains(pokemonID)) continue;
            return b.getPokemonEntity(pokemonID, world);
        }
        return null;
    }

    public void updatePokemonEntry(EntityPixelmon p) {
        for (ComputerBox b : this.storageBoxes) {
            if (!b.contains(p.getPokemonId())) continue;
            b.updatePokemonEntry(p);
        }
    }

    public NBTTagCompound getPokemonNBT(int[] id) {
        for (ComputerBox b : this.storageBoxes) {
            if (!b.contains(id)) continue;
            return b.getPokemonNBT(id);
        }
        return null;
    }

    public void updatePokemonNBT(int[] id, NBTTagCompound nbt) {
        for (ComputerBox b : this.storageBoxes) {
            if (!b.contains(id)) continue;
            b.updatePokemonNBT(id, nbt);
        }
    }

    public void setChanged(int[] pokemonID) {
        for (ComputerBox b : this.storageBoxes) {
            if (!b.contains(pokemonID)) continue;
            b.hasChanged = true;
        }
    }
}

