/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.google.common.util.concurrent.ListenableFuture;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.EconomyEvent;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonData;
import com.pixelmonmod.pixelmon.comm.PixelmonUpdateData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChooseMoveset;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Add;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Remove;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.Update;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityOccupiedPokeball;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumPokemon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.storage.BaseStorage;
import com.pixelmonmod.pixelmon.storage.EnumPokeballManagerMode;
import com.pixelmonmod.pixelmon.storage.PixelmonStorage;
import com.pixelmonmod.pixelmon.storage.PlayerExtraData;
import com.pixelmonmod.pixelmon.storage.PlayerStats;
import com.pixelmonmod.pixelmon.storage.deepstorage.DeepStorageManager;
import com.pixelmonmod.pixelmon.storage.playerData.ExternalMoves;
import com.pixelmonmod.pixelmon.storage.playerData.MegaData;
import com.pixelmonmod.pixelmon.storage.playerData.PlayerData;
import com.pixelmonmod.pixelmon.storage.playerData.TeleportPosition;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerStorage
extends BaseStorage {
    public NBTTagCompound[] partyPokemon = new NBTTagCompound[6];
    public ExternalMoves moves;
    public TeleportPosition teleportPos = new TeleportPosition();
    private AtomicInteger idCounter;
    private int pokeDollars = 0;
    private static final int carryLimit = 6;
    public NPCTrainer trainer;
    public String userName;
    public EnumPokeballManagerMode mode;
    public Pokedex pokedex;
    public PlayerStats stats;
    public boolean guiOpened = false;
    public boolean battleEnabled = true;
    public boolean starterPicked = false;
    private int ticksTillEncounter;
    public EntityOccupiedPokeball thrownPokeball = null;
    public int id = -1;
    private PlayerExtraData serverData;
    public MegaData megaData = new MegaData(this);
    public PlayerData playerData = new PlayerData();
    private boolean[] isInWorld = new boolean[6];

    public PlayerStorage(EntityPlayerMP player) {
        super(player.func_110124_au());
        this.idCounter = new AtomicInteger(0);
        this.moves = new ExternalMoves(this);
        this.mode = EnumPokeballManagerMode.Player;
        this.userName = player.func_146103_bH().getName();
        this.pokedex = new Pokedex((Entity)player);
        this.stats = new PlayerStats();
        this.serverData = new PlayerExtraData((EntityPlayer)player);
        this.ticksTillEncounter = player.func_70681_au().nextInt(900) + 100;
    }

    public PlayerStorage(MinecraftServer server, UUID uuid) {
        super(uuid);
        this.moves = new ExternalMoves(this);
        this.mode = EnumPokeballManagerMode.Offline;
        this.pokedex = new Pokedex();
        this.stats = new PlayerStats();
        this.idCounter = new AtomicInteger(0);
    }

    public PlayerStorage(NPCTrainer trainer) {
        super(null);
        this.mode = EnumPokeballManagerMode.Trainer;
        this.trainer = trainer;
        this.idCounter = new AtomicInteger(0);
    }

    public int getCurrency() {
        EconomyEvent.GetBalanceEvent getBalanceEvent = new EconomyEvent.GetBalanceEvent(this.getPlayer(), this.pokeDollars);
        Pixelmon.EVENT_BUS.post((Event)getBalanceEvent);
        return getBalanceEvent.balance;
    }

    public void addCurrency(int amount) {
        int oldBalance = this.pokeDollars;
        EconomyEvent.PreTransactionEvent preEvent = new EconomyEvent.PreTransactionEvent(this.getPlayer(), EconomyEvent.transactionType.deposit, this.pokeDollars, amount);
        if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            this.setCurrency(this.getCurrency() + preEvent.change);
            Pixelmon.EVENT_BUS.post((Event)new EconomyEvent.PostTransactionEvent(this.getPlayer(), EconomyEvent.transactionType.deposit, oldBalance, this.pokeDollars));
        }
    }

    public void removeCurrency(int amount) {
        int oldBalance = this.pokeDollars;
        EconomyEvent.PreTransactionEvent preEvent = new EconomyEvent.PreTransactionEvent(this.getPlayer(), EconomyEvent.transactionType.withdraw, this.pokeDollars, amount);
        if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            this.setCurrency(this.getCurrency() - preEvent.change);
            Pixelmon.EVENT_BUS.post((Event)new EconomyEvent.PostTransactionEvent(this.getPlayer(), EconomyEvent.transactionType.withdraw, oldBalance, this.pokeDollars));
        }
    }

    public void setCurrency(int amount) {
        if (this.pokeDollars != amount) {
            this.pokeDollars = amount;
            if (this.pokeDollars > 999999) {
                this.pokeDollars = 999999;
            } else if (this.pokeDollars < 0) {
                this.pokeDollars = 0;
            }
            if (this.getPlayer() != null) {
                Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(this.pokeDollars), this.getPlayer());
            }
        }
    }

    public boolean hasSpace() {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt != null) continue;
            return true;
        }
        return false;
    }

    public int getNextOpen() {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] != null) continue;
            return i;
        }
        return 0;
    }

    public void setPokemon(NBTTagCompound[] pokemon) {
        this.partyPokemon = pokemon;
    }

    public void addToParty(EntityPixelmon p) {
        this.addToParty(p, this.getNextOpen(), true);
    }

    public void addToParty(EntityPixelmon p, int slot) {
        this.addToParty(p, slot, false);
    }

    private void addToParty(EntityPixelmon p, int slot, boolean checkFull) {
        this.addToStorage(p, slot, checkFull, false);
    }

    public void addToPC(EntityPixelmon p) {
        this.addToStorage(p, 0, false, true);
    }

    private void addToStorage(EntityPixelmon p, int slot, boolean checkFull, boolean forcePC) {
        if (this.mode == EnumPokeballManagerMode.Player && this.pokedex != null && !p.isEgg) {
            this.pokedex.set(Pokedex.nameToID(p.getPokemonName()), EnumPokedexRegisterStatus.caught);
            this.pokedex.sendToPlayer((EntityPlayerMP)this.pokedex.owner);
        }
        if (p.getMoveset().isEmpty()) {
            p.loadMoveset();
        }
        p.setBoss(EnumBossMode.NotBoss);
        if (p.caughtBall == null) {
            p.caughtBall = EnumPokeballs.PokeBall;
        }
        if (this.mode == EnumPokeballManagerMode.Player) {
            p.func_184754_b(this.getPlayerID());
        } else if (this.mode == EnumPokeballManagerMode.Trainer) {
            p.setTrainer(this.trainer);
        }
        if (this.getPlayer() == null || p.getPokemonId()[0] != this.getPlayerMost()) {
            int[] id = this.getNewPokemonID();
            p.setPokemonId(id);
        }
        if (!(forcePC || checkFull && !this.hasSpace())) {
            NBTTagCompound n = new NBTTagCompound();
            p.func_189511_e(n);
            n.func_74778_a("id", "Pixelmon");
            n.func_74757_a("IsInBall", true);
            n.func_74757_a("IsShiny", p.getIsShiny());
            if (this.mode == EnumPokeballManagerMode.Player && "".equals(p.originalTrainer)) {
                n.func_74778_a("originalTrainer", this.getPlayer().func_145748_c_().func_150260_c());
            }
            if (this.mode == EnumPokeballManagerMode.Trainer && "".equals(p.originalTrainer)) {
                n.func_74778_a("originalTrainer", this.trainer.func_70005_c_());
            }
            if (p.func_184614_ca() != null) {
                n.func_74782_a("HeldItemStack", (NBTBase)p.func_184614_ca().func_77955_b(new NBTTagCompound()));
            }
            n.func_74768_a("PixelmonOrder", slot);
            this.partyPokemon[slot] = n;
            if (p.func_110143_aJ() > 0.0f) {
                n.func_74757_a("IsFainted", false);
            }
            if (p.type.get(0) != p.baseStats.type1) {
                n.func_74777_a("primaryType", (short)((EnumType)((Object)p.type.get(0))).getIndex());
            }
            EnumType type2 = null;
            if (p.type.size() > 1) {
                type2 = (EnumType)((Object)p.type.get(1));
            }
            if (type2 != null && type2 != p.baseStats.type2) {
                n.func_74777_a("secondaryType", (short)type2.getIndex());
            } else {
                n.func_74777_a("secondaryType", (short)-1);
            }
            if (this.mode == EnumPokeballManagerMode.Player) {
                Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(n)), this.getPlayer());
                EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getPokeballList());
            }
        } else {
            if (!forcePC) {
                ChatHandler.sendChat((Entity)p.func_70902_q(), "pixelmon.storage.partyfull", p.isEgg ? I18n.func_74838_a((String)"pixelmon.egg.name") : p.getNickname());
            }
            PixelmonStorage.computerManager.getPlayerStorage(this.getPlayer()).addToComputer(p);
        }
    }

    public int[] getNewPokemonID() {
        int[] nArray;
        if (this.mode == EnumPokeballManagerMode.Player) {
            return new int[]{this.getPlayerMost(), this.getNextID()};
        }
        if (this.mode == EnumPokeballManagerMode.Trainer) {
            int[] nArray2 = new int[2];
            nArray2[0] = (int)this.trainer.func_110124_au().getLeastSignificantBits();
            nArray = nArray2;
            nArray2[1] = this.getNextID();
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = -1;
            nArray = nArray3;
            nArray3[1] = -1;
        }
        return nArray;
    }

    public int getPlayerMost() {
        return (int)this.getPlayerID().getMostSignificantBits();
    }

    public void retrieve(EntityPixelmon currentPixelmon) {
        for (NBTTagCompound n : this.partyPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, currentPixelmon)) continue;
            currentPixelmon.func_189511_e(n);
            n.func_74757_a("IsInBall", true);
            this.setInWorld(currentPixelmon, false);
        }
    }

    public boolean contains(int[] id) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || nbt.func_74762_e("pixelmonID1") != id[0] || nbt.func_74762_e("pixelmonID2") != id[1]) continue;
            return true;
        }
        return false;
    }

    public EntityPixelmon sendOut(int[] id, World world) {
        for (NBTTagCompound n : this.partyPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, id)) continue;
            return this.sendOut(n, world);
        }
        return null;
    }

    private EntityPixelmon sendOut(NBTTagCompound n, World world) {
        n.func_74776_a("FallDistance", 0.0f);
        n.func_74757_a("IsInBall", false);
        EntityPixelmon e = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(n, world);
        if (this.mode == EnumPokeballManagerMode.Player && !this.isOffline()) {
            EntityPlayerMP playerOwner = this.getPlayer();
            e.func_184754_b(playerOwner.func_110124_au());
            e.playerOwned = true;
            e.field_71093_bK = playerOwner.field_71093_bK;
        } else if (this.mode == EnumPokeballManagerMode.Trainer) {
            e.setTrainer(this.trainer);
            e.field_71093_bK = this.trainer.field_71093_bK;
        }
        e.field_70179_y = 0.0;
        e.field_70181_x = 0.0;
        e.field_70159_w = 0.0;
        e.field_70128_L = false;
        e.setNumBreedingLevels(-1);
        return e;
    }

    public NBTTagCompound getNBT(int[] id) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, id)) continue;
            return nbt;
        }
        return null;
    }

    public NBTTagCompound[] getList() {
        return this.partyPokemon;
    }

    public void replace(EntityPixelmon entityPixelmon, EntityPixelmon entityCapturedPixelmon) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, entityPixelmon)) continue;
            entityCapturedPixelmon.setPokemonId(entityPixelmon.getPokemonId());
            entityCapturedPixelmon.func_189511_e(nbt);
            nbt.func_74778_a("id", entityCapturedPixelmon.getPokemonName());
            if (this.mode != EnumPokeballManagerMode.Player || this.isOffline()) continue;
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(nbt)), this.getPlayer());
            EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getPokeballList());
        }
    }

    public void changePokemon(int pos, NBTTagCompound n) {
        if (pos >= this.partyPokemon.length) {
            pos = this.partyPokemon.length - 1;
        }
        if (n != null) {
            n.func_74768_a("PixelmonOrder", pos);
        }
        this.partyPokemon[pos] = n;
        if (this.mode == EnumPokeballManagerMode.Player && !this.isOffline()) {
            EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getPokeballList());
        }
    }

    public void changePokemonAndAssignID(int pos, NBTTagCompound n) {
        int[] id = this.getNewPokemonID();
        if (this.partyPokemon[pos] != null) {
            int[] idpixel;
            Optional<EntityPixelmon> p;
            if (n == null && (p = this.getAlreadyExists(idpixel = PixelmonMethods.getID(this.partyPokemon[pos]), this.getPlayer().field_70170_p)).isPresent()) {
                EntityPixelmon pixelmon = p.get();
                this.retrieve(pixelmon);
                this.updateNBT(pixelmon);
                pixelmon.isInBall = true;
                pixelmon.unloadEntity();
            }
            if (this.mode == EnumPokeballManagerMode.Player && !this.isOffline()) {
                Pixelmon.network.sendTo((IMessage)new Remove(PixelmonMethods.getID(this.partyPokemon[pos])), this.getPlayer());
                EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getPokeballList());
            }
        }
        if (n != null) {
            n.func_74768_a("pixelmonID1", id[0]);
            n.func_74768_a("pixelmonID2", id[1]);
        }
        this.changePokemon(pos, n);
        if (this.mode == EnumPokeballManagerMode.Player && n != null && !this.isOffline()) {
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(n)), this.getPlayer());
            EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getPokeballList());
        }
    }

    public void addToFirstEmptySpace(NBTTagCompound n) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] != null) continue;
            if (n != null) {
                n.func_74768_a("PixelmonOrder", i);
                if (this.mode == EnumPokeballManagerMode.Player && !this.isOffline()) {
                    Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(n)), this.getPlayer());
                }
            }
            this.partyPokemon[i] = n;
            if (this.mode == EnumPokeballManagerMode.Player && !this.isOffline()) {
                EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getPokeballList());
            }
            return;
        }
    }

    public int[] getPokeballList() {
        int[] balls = new int[6];
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] != null) {
                if (this.partyPokemon[i].func_74767_n("isEgg")) {
                    balls[i] = -1;
                    continue;
                }
                balls[i] = this.partyPokemon[i].func_74762_e("CaughtBall");
                continue;
            }
            balls[i] = -1;
        }
        return balls;
    }

    public int count() {
        int count = 0;
        for (NBTTagCompound aPartyPokemon : this.partyPokemon) {
            if (aPartyPokemon == null) continue;
            ++count;
        }
        return count;
    }

    public int countTeam() {
        int c = 0;
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || nbt.func_74767_n("isEgg")) continue;
            ++c;
        }
        return c;
    }

    public List<NBTTagCompound> getTeam() {
        ArrayList<NBTTagCompound> team = new ArrayList<NBTTagCompound>();
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || nbt.func_74767_n("isEgg")) continue;
            team.add(nbt);
        }
        return team;
    }

    public List<NBTTagCompound> getTeamIncludeEgg() {
        ArrayList<NBTTagCompound> team = new ArrayList<NBTTagCompound>();
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null) continue;
            team.add(nbt);
        }
        return team;
    }

    public int countAblePokemon() {
        int c = 0;
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || nbt.func_74767_n("IsFainted") || nbt.func_74767_n("isEgg") || !(nbt.func_74760_g("Health") > 0.0f)) continue;
            ++c;
        }
        return c;
    }

    public boolean isIn(EntityPixelmon entityPixelmon) {
        return this.contains(entityPixelmon.getPokemonId());
    }

    public int getHighestLevel() {
        int lvl = -1;
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null) continue;
            lvl = Math.max(lvl, nbt.func_74762_e("Level"));
        }
        return lvl;
    }

    public boolean hasSentOut(int[] pixelmonID) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, pixelmonID) || nbt.func_74767_n("IsInBall")) continue;
            return true;
        }
        return false;
    }

    public boolean isFainted(int[] id) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, id)) continue;
            return PlayerStorage.isFainted(nbt);
        }
        return false;
    }

    public static boolean isFainted(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        return nbt.func_74767_n("IsFainted") || nbt.func_74760_g("Health") <= 0.0f;
    }

    public static boolean canBattle(NBTTagCompound nbt) {
        return nbt != null && !PlayerStorage.isFainted(nbt) && !nbt.func_74767_n("isEgg");
    }

    public boolean hasPrimaryStatus(NBTTagCompound nbt) {
        return nbt.func_74764_b("Status");
    }

    public boolean isEgg(int[] id) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, id) || !nbt.func_74767_n("isEgg")) continue;
            return true;
        }
        return false;
    }

    public void updateNBT(EntityPixelmon pixelmon) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, pixelmon)) continue;
            pixelmon.func_189511_e(nbt);
            nbt.func_74778_a("id", pixelmon.getPokemonName());
            if (this.moves != null) {
                this.moves.refresh(nbt);
            }
            if (pixelmon.func_110143_aJ() <= 0.0f) {
                nbt.func_74757_a("IsFainted", true);
            }
            if (this.mode != EnumPokeballManagerMode.Player || this.isOffline()) continue;
            EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getPokeballList());
        }
    }

    public void updateClient(NBTTagCompound nbt, EnumUpdateType ... types) {
        this.updateClient(nbt, false, types);
    }

    public void updateClient(NBTTagCompound nbt, boolean inBattle, EnumUpdateType ... types) {
        if (this.mode == EnumPokeballManagerMode.Player && !this.isOffline()) {
            Pixelmon.network.sendTo((IMessage)new Update(new PixelmonUpdateData(nbt, types)), this.getPlayer());
        }
    }

    public void update(EntityPixelmon pixelmon, EnumUpdateType type) {
        this.updateAndSendToClient(pixelmon, type);
    }

    public void updateAndSendToClient(EntityPixelmon pixelmon, EnumUpdateType ... types) {
        this.updateNBT(pixelmon);
        if (this.mode == EnumPokeballManagerMode.Player && !this.isOffline()) {
            Pixelmon.network.sendTo((IMessage)new Update(new PixelmonUpdateData(pixelmon, types)), this.getPlayer());
        }
    }

    public void updateClient(PokemonLink pixelmon, boolean inBattle, EnumUpdateType ... types) {
        if (this.mode == EnumPokeballManagerMode.Player && !this.isOffline()) {
            Pixelmon.network.sendTo((IMessage)new Update(new PixelmonUpdateData(pixelmon, types, inBattle)), this.getPlayer());
        }
    }

    public void sendUpdatedList() {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || this.mode != EnumPokeballManagerMode.Player || this.isOffline()) continue;
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(nbt)), this.getPlayer());
        }
    }

    public int[] getIDFromPosition(int pos) {
        for (NBTTagCompound n : this.partyPokemon) {
            if (n == null || n.func_74762_e("PixelmonOrder") != pos) continue;
            return PixelmonMethods.getID(n);
        }
        return new int[]{-1, -1};
    }

    public boolean entityAlreadyExists(int[] id, World world) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityPixelmon) || !PixelmonMethods.isIDSame((EntityPixelmon)entity, id)) continue;
            return true;
        }
        return false;
    }

    public boolean entityAlreadyExists(EntityPixelmon pixelmon) {
        for (int i = 0; i < pixelmon.field_70170_p.field_72996_f.size(); ++i) {
            Entity entity = (Entity)pixelmon.field_70170_p.field_72996_f.get(i);
            if (!(entity instanceof EntityPixelmon) || !PixelmonMethods.isIDSame((EntityPixelmon)entity, pixelmon)) continue;
            return true;
        }
        return false;
    }

    public Optional<EntityPixelmon> getAlreadyExists(int[] id, World world) {
        Callable<Optional> callable = () -> {
            if (id != null && id[0] != -1) {
                for (int i = 0; i < world.field_72996_f.size(); ++i) {
                    EntityPixelmon entityPixelmon;
                    Entity entity = (Entity)world.field_72996_f.get(i);
                    if (!(entity instanceof EntityPixelmon) || !PixelmonMethods.isIDSame((entityPixelmon = (EntityPixelmon)entity).getPokemonId(), id)) continue;
                    return Optional.of(entityPixelmon);
                }
                return Optional.empty();
            }
            return Optional.empty();
        };
        ListenableFuture listenableFuture = world.func_73046_m().func_175586_a(callable);
        try {
            return (Optional)listenableFuture.get();
        }
        catch (Exception var6) {
            var6.printStackTrace();
            Pixelmon.LOGGER.info("Something went very bad.");
            return Optional.empty();
        }
    }

    public EntityPixelmon getPokemon(int[] id, World world) {
        Optional<EntityPixelmon> pixelmonOptional = this.getAlreadyExists(id, world);
        return pixelmonOptional.isPresent() ? pixelmonOptional.get() : this.sendOut(id, world);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.playerData.writeToNBT(nbt);
        this.teleportPos.writeToNBT(nbt);
        if (this.serverData != null) {
            this.serverData.writeToNBT(nbt);
        }
        nbt.func_74768_a("pixelDollars", this.pokeDollars);
        nbt.func_74768_a("idcounter", this.idCounter.get());
        nbt.func_74757_a("starterPicked", this.starterPicked);
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            Optional<EntityPixelmon> pixelmon;
            int[] id;
            NBTTagCompound e = this.partyPokemon[i];
            if (e == null) continue;
            if ((this.trainer != null || this.getPlayer() != null) && this.isInWorld(id = new int[]{e.func_74762_e("pixelmonID1"), e.func_74762_e("pixelmonID2")}) && (pixelmon = this.getAlreadyExists(id, this.getPlayer() != null ? this.getPlayer().field_70170_p : this.trainer.field_70170_p)).isPresent()) {
                this.updateNBT(pixelmon.get());
            }
            e.func_82580_o("HeldItemName");
            e.func_74768_a("PixelmonOrder", i);
            nbt.func_74782_a("party" + i, (NBTBase)e);
        }
        if (this.pokedex != null) {
            this.pokedex.writeToNBT(nbt);
        }
        if (this.stats != null) {
            this.stats.writeToNBT(nbt);
        }
        this.megaData.writeToNBT(nbt);
        nbt.func_74768_a("TicksTillNextEncounter", this.ticksTillEncounter);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.playerData.readFromNBT(nbt);
        this.teleportPos.readFromNBT(nbt);
        if (this.serverData != null) {
            this.serverData.readFromNBT(nbt);
        }
        this.pokeDollars = nbt.func_74762_e("pixelDollars");
        if (nbt.func_74764_b("idcounter")) {
            this.idCounter.set(nbt.func_74762_e("idcounter"));
        }
        if (nbt.func_74764_b("starterPicked")) {
            this.starterPicked = nbt.func_74767_n("starterPicked");
        }
        ArrayList<NBTTagCompound> unaddedPokemon = new ArrayList<NBTTagCompound>();
        for (int i = 0; i < 6; ++i) {
            NBTBase nbtbase;
            if (!nbt.func_74764_b("party" + i) || !((nbtbase = nbt.func_74781_a("party" + i)) instanceof NBTTagCompound)) continue;
            NBTTagCompound pokemonData = (NBTTagCompound)nbtbase;
            if (!pokemonData.func_74764_b("pixelmonID1")) {
                int[] id = this.getNewPokemonID();
                pokemonData.func_74768_a("pixelmonID1", id[0]);
                pokemonData.func_74768_a("pixelmonID2", id[1]);
                pokemonData.func_82580_o("pixelmonID");
            }
            if (pokemonData.func_74764_b("HeldItemName")) {
                pokemonData.func_74782_a("HeldItemStack", (NBTBase)new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(pokemonData.func_74779_i("HeldItemName"))), 1).func_77955_b(new NBTTagCompound()));
            }
            if (!EnumPokemon.hasPokemonAnyCase(pokemonData.func_74779_i("Name"))) {
                unaddedPokemon.add(pokemonData);
                continue;
            }
            this.partyPokemon[pokemonData.func_74762_e((String)"PixelmonOrder")] = pokemonData;
            if (this.mode != EnumPokeballManagerMode.Player || this.isOffline()) continue;
            Pixelmon.network.sendTo((IMessage)new Add(new PixelmonData(pokemonData)), this.getPlayer());
            EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getPokeballList());
        }
        if (!unaddedPokemon.isEmpty()) {
            DeepStorageManager.bury(this.getPlayerID(), unaddedPokemon, true);
        }
        if (this.pokedex != null) {
            this.pokedex.readFromNBT(nbt);
        }
        if (this.stats != null) {
            this.stats.readFromNBT(nbt);
        }
        this.megaData.readFromNBT(nbt);
        if (this.getPlayer() != null) {
            Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(this.pokeDollars), this.getPlayer());
        }
    }

    private int getNextID() {
        return this.idCounter.getAndIncrement();
    }

    public EntityPixelmon getFirstAblePokemon(World world) {
        for (int i = 0; i < 6; ++i) {
            int[] id = this.getIDFromPosition(i);
            if (id[0] == -1 || this.isFainted(id) || this.isEgg(id) || this.trainer != null && this.isInWorld(id)) continue;
            return this.sendOut(id, world);
        }
        return null;
    }

    public EntityPixelmon getSecondAblePokemon(World world) {
        boolean foundOne = false;
        for (int i = 0; i < 6; ++i) {
            int[] id = this.getIDFromPosition(i);
            if (id[0] == -1 || this.isFainted(id) || this.isEgg(id) || this.trainer != null && this.isInWorld(id)) continue;
            if (foundOne) {
                return this.sendOut(id, world);
            }
            foundOne = true;
        }
        return null;
    }

    public EntityPixelmon getFirstAblePokemonParty(World world) {
        for (int i = 0; i < 6; ++i) {
            int[] id = this.getIDFromPosition(i);
            if (id[0] == -1 || this.isFainted(id) || this.isEgg(id) || this.isInWorld(id)) continue;
            return this.sendOut(id, world);
        }
        return null;
    }

    public int[] getFirstAblePokemonID(World world) {
        for (int i = 0; i < 6; ++i) {
            int[] id = this.getIDFromPosition(i);
            if (id[0] == -1 || this.isFainted(id) || this.isEgg(id)) continue;
            return id;
        }
        return new int[]{-1, -1};
    }

    public ArrayList<int[]> getAllAblePokemonIDs() {
        ArrayList<int[]> ids = new ArrayList<int[]>(6);
        for (int i = 0; i < 6; ++i) {
            int[] id = this.getIDFromPosition(i);
            if (id[0] == -1 || this.isFainted(id) || this.isEgg(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    public EntityPixelmon[] getAmountAblePokemon(World world, int amount) {
        EntityPixelmon[] sentOut = new EntityPixelmon[amount];
        int arrCounter = 0;
        for (int i = 0; i < 6; ++i) {
            int[] id = this.getIDFromPosition(i);
            if (id[0] == -1 || this.isFainted(id) || this.isEgg(id)) continue;
            sentOut[arrCounter] = this.sendOut(id, world);
            if (++arrCounter >= amount) break;
        }
        return sentOut;
    }

    public void healAllPokemon(World world) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            Optional<EntityPixelmon> pix;
            if (nbt == null) continue;
            this.heal(nbt);
            int[] id = PixelmonMethods.getID(nbt);
            if (!this.isInWorld(id) || !(pix = this.getAlreadyExists(id, world)).isPresent()) continue;
            EntityPixelmon pokemon = pix.get();
            pokemon.func_70606_j(pokemon.stats.HP);
            pokemon.getMoveset().healAllPP();
            pokemon.clearStatus();
        }
    }

    public EntityPixelmon sendOutFromPosition(int pos, World world) {
        return this.sendOut(this.partyPokemon[pos], world);
    }

    public void heal(int[] id) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, id)) continue;
            this.heal(nbt);
        }
    }

    private void heal(NBTTagCompound nbt) {
        nbt.func_74776_a("Health", (float)nbt.func_74762_e("StatsHP"));
        nbt.func_74757_a("IsFainted", false);
        int numMoves = nbt.func_74762_e("PixelmonNumberMoves");
        for (int i = 0; i < numMoves; ++i) {
            nbt.func_74768_a("PixelmonMovePP" + i, nbt.func_74762_e("PixelmonMovePPBase" + i));
        }
        nbt.func_82580_o("Status");
        if (this.mode == EnumPokeballManagerMode.Player) {
            this.updateClient(nbt, EnumUpdateType.Status, EnumUpdateType.HP, EnumUpdateType.Moveset);
        }
    }

    public void recallAllPokemon() {
        for (NBTTagCompound aPartyPokemon : this.partyPokemon) {
            int[] id;
            Optional<EntityPixelmon> p;
            if (aPartyPokemon == null || !(p = this.getAlreadyExists(id = PixelmonMethods.getID(aPartyPokemon), this.getPlayer().field_70170_p)).isPresent()) continue;
            EntityPixelmon pixelmon = p.get();
            this.retrieve(pixelmon);
            this.updateNBT(pixelmon);
            pixelmon.isInBall = true;
            pixelmon.unloadEntity();
        }
    }

    public int getPosition(int[] pokemonID) {
        for (NBTTagCompound n : this.partyPokemon) {
            if (n == null || !PixelmonMethods.isIDSame(n, pokemonID)) continue;
            return n.func_74762_e("PixelmonOrder");
        }
        return -1;
    }

    public int[] getNextPokemonId(int[] pokemonID) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !PixelmonMethods.isIDSame(nbt, pokemonID) || nbt.func_74767_n("IsFainted") || !(nbt.func_74760_g("Health") >= 0.0f)) continue;
            return PixelmonMethods.getID(nbt);
        }
        return new int[]{-1, -1};
    }

    public void setAllToLevel(int level) {
        this.recallAllPokemon();
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null) continue;
            EntityPixelmon p = this.sendOut(PixelmonMethods.getID(nbt), this.getPlayer().field_70170_p);
            p.getLvl().setLevel(level);
            p.getLvl().setExp(0);
            p.update(EnumUpdateType.Stats);
            p.unloadEntity();
        }
    }

    public int[] setAllToTempLevel(int level) {
        int[] oldLevels = new int[this.partyPokemon.length];
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null) continue;
            EntityPixelmon p = this.sendOut(PixelmonMethods.getID(nbt), this.getPlayer().field_70170_p);
            oldLevels[i] = p.getLvl().getLevel();
            if (p.getLvl().getLevel() > level) {
                p.getLvl().setLevel(level);
            }
            p.update(EnumUpdateType.Stats);
            p.unloadEntity();
        }
        return oldLevels;
    }

    public void setAllToLevel(int[] levels) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            NBTTagCompound nbt = this.partyPokemon[i];
            if (nbt == null) continue;
            EntityPixelmon p = this.sendOut(PixelmonMethods.getID(nbt), this.getPlayer().field_70170_p);
            p.getLvl().setLevel(levels[i]);
            p.update(EnumUpdateType.Stats);
            p.unloadEntity();
        }
    }

    public void setAllToLevelAndChooseMoveset(int level) {
        this.setAllToLevel(level);
        ArrayList<NBTTagCompound> pokemonList = new ArrayList<NBTTagCompound>(6);
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null) continue;
            pokemonList.add(nbt);
        }
        ChoosingMovesetData data = new ChoosingMovesetData(this.getPlayer(), pokemonList);
        data.next();
        if (!data.pokemonList.isEmpty()) {
            ChooseMoveset.choosingMoveset.add(data);
        }
    }

    public void setAllToLevelTrainer(int level) {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null) continue;
            EntityPixelmon p = this.sendOut(PixelmonMethods.getID(nbt), this.trainer.field_70170_p);
            p.getLvl().setLevel(level);
            this.updateNBT(p);
            p.unloadEntity();
        }
    }

    public void updateStatsTrainer() {
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null) continue;
            EntityPixelmon p = this.sendOut(PixelmonMethods.getID(nbt), this.trainer.field_70170_p);
            this.updateNBT(p);
            p.unloadEntity();
        }
    }

    public Integer calculateHatchingBonus() {
        String[] hatchingBonusAbilities = new String[]{"MagmaArmor", "MagmaArmour", "FlameBody"};
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || nbt.func_74767_n("isEgg")) continue;
            String ability = nbt.func_74779_i("Ability");
            String[] var7 = hatchingBonusAbilities;
            int var8 = hatchingBonusAbilities.length;
            for (int var9 = 0; var9 < var8; ++var9) {
                String bonusAbility = var7[var9];
                if (!ability.equalsIgnoreCase(bonusAbility)) continue;
                return 2;
            }
        }
        return 1;
    }

    public void checkEggStep() {
        EntityPlayerMP player = this.getPlayer();
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || !nbt.func_74767_n("isEgg")) continue;
            BlockPos position = player.func_180425_c();
            int posX = position.func_177958_n();
            int posZ = position.func_177952_p();
            int changeX = Math.abs(nbt.func_74762_e("lastEggXCoord") - posX);
            int changeZ = Math.abs(nbt.func_74762_e("lastEggZCoord") - posZ);
            if (changeX < 2 && changeZ < 2) continue;
            nbt.func_74768_a("lastEggXCoord", posX);
            nbt.func_74768_a("lastEggZCoord", posZ);
            int numSteps = changeX + changeZ;
            if (numSteps > 20) {
                numSteps = 0;
            }
            nbt.func_74768_a("steps", nbt.func_74762_e("steps") + numSteps);
            if (nbt.func_74762_e("steps") > PixelmonConfig.stepsPerEggCycle) {
                nbt.func_74768_a("eggCycles", nbt.func_74762_e("eggCycles") - this.calculateHatchingBonus());
                if (nbt.func_74762_e("eggCycles") < 0) {
                    nbt.func_74778_a("originalTrainer", player.func_145748_c_().func_150260_c());
                    nbt.func_74757_a("isEgg", false);
                    this.pokedex.set(Pokedex.nameToID(nbt.func_74779_i("Name")), EnumPokedexRegisterStatus.caught);
                    this.pokedex.sendToPlayer(player);
                    String name = Entity1Base.getLocalizedName(nbt.func_74779_i("Name"));
                    String nameLower = name.toLowerCase();
                    String langString = !nameLower.startsWith("a") && !nameLower.startsWith("e") && !nameLower.startsWith("i") && !nameLower.startsWith("o") && !nameLower.startsWith("u") ? "pixelmon.egg.hatching" : "pixelmon.egg.hatchingan";
                    ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.GREEN, langString, name);
                    this.sendUpdatedList();
                } else {
                    nbt.func_74768_a("steps", 0);
                }
            }
            if (this.mode != EnumPokeballManagerMode.Player) continue;
            this.updateClient(nbt, EnumUpdateType.Egg);
            EntityPlayerExtension.updatePlayerPokeballs(player, this.getPokeballList());
        }
    }

    public static LinkedHashMap<String, Class> getNBTTags() {
        LinkedHashMap<String, Class> tags = new LinkedHashMap<String, Class>(35);
        PlayerData.getNBTTags(tags);
        TeleportPosition.getNBTTags(tags);
        tags.put("pixelDollars", Integer.class);
        tags.put("idcounter", Integer.class);
        tags.put("starterPicked", Boolean.class);
        Pokedex.getNBTTags(tags);
        PlayerStats.getNBTTags(tags);
        tags.put("TicksTillNextEncounter", Integer.class);
        MegaData.getNBTTags(tags);
        return tags;
    }

    public String getDisplayName() {
        return this.getPlayer().func_145748_c_().func_150260_c();
    }

    public PlayerExtraData getExtraData() {
        return this.serverData;
    }

    public int getAveragePartyLevel() {
        int c = 0;
        int levelSum = 0;
        for (NBTTagCompound nbt : this.partyPokemon) {
            if (nbt == null || nbt.func_74767_n("isEgg")) continue;
            ++c;
            levelSum += nbt.func_74762_e("Level");
        }
        return (int)((float)levelSum / (float)c);
    }

    public int[] getRandomPartyPokemon(ArrayList<PixelmonWrapper> inBattle) {
        ArrayList<NBTTagCompound> array = new ArrayList<NBTTagCompound>();
        NBTTagCompound[] nbtList = this.getList();
        for (int i = 0; i < nbtList.length; ++i) {
            NBTTagCompound nbt = nbtList[i];
            if (nbt == null) continue;
            boolean isInBattle = false;
            for (PixelmonWrapper pw : inBattle) {
                if (!PixelmonMethods.isIDSame(nbt, pw.getPokemonID())) continue;
                isInBattle = true;
                break;
            }
            if (isInBattle || nbt.func_74767_n("IsFainted") || !(nbt.func_74760_g("Health") >= 0.0f) || nbt.func_74767_n("isEgg")) continue;
            array.add(nbt);
        }
        if (array.isEmpty()) {
            return null;
        }
        NBTTagCompound nbt = (NBTTagCompound)RandomHelper.getRandomElementFromList(array);
        return PixelmonMethods.getID(nbt);
    }

    public int getTicksTillEncounter() {
        return this.ticksTillEncounter;
    }

    public void updateTicksTillEncounter() {
        this.ticksTillEncounter = this.ticksTillEncounter <= 1 ? this.getPlayer().func_70681_au().nextInt(900) + 100 : --this.ticksTillEncounter;
    }

    public void randomizePokemon() {
        int highestLevel = this.getHighestLevel();
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            EntityPixelmon newPokemon = (EntityPixelmon)PixelmonEntityList.createEntityByName(EnumPokemon.randomPoke().name, this.getPlayer().field_70170_p);
            newPokemon.getLvl().setLevel(highestLevel);
            newPokemon.friendship.initFromCapture();
            this.addToParty(newPokemon, i);
        }
    }

    public void removeFromPartyPlayer(int slot) {
        if (this.partyPokemon[slot] != null) {
            Pixelmon.network.sendTo((IMessage)new Remove(PixelmonMethods.getID(this.partyPokemon[slot])), this.getPlayer());
            this.partyPokemon[slot] = null;
        }
    }

    public void removeFromPartyTrainer(int slot) {
        int numPokemon = this.count();
        if (this.partyPokemon[slot] != null) {
            for (int i = slot + 1; i < numPokemon; ++i) {
                this.partyPokemon[i - 1] = this.partyPokemon[i];
            }
            this.partyPokemon[numPokemon - 1] = null;
        }
    }

    public PixelmonData[] convertToData() {
        PixelmonData[] data = new PixelmonData[6];
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] == null) continue;
            data[i] = new PixelmonData(this.partyPokemon[i]);
        }
        return data;
    }

    public void setInWorld(EntityPixelmon t, boolean b) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] == null || !PixelmonMethods.isIDSame(this.partyPokemon[i], t)) continue;
            this.isInWorld[i] = b;
        }
    }

    public void setInWorld(int[] pokemonId, boolean b) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] == null || !PixelmonMethods.isIDSame(this.partyPokemon[i], pokemonId)) continue;
            this.isInWorld[i] = b;
        }
    }

    public boolean isInWorld(int[] pokemonId) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            if (this.partyPokemon[i] == null || !PixelmonMethods.isIDSame(this.partyPokemon[i], pokemonId)) continue;
            return this.isInWorld[i];
        }
        return false;
    }

    public boolean isEvolving(World world) {
        for (int i = 0; i < this.partyPokemon.length; ++i) {
            Optional<EntityPixelmon> pokemon;
            if (!this.isInWorld[i] || this.partyPokemon[i] == null || !(pokemon = this.getAlreadyExists(PixelmonMethods.getID(this.partyPokemon[i]), world)).isPresent() || !pokemon.get().isEvolving()) continue;
            return true;
        }
        return false;
    }
}

