/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.ExternalMoveEvent;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ExternalMove;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.externalMoves.ExternalMoveBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExternalMoveData {
    public int moveIndex;
    private ExternalMoveBase move;
    public long timeLastUsed;

    public ExternalMoveData(int moveIndex, ExternalMoveBase move) {
        this.moveIndex = moveIndex;
        this.move = move;
    }

    public void execute(EntityPlayerMP user, EntityPixelmon pixelmon, RayTraceResult objPos) {
        ExternalMoveEvent.PreparingMove externalMoveEvent = new ExternalMoveEvent.PreparingMove(user, pixelmon, this.move, objPos);
        if (Pixelmon.EVENT_BUS.post((Event)externalMoveEvent)) {
            return;
        }
        long worldTime = pixelmon.field_70170_p.func_82737_E();
        this.timeLastUsed = Math.min(this.timeLastUsed, worldTime);
        if (worldTime > this.timeLastUsed + (long)externalMoveEvent.getCooldown() && this.move.execute(pixelmon, externalMoveEvent.getTarget(), this.moveIndex)) {
            this.timeLastUsed = worldTime;
            Pixelmon.network.sendTo((IMessage)new ExternalMove(pixelmon.getPokemonId(), this.moveIndex, this.timeLastUsed), user);
        }
    }

    public ExternalMoveBase getBaseExternalMove() {
        return this.move;
    }

    public double getTargetDistance() {
        return this.move.getTargetDistance();
    }
}

