/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.structure;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.worldGeneration.structure.StructureInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.GymInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.WorldGymData;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.WorldGymInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.standalone.StandaloneStructureInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.towns.ComponentTownPart;
import com.pixelmonmod.pixelmon.worldGeneration.structure.towns.NPCPlacementInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.towns.TownStructureInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.towns.VillagePartHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class StructureRegistry {
    public static ArrayList<TownStructureInfo> townStructures = new ArrayList();
    public static ArrayList<StandaloneStructureInfo> standaloneStructures = new ArrayList();
    public static ArrayList<GymInfo> gyms = new ArrayList();
    public static HashMap<Biome, ArrayList<StandaloneStructureInfo>> structuresByBiome = new HashMap();
    public static ArrayList<String> structureIds = new ArrayList();

    public static void registerStructures() throws Exception {
        JsonObject strucel;
        int i;
        JsonArray jsonarray;
        InputStream istream;
        JsonObject json;
        Pixelmon.LOGGER.info("Registering structures.");
        String path = Pixelmon.modDirectory + "/pixelmon/structures/";
        File structuresDir = new File(path);
        if (PixelmonConfig.useExternalJSONFilesStructures && !structuresDir.isDirectory()) {
            Pixelmon.LOGGER.info("Creating structures directory.");
            File baseDir = new File(Pixelmon.modDirectory + "/pixelmon");
            if (!baseDir.isDirectory()) {
                baseDir.mkdir();
            }
            structuresDir.mkdir();
            StructureRegistry.extractStructuresDir(structuresDir);
        }
        if ((json = new JsonParser().parse((Reader)new InputStreamReader(istream = !PixelmonConfig.useExternalJSONFilesStructures ? StructureRegistry.class.getResourceAsStream("/assets/pixelmon/structures/structures.json") : new FileInputStream(new File(structuresDir, "structures.json")), StandardCharsets.UTF_8)).getAsJsonObject()).has("towns")) {
            jsonarray = JsonUtils.func_151214_t((JsonObject)json, (String)"towns");
            for (i = 0; i < jsonarray.size(); ++i) {
                JsonObject townel = jsonarray.get(i).getAsJsonObject();
                String structureName = townel.get("id").getAsString();
                if (!PixelmonConfig.spawnPokemarts && structureName.equals("townmart1")) continue;
                try {
                    StructureRegistry.registerTownStructure(townel, path + "towns/");
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Failed to load town structure " + townel.get("id").getAsString() + ".", e);
                }
            }
            MapGenStructureIO.func_143031_a(ComponentTownPart.class, (String)"TownPart");
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillagePartHandler());
        }
        if (json.has("gyms")) {
            jsonarray = JsonUtils.func_151214_t((JsonObject)json, (String)"gyms");
            for (i = 0; i < jsonarray.size(); ++i) {
                strucel = jsonarray.get(i).getAsJsonObject();
                try {
                    StructureRegistry.registerGym(strucel, path + "gyms/");
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Failed to load gym: " + strucel.get("id").getAsString() + ".", e);
                }
            }
        }
        if (json.has("standalone")) {
            jsonarray = JsonUtils.func_151214_t((JsonObject)json, (String)"standalone");
            for (i = 0; i < jsonarray.size(); ++i) {
                strucel = jsonarray.get(i).getAsJsonObject();
                try {
                    StructureRegistry.registerStandaloneStructure(strucel, path + "standAlone/");
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Failed to load standalone structure " + strucel.get("id").getAsString() + ".", e);
                }
            }
        }
    }

    private static void extractStructuresDir(File structuresDir) {
        String filename;
        int i;
        JsonArray jsonarray;
        InputStream istream = StructureRegistry.class.getResourceAsStream("/assets/pixelmon/structures/structures.json");
        StructureRegistry.extractFile("/assets/pixelmon/structures/structures.json", structuresDir, "structures.json");
        JsonObject json = new JsonParser().parse((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8)).getAsJsonObject();
        if (json.has("towns")) {
            File townsDir = new File(structuresDir, "towns");
            townsDir.mkdir();
            jsonarray = JsonUtils.func_151214_t((JsonObject)json, (String)"towns");
            for (i = 0; i < jsonarray.size(); ++i) {
                JsonObject townel = jsonarray.get(i).getAsJsonObject();
                filename = townel.get("filename").getAsString();
                StructureRegistry.extractFile("/assets/pixelmon/structures/towns/" + filename, townsDir, filename);
            }
        }
        if (json.has("gyms")) {
            File gymsDir = new File(structuresDir, "gyms");
            gymsDir.mkdir();
            jsonarray = JsonUtils.func_151214_t((JsonObject)json, (String)"gyms");
            for (i = 0; i < jsonarray.size(); ++i) {
                JsonObject gymel = jsonarray.get(i).getAsJsonObject();
                filename = gymel.get("filename").getAsString();
                StructureRegistry.extractFile("/assets/pixelmon/structures/gyms/" + filename, gymsDir, filename);
                String npcfilename = gymel.get("npcdata").getAsString();
                StructureRegistry.extractFile("/assets/pixelmon/structures/gyms/" + npcfilename, gymsDir, npcfilename);
            }
        }
        if (json.has("standalone")) {
            File standAloneDir = new File(structuresDir, "standAlone");
            standAloneDir.mkdir();
            jsonarray = JsonUtils.func_151214_t((JsonObject)json, (String)"standalone");
            for (i = 0; i < jsonarray.size(); ++i) {
                JsonObject strucel = jsonarray.get(i).getAsJsonObject();
                filename = strucel.get("filename").getAsString();
                StructureRegistry.extractFile("/assets/pixelmon/structures/standAlone/" + filename, standAloneDir, filename);
            }
        }
    }

    private static void extractFile(String resourceName, File dir, String filename) {
        try {
            File file = new File(dir, filename);
            if (!file.exists()) {
                int nBytes;
                InputStream link = ServerNPCRegistry.class.getResourceAsStream(resourceName);
                BufferedInputStream in = new BufferedInputStream(link);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buffer = new byte[2048];
                while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, nBytes);
                }
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void registerStandaloneStructure(JsonObject strucObj, String path) throws IOException {
        StandaloneStructureInfo info = new StandaloneStructureInfo();
        String id = strucObj.get("id").getAsString();
        if (!PixelmonConfig.spawnBirdShrines && id.contains("shrine")) {
            return;
        }
        info.setId(id);
        structureIds.add(id);
        if (strucObj.has("depth")) {
            int depth = strucObj.get("depth").getAsInt();
            info.setDepth(depth);
        }
        String filename = strucObj.get("filename").getAsString();
        if (!PixelmonConfig.useExternalJSONFilesStructures) {
            info.setSnapshot(StructureRegistry.loadSnapshot(StructureRegistry.class.getResourceAsStream("/assets/pixelmon/structures/standAlone/" + filename)));
        } else {
            info.setSnapshot(StructureRegistry.loadSnapshot(path + filename));
        }
        int rarity = strucObj.get("rarity").getAsInt();
        info.setRarity(rarity);
        if (strucObj.has("biomes")) {
            JsonArray biomeArray = strucObj.get("biomes").getAsJsonArray();
            for (int i = 0; i < biomeArray.size(); ++i) {
                info.addBiome(WorldHelper.demandBiome(biomeArray.get(i).getAsString()));
            }
        }
        if (strucObj.has("npcs")) {
            JsonArray npcsArray = strucObj.getAsJsonArray("npcs");
            for (int j = 0; j < npcsArray.size(); ++j) {
                JsonObject npcsObj = npcsArray.get(j).getAsJsonObject();
                EnumNPCType type = EnumNPCType.getFromString(npcsObj.get("type").getAsString());
                int x = npcsObj.get("x").getAsInt();
                int y = npcsObj.get("y").getAsInt();
                int z = npcsObj.get("z").getAsInt();
                NPCPlacementInfo npcInfo = new NPCPlacementInfo(type, x, y, z);
                if (npcsObj.has("data")) {
                    npcInfo.setData(npcsObj.get("data").getAsString());
                }
                info.addNPC(npcInfo);
            }
        }
        for (Biome biome : info.getBiomes()) {
            ArrayList<Object> structures = structuresByBiome.containsKey(biome) ? structuresByBiome.get(biome) : new ArrayList();
            structures.add(info);
            structuresByBiome.put(biome, structures);
        }
        standaloneStructures.add(info);
    }

    private static void registerGym(JsonObject strucObj, String path) throws Exception {
        GymInfo info = new GymInfo();
        String id = strucObj.get("id").getAsString();
        info.setId(id);
        structureIds.add(id);
        if (strucObj.has("depth")) {
            int depth = strucObj.get("depth").getAsInt();
            info.setDepth(depth);
        }
        String filename = strucObj.get("filename").getAsString();
        String npcfilename = strucObj.get("npcdata").getAsString();
        if (!PixelmonConfig.useExternalJSONFilesStructures) {
            info.setSnapshot(StructureRegistry.loadSnapshot(StructureRegistry.class.getResourceAsStream("/assets/pixelmon/structures/gyms/" + filename)));
            info.setGymInfo(npcfilename, StructureRegistry.class.getResourceAsStream("/assets/pixelmon/structures/gyms/" + npcfilename));
        } else {
            info.setSnapshot(StructureRegistry.loadSnapshot(path + filename));
            info.setGymInfo(npcfilename, new FileInputStream(path + npcfilename));
        }
        if (strucObj.has("npcs")) {
            JsonArray npcsArray = strucObj.getAsJsonArray("npcs");
            for (int j = 0; j < npcsArray.size(); ++j) {
                JsonObject npcsObj = npcsArray.get(j).getAsJsonObject();
                EnumNPCType type = EnumNPCType.getFromString(npcsObj.get("type").getAsString());
                int x = npcsObj.get("x").getAsInt();
                int y = npcsObj.get("y").getAsInt();
                int z = npcsObj.get("z").getAsInt();
                NPCPlacementInfo npcInfo = new NPCPlacementInfo(type, x, y, z);
                if (npcsObj.has("data")) {
                    npcInfo.setData(npcsObj.get("data").getAsString());
                }
                info.addNPC(npcInfo);
            }
        }
        gyms.add(info);
    }

    private static void registerTownStructure(JsonObject townObj, String path) throws IOException {
        TownStructureInfo info = new TownStructureInfo();
        String id = townObj.get("id").getAsString();
        info.setId(id);
        structureIds.add(id);
        int weighting = townObj.get("weighting").getAsInt();
        info.setWeighting(weighting);
        int maxNum = townObj.get("maxnum").getAsInt();
        info.setMaxNum(maxNum);
        VillagePartHandler.weightSum += weighting;
        VillagePartHandler.numCompSum += maxNum;
        if (townObj.has("depth")) {
            int depth = townObj.get("depth").getAsInt();
            info.setDepth(depth);
        }
        String filename = townObj.get("filename").getAsString();
        if (!PixelmonConfig.useExternalJSONFilesStructures) {
            info.setSnapshot(StructureRegistry.loadSnapshot(StructureRegistry.class.getResourceAsStream("/assets/pixelmon/structures/towns/" + filename)));
        } else {
            info.setSnapshot(StructureRegistry.loadSnapshot(path + filename));
        }
        if (townObj.has("npcs")) {
            JsonArray npcsArray = townObj.getAsJsonArray("npcs");
            for (int j = 0; j < npcsArray.size(); ++j) {
                JsonObject npcsObj = npcsArray.get(j).getAsJsonObject();
                EnumNPCType type = EnumNPCType.getFromString(npcsObj.get("type").getAsString());
                int x = npcsObj.get("x").getAsInt();
                int y = npcsObj.get("y").getAsInt();
                int z = npcsObj.get("z").getAsInt();
                NPCPlacementInfo npcInfo = new NPCPlacementInfo(type, x, y, z);
                if (npcsObj.has("data")) {
                    npcInfo.setData(npcsObj.get("data").getAsString());
                }
                info.addNPC(npcInfo);
            }
        }
        townStructures.add(info);
    }

    private static NBTTagCompound loadSnapshot(String snapshotPath) throws IOException {
        return StructureRegistry.loadSnapshot(new FileInputStream(new File(snapshotPath)));
    }

    private static NBTTagCompound loadSnapshot(InputStream stream) throws IOException {
        return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(stream));
    }

    public static StructureInfo getByID(String id) {
        for (StructureInfo structureInfo : townStructures) {
            if (!id.equalsIgnoreCase(structureInfo.id)) continue;
            return structureInfo;
        }
        for (StructureInfo structureInfo : standaloneStructures) {
            if (!id.equalsIgnoreCase(structureInfo.id)) continue;
            return structureInfo;
        }
        for (StructureInfo structureInfo : gyms) {
            if (!id.equalsIgnoreCase(structureInfo.id)) continue;
            return structureInfo;
        }
        return null;
    }

    public static StructureInfo getRandomTownPiece(Random random, List pieces) throws Exception {
        int weightSum = 0;
        for (TownStructureInfo info : townStructures) {
            if (!info.canPlaceMore(pieces)) continue;
            weightSum += info.getWeight();
        }
        int weight = random.nextInt(weightSum);
        int count = 0;
        for (TownStructureInfo info : townStructures) {
            if (!info.canPlaceMore(pieces) || weight > (count += info.getWeight())) continue;
            return info;
        }
        throw new Exception("Couldn't get a random structure for town generation.");
    }

    public static StandaloneStructureInfo getScatteredStructureFromBiome(Random random, Biome biomeGenForCoords) {
        ArrayList<StandaloneStructureInfo> possibleStructures = null;
        possibleStructures = structuresByBiome.get(biomeGenForCoords);
        if (possibleStructures != null && !possibleStructures.isEmpty()) {
            int weightSum = 0;
            for (StandaloneStructureInfo info : possibleStructures) {
                weightSum += info.getRarity();
            }
            if (weightSum == 0) {
                return null;
            }
            int weight = random.nextInt(weightSum);
            int count = 0;
            for (StandaloneStructureInfo info : possibleStructures) {
                if (weight > (count += info.getRarity())) continue;
                return info;
            }
        }
        return null;
    }

    public static GymInfo getNextGym(WorldGymData data, Random random) {
        ArrayList<WorldGymInfo> gymList = data.getGymList();
        ArrayList reducedList = (ArrayList)gyms.clone();
        block0: for (int i = 0; i < reducedList.size(); ++i) {
            for (WorldGymInfo info : gymList) {
                if (!info.name.equals(((GymInfo)reducedList.get((int)i)).name)) continue;
                reducedList.remove(i);
                --i;
                continue block0;
            }
        }
        if (reducedList.size() == 0) {
            return null;
        }
        GymInfo gyminfo = (GymInfo)RandomHelper.getRandomElementFromList(reducedList);
        return gyminfo;
    }
}

