/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.wall;

import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.climate.IClimateSource;
import forestry.greenhouse.api.climate.IClimateSourceOwner;
import forestry.greenhouse.api.greenhouse.GreenhouseManager;
import forestry.greenhouse.api.greenhouse.IBlankBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlockHandler;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.api.greenhouse.IWallBlock;
import forestry.greenhouse.api.greenhouse.Position2D;
import forestry.greenhouse.multiblock.blocks.GreenhouseBlock;
import forestry.greenhouse.multiblock.blocks.wall.WallBlockHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class WallBlock
extends GreenhouseBlock<IBlankBlock>
implements IWallBlock {
    private final List<IClimateSource> sources = new ArrayList<IClimateSource>();

    public WallBlock(IGreenhouseProvider manager, BlockPos pos) {
        super(manager, pos);
    }

    @Override
    public void setRoot(IBlankBlock parent) {
        this.root = parent;
    }

    @Override
    public void onCreate() {
        IClimateContainer container = this.provider.getClimateContainer();
        for (IClimateSourceOwner sourceOwner : GreenhouseManager.climateManager.getSources(this.provider.getWorld(), new Position2D((Vec3i)this.pos))) {
            IClimateSource source = sourceOwner.getClimateSource();
            this.sources.add(source);
            container.addClimateSource(source);
            source.onAdded(container);
        }
    }

    @Override
    public void onRemove() {
        IClimateContainer container = this.provider.getClimateContainer();
        Iterator<IClimateSource> iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            IClimateSource source = iterator.next();
            source.onRemoved(container);
            container.removeClimateSource(source);
            iterator.remove();
        }
    }

    @Override
    public void add(IClimateSource source) {
        this.sources.add(source);
    }

    @Override
    public IGreenhouseBlockHandler getHandler() {
        return WallBlockHandler.getInstance();
    }
}

