/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import forestry.Forestry;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.StorageManager;
import forestry.core.config.Constants;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.utils.IMCUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import forestry.storage.CrateRegistry;
import forestry.storage.items.ItemCrated;
import forestry.storage.items.ItemRegistryCrates;
import forestry.storage.models.ModelCrate;
import forestry.storage.proxy.ProxyStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@ForestryModule(moduleID="crates", containerID="forestry", name="Crate", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.crates.description")
public class ModuleCrates
extends BlankForestryModule {
    private static final String CONFIG_CATEGORY = "crates";
    public static final List<String> cratesRejectedOreDict = new ArrayList<String>();
    public static Multimap<Item, ItemStack> cratesRejectedItem = HashMultimap.create();
    private static final List<ItemCrated> crates = new ArrayList<ItemCrated>();
    @SidedProxy(clientSide="forestry.storage.proxy.ProxyStorageClient", serverSide="forestry.storage.proxy.ProxyStorage")
    public static ProxyStorage proxy;
    @Nullable
    private static ItemRegistryCrates items;

    public static ItemRegistryCrates getItems() {
        Preconditions.checkNotNull((Object)items);
        return items;
    }

    @Override
    public void setupAPI() {
        StorageManager.crateRegistry = new CrateRegistry();
        proxy.registerCrateModel();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryCrates();
    }

    @Override
    public void preInit() {
        boolean deleted;
        MinecraftForge.EVENT_BUS.register((Object)this);
        String newConfig = "crates.cfg";
        File configFile = new File(Forestry.instance.getConfigFolder(), "crates.cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        if (!config.getDefinedConfigVersion().equals(config.getLoadedConfigVersion()) && (deleted = configFile.delete())) {
            config = new LocalizedConfiguration(configFile, "1.0.0");
        }
        this.handleConfig(config);
        config.save();
    }

    private void handleConfig(LocalizedConfiguration config) {
        String[] crateItemList = config.getStringListLocalized("crates.items", "accepted", Constants.EMPTY_STRINGS);
        List<ItemStack> crateItems = ItemStackUtil.parseItemStackStrings(crateItemList, Short.MAX_VALUE);
        for (ItemStack crateItem : crateItems) {
            StorageManager.crateRegistry.registerCrate(crateItem);
        }
        crateItemList = config.getStringListLocalized("crates.items", "rejected", Constants.EMPTY_STRINGS);
        for (ItemStack stack : ItemStackUtil.parseItemStackStrings(crateItemList, Short.MAX_VALUE)) {
            cratesRejectedItem.put((Object)stack.func_77973_b(), (Object)stack);
        }
        String[] crateOreDictList = config.getStringListLocalized("crates.oredict", "accepted", Constants.EMPTY_STRINGS);
        for (String name : OreDictionary.getOreNames()) {
            if (name == null) {
                Log.error("Found a null oreName in the ore dictionary", new Object[0]);
                continue;
            }
            for (String regex : crateOreDictList) {
                if (!name.matches(regex)) continue;
                StorageManager.crateRegistry.registerCrate(name);
            }
        }
        crateOreDictList = config.getStringListLocalized("crates.oredict", "rejected", Constants.EMPTY_STRINGS);
        for (String name : OreDictionary.getOreNames()) {
            if (name == null) {
                Log.error("Found a null oreName in the ore dictionary", new Object[0]);
                continue;
            }
            for (String regex : crateOreDictList) {
                if (!name.matches(regex)) continue;
                cratesRejectedOreDict.add(name);
            }
        }
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-crate-items")) {
            ItemStack value = message.getItemStackValue();
            if (value != null) {
                StorageManager.crateRegistry.registerCrate(value);
            } else {
                IMCUtil.logInvalidIMCMessage(message);
            }
            return true;
        }
        if (message.key.equals("add-crate-oredict")) {
            String value = message.getStringValue();
            StorageManager.crateRegistry.registerCrate(value);
            return true;
        }
        if (message.key.equals("blacklist-crate-item")) {
            ItemStack value = message.getItemStackValue();
            if (value != null) {
                cratesRejectedItem.put((Object)value.func_77973_b(), (Object)value);
            } else {
                IMCUtil.logInvalidIMCMessage(message);
            }
            return true;
        }
        if (message.key.equals("blacklist-crate-oredict")) {
            cratesRejectedOreDict.add(message.getStringValue());
            return true;
        }
        return false;
    }

    @Override
    public Set<ResourceLocation> getDependencyUids() {
        return ImmutableSet.of((Object)new ResourceLocation("forestry", "core"));
    }

    @Override
    public void registerRecipes() {
        ItemRegistryCrates items = ModuleCrates.getItems();
        if (ModuleHelper.isEnabled("factory")) {
            RecipeManagers.carpenterManager.addRecipe(20, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, items.crate.getItemStack(24), " # ", "# #", " # ", Character.valueOf('#'), "logWood");
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBakeModel(ModelBakeEvent event) {
        ModelCrate.onModelBake(event);
    }

    public static void registerCrate(ItemCrated crate) {
        crates.add(crate);
    }

    public static void createCrateRecipes() {
        for (ItemCrated crate : crates) {
            ItemStack crateStack = new ItemStack((Item)crate);
            ItemStack uncrated = crate.getContained();
            if (uncrated.func_190926_b()) continue;
            if (crate.getOreDictName() != null) {
                ModuleCrates.addCrating(crateStack, crate.getOreDictName());
            } else {
                ModuleCrates.addCrating(crateStack, uncrated);
            }
            ModuleCrates.addUncrating(crateStack, uncrated);
        }
    }

    private static void addCrating(ItemStack crateStack, Object uncrated) {
        FluidStack water = new FluidStack(FluidRegistry.WATER, 100);
        ItemStack box = ModuleCrates.getItems().crate.getItemStack();
        RecipeManagers.carpenterManager.addRecipe(5, water, box, crateStack, "###", "###", "###", Character.valueOf('#'), uncrated);
    }

    private static void addUncrating(ItemStack crateStack, ItemStack uncrated) {
        ItemStack product = new ItemStack(uncrated.func_77973_b(), 9, uncrated.func_77952_i());
        RecipeManagers.carpenterManager.addRecipe(5, ItemStack.field_190927_a, product, "#", Character.valueOf('#'), crateStack);
    }
}

