/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mods.jei;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mods.jei.JEI;
import crafttweaker.mods.jei.JEIAddonPlugin;
import crafttweaker.mods.jei.commands.ConflictCommand;
import crafttweaker.mods.jei.recipeWrappers.BrewingRecipeCWrapper;
import crafttweaker.mods.jei.recipeWrappers.CraftingRecipeWrapperShaped;
import crafttweaker.mods.jei.recipeWrappers.CraftingRecipeWrapperShapeless;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;

@Mod(modid="crafttweakerjei", name="CraftTweaker JEI Support", version="2.0.2", dependencies="after:jei;", acceptedMinecraftVersions="[1.12, 1.13)")
public class JEIMod {
    @Mod.EventHandler
    public void onFMLLoadComplete(FMLLoadCompleteEvent event) {
        if (Loader.isModLoaded((String)"jei")) {
            try {
                JEI.LATE_ACTIONS_PRE.forEach(CraftTweakerAPI::apply);
                JEI.LATE_ACTIONS_POST.forEach(CraftTweakerAPI::apply);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!JEI.HIDDEN_ITEMS.isEmpty()) {
                JEIAddonPlugin.itemRegistry.removeIngredientsAtRuntime(ItemStack.class, JEI.HIDDEN_ITEMS);
            }
            if (!JEI.HIDDEN_LIQUIDS.isEmpty()) {
                JEIAddonPlugin.itemRegistry.removeIngredientsAtRuntime(FluidStack.class, JEI.HIDDEN_LIQUIDS);
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (Loader.isModLoaded((String)"jei")) {
            CTChatCommand.registerCommand(new ConflictCommand());
        } else {
            CTChatCommand.registerCommand(new CraftTweakerCommand("conflict"){

                @Override
                protected void init() {
                    this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct conflict", "/ct conflict", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all conflicting crafting recipes in the game"), SpecialMessagesChat.getNormalMessage(" \u00a73Might take a bit of time depending on the size of the pack"), SpecialMessagesChat.getNormalMessage(" \u00a73This needs to be run on a client and with JEI installed"));
                }

                @Override
                public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                    sender.func_145747_a(SpecialMessagesChat.getNormalMessage("\u00a74This Command needs to be run with JEI installed"));
                }
            });
        }
    }

    public static void onRegistered() {
        try {
            JEI.DESCRIPTIONS.forEach(CraftTweakerAPI::apply);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BrewingRecipeCWrapper.registerBrewingRecipe();
        CraftingRecipeWrapperShapeless.registerCraftingRecipes();
        CraftingRecipeWrapperShaped.registerCraftingRecipes();
    }
}

