/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.attributed;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.attributed.AttributedConfigurationNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleAttributedConfigurationNode
extends SimpleConfigurationNode
implements AttributedConfigurationNode {
    private String tagName;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public static @NonNull SimpleAttributedConfigurationNode root() {
        return SimpleAttributedConfigurationNode.root("root", ConfigurationOptions.defaults());
    }

    public static @NonNull SimpleAttributedConfigurationNode root(@NonNull String tagName) {
        return SimpleAttributedConfigurationNode.root(tagName, ConfigurationOptions.defaults());
    }

    public static @NonNull SimpleAttributedConfigurationNode root(@NonNull String tagName, @NonNull ConfigurationOptions options) {
        return new SimpleAttributedConfigurationNode(tagName, null, null, options);
    }

    protected SimpleAttributedConfigurationNode(@NonNull String tagName, @Nullable Object path, @Nullable SimpleConfigurationNode parent, @NonNull ConfigurationOptions options) {
        super(path, parent, options);
        this.tagName = tagName;
    }

    @Override
    public @NonNull String getTagName() {
        return this.tagName;
    }

    @Override
    public @NonNull SimpleAttributedConfigurationNode setTagName(@NonNull String tagName) {
        if (Strings.isNullOrEmpty((String)tagName)) {
            throw new IllegalArgumentException("Tag name cannot be null/empty");
        }
        this.tagName = tagName;
        return this;
    }

    @Override
    public @NonNull SimpleAttributedConfigurationNode addAttribute(@NonNull String name, @NonNull String value) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Attribute name cannot be null/empty");
        }
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public @NonNull SimpleAttributedConfigurationNode removeAttribute(@NonNull String name) {
        this.attributes.remove(name);
        return this;
    }

    @Override
    public @NonNull SimpleAttributedConfigurationNode setAttributes(@NonNull Map<String, String> attributes) {
        for (String name : attributes.keySet()) {
            if (!Strings.isNullOrEmpty((String)name)) continue;
            throw new IllegalArgumentException("Attribute name cannot be null/empty");
        }
        this.attributes.clear();
        this.attributes.putAll(attributes);
        return this;
    }

    @Override
    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    @Override
    public @Nullable String getAttribute(@NonNull String name) {
        return this.attributes.get(name);
    }

    @Override
    public @NonNull Map<String, String> getAttributes() {
        return ImmutableMap.copyOf(this.attributes);
    }

    @Override
    public @Nullable SimpleAttributedConfigurationNode getParent() {
        return (SimpleAttributedConfigurationNode)super.getParent();
    }

    @Override
    protected SimpleAttributedConfigurationNode createNode(Object path) {
        return new SimpleAttributedConfigurationNode("element", path, this, this.getOptions());
    }

    @Override
    public @NonNull SimpleAttributedConfigurationNode setValue(@Nullable Object value) {
        if (value instanceof AttributedConfigurationNode) {
            AttributedConfigurationNode node = (AttributedConfigurationNode)value;
            this.setTagName(node.getTagName());
            this.setAttributes((Map)node.getAttributes());
        }
        return (SimpleAttributedConfigurationNode)super.setValue(value);
    }

    @Override
    public @NonNull SimpleAttributedConfigurationNode mergeValuesFrom(@NonNull ConfigurationNode other) {
        if (other instanceof AttributedConfigurationNode) {
            AttributedConfigurationNode node = (AttributedConfigurationNode)other;
            this.setTagName(node.getTagName());
            for (Map.Entry<String, String> attribute : node.getAttributes().entrySet()) {
                this.addAttribute(attribute.getKey(), attribute.getValue());
            }
        }
        return (SimpleAttributedConfigurationNode)super.mergeValuesFrom(other);
    }

    @Override
    public @NonNull SimpleAttributedConfigurationNode getNode(Object ... path) {
        return (SimpleAttributedConfigurationNode)super.getNode(path);
    }

    public @NonNull List<? extends SimpleAttributedConfigurationNode> getChildrenList() {
        return super.getChildrenList();
    }

    public @NonNull Map<Object, ? extends SimpleAttributedConfigurationNode> getChildrenMap() {
        return super.getChildrenMap();
    }

    @Override
    public @NonNull SimpleAttributedConfigurationNode getAppendedNode() {
        return (SimpleAttributedConfigurationNode)super.getAppendedNode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleAttributedConfigurationNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleAttributedConfigurationNode that = (SimpleAttributedConfigurationNode)o;
        return this.tagName.equals(that.tagName) && this.attributes.equals(that.attributes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.tagName.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SimpleAttributedConfigurationNode{super=" + super.toString() + ", tagName=" + this.tagName + ", attributes=" + this.attributes + '}';
    }
}

